/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.fabric;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterDhInitEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDhInitEvent;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IBCLibAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IIrisAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IStarlightAccessor;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.fabric.wrappers.FabricDependencySetup;
import com.seibel.distanthorizons.fabric.wrappers.modAccessor.BCLibAccessor;
import com.seibel.distanthorizons.fabric.wrappers.modAccessor.IrisAccessor;
import com.seibel.distanthorizons.fabric.wrappers.modAccessor.OptifineAccessor;
import com.seibel.distanthorizons.fabric.wrappers.modAccessor.SodiumAccessor;
import com.seibel.distanthorizons.fabric.wrappers.modAccessor.StarlightAccessor;
import javax.swing.JOptionPane;
import loaderCommon.fabric.com.seibel.distanthorizons.common.LodCommonMain;
import org.apache.logging.log4j.Logger;

public class FabricMain {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public static void postInit() {
        LOGGER.info("Post-Initializing Mod");
        FabricDependencySetup.runDelayedSetup();
        if (Config.Client.Advanced.Graphics.Fog.disableVanillaFog.get().booleanValue() && SingletonInjector.INSTANCE.get(IModChecker.class).isModLoaded("bclib")) {
            ModAccessorInjector.INSTANCE.get(IBCLibAccessor.class).setRenderCustomFog(false);
        }
        if (ConfigBase.INSTANCE == null) {
            throw new IllegalStateException("Config was not initialized. Make sure to call LodCommonMain.initConfig() before calling this method.");
        }
        LOGGER.info("Mod Post-Initialized");
    }

    public static void init() {
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        LOGGER.info("Initializing Mod");
        LodCommonMain.startup(null);
        FabricDependencySetup.createInitialBindings();
        LOGGER.info("Distant Horizons, Version: 2.0.1-a");
        LOGGER.info("DH Branch: " + ModJarInfo.Git_Branch);
        LOGGER.info("DH Commit: " + ModJarInfo.Git_Commit);
        LOGGER.info("DH Jar Build Source: " + ModJarInfo.Build_Source);
        IModChecker modChecker = SingletonInjector.INSTANCE.get(IModChecker.class);
        if (modChecker.isModLoaded("sodium")) {
            ModAccessorInjector.INSTANCE.bind((Class<? extends IModAccessor>)ISodiumAccessor.class, new SodiumAccessor());
            if (!modChecker.isModLoaded("indium")) {
                System.setProperty("java.awt.headless", "false");
                JOptionPane.showMessageDialog(null, "Distant Horizons now relies on Indium to work with Sodium.\nPlease download Indium from https://modrinth.com/mod/indium", "Distant Horizons", 1);
                IMinecraftClientWrapper mc = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
                String errorMessage = "loading Distant Horizons. Distant Horizons requires Indium in order to run with Sodium.";
                String exceptionError = "Distant Horizons conditional mod Exception";
                mc.crashMinecraft(errorMessage, new Exception(exceptionError));
            }
        }
        if (modChecker.isModLoaded("starlight")) {
            ModAccessorInjector.INSTANCE.bind((Class<? extends IModAccessor>)IStarlightAccessor.class, new StarlightAccessor());
        }
        if (modChecker.isModLoaded("optifine")) {
            ModAccessorInjector.INSTANCE.bind((Class<? extends IModAccessor>)IOptifineAccessor.class, new OptifineAccessor());
        }
        if (modChecker.isModLoaded("bclib")) {
            ModAccessorInjector.INSTANCE.bind((Class<? extends IModAccessor>)IBCLibAccessor.class, new BCLibAccessor());
        }
        if (modChecker.isModLoaded("iris")) {
            ModAccessorInjector.INSTANCE.bind((Class<? extends IModAccessor>)IIrisAccessor.class, new IrisAccessor());
        }
        LOGGER.info("Distant Horizons Initialized");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
    }
}

