/*
 * Decompiled with CFR 0.152.
 */
package distanthorizons.libraries.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

public class JAWT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int GETDRAWINGSURFACE;
    public static final int FREEDRAWINGSURFACE;
    public static final int LOCK;
    public static final int UNLOCK;
    public static final int GETCOMPONENT;
    public static final int CREATEEMBEDDEDFRAME;
    public static final int SETBOUNDS;
    public static final int SYNTHESIZEWINDOWACTIVATION;

    public JAWT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), JAWT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="jint")
    public int version() {
        return JAWT.nversion(this.address());
    }

    @NativeType(value="void *")
    public long GetDrawingSurface() {
        return JAWT.nGetDrawingSurface(this.address());
    }

    @NativeType(value="void *")
    public long FreeDrawingSurface() {
        return JAWT.nFreeDrawingSurface(this.address());
    }

    @NativeType(value="void *")
    public long Lock() {
        return JAWT.nLock(this.address());
    }

    @NativeType(value="void *")
    public long Unlock() {
        return JAWT.nUnlock(this.address());
    }

    @NativeType(value="void *")
    public long GetComponent() {
        return JAWT.nGetComponent(this.address());
    }

    @NativeType(value="void *")
    public long CreateEmbeddedFrame() {
        return JAWT.nCreateEmbeddedFrame(this.address());
    }

    @NativeType(value="void *")
    public long SetBounds() {
        return JAWT.nSetBounds(this.address());
    }

    @NativeType(value="void *")
    public long SynthesizeWindowActivation() {
        return JAWT.nSynthesizeWindowActivation(this.address());
    }

    public JAWT version(@NativeType(value="jint") int value) {
        JAWT.nversion(this.address(), value);
        return this;
    }

    public JAWT set(JAWT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static JAWT malloc() {
        return (JAWT)JAWT.wrap(JAWT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static JAWT calloc() {
        return (JAWT)JAWT.wrap(JAWT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static JAWT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (JAWT)JAWT.wrap(JAWT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static JAWT create(long address) {
        return (JAWT)JAWT.wrap(JAWT.class, (long)address);
    }

    @Nullable
    public static JAWT createSafe(long address) {
        return address == 0L ? null : (JAWT)JAWT.wrap(JAWT.class, (long)address);
    }

    @Deprecated
    public static JAWT mallocStack() {
        return JAWT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static JAWT callocStack() {
        return JAWT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static JAWT mallocStack(MemoryStack stack) {
        return JAWT.malloc(stack);
    }

    @Deprecated
    public static JAWT callocStack(MemoryStack stack) {
        return JAWT.calloc(stack);
    }

    public static JAWT malloc(MemoryStack stack) {
        return (JAWT)JAWT.wrap(JAWT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static JAWT calloc(MemoryStack stack) {
        return (JAWT)JAWT.wrap(JAWT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static int nversion(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERSION);
    }

    public static long nGetDrawingSurface(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)GETDRAWINGSURFACE));
    }

    public static long nFreeDrawingSurface(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)FREEDRAWINGSURFACE));
    }

    public static long nLock(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)LOCK));
    }

    public static long nUnlock(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)UNLOCK));
    }

    public static long nGetComponent(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)GETCOMPONENT));
    }

    public static long nCreateEmbeddedFrame(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)CREATEEMBEDDEDFRAME));
    }

    public static long nSetBounds(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SETBOUNDS));
    }

    public static long nSynthesizeWindowActivation(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SYNTHESIZEWINDOWACTIVATION));
    }

    public static void nversion(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERSION, value);
    }

    static {
        Struct.Layout layout = JAWT.__struct((Struct.Member[])new Struct.Member[]{JAWT.__member((int)4), JAWT.__member((int)POINTER_SIZE), JAWT.__member((int)POINTER_SIZE), JAWT.__member((int)POINTER_SIZE), JAWT.__member((int)POINTER_SIZE), JAWT.__member((int)POINTER_SIZE), JAWT.__member((int)POINTER_SIZE), JAWT.__member((int)POINTER_SIZE), JAWT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        GETDRAWINGSURFACE = layout.offsetof(1);
        FREEDRAWINGSURFACE = layout.offsetof(2);
        LOCK = layout.offsetof(3);
        UNLOCK = layout.offsetof(4);
        GETCOMPONENT = layout.offsetof(5);
        CREATEEMBEDDEDFRAME = layout.offsetof(6);
        SETBOUNDS = layout.offsetof(7);
        SYNTHESIZEWINDOWACTIVATION = layout.offsetof(8);
    }
}

