/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.cache;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.util.HashSet;
import java.util.List;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.TextureAtlasSpriteWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.TintGetterOverrideFast;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.TintWithoutLevelOverrider;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.apache.logging.log4j.Logger;

public class ClientBlockStateCache {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final HashSet<class_2680> BLOCK_STATES_THAT_NEED_LEVEL = new HashSet();
    private static final HashSet<class_2680> BROKEN_BLOCK_STATES = new HashSet();
    public static final class_5819 random = class_5819.method_43047();
    public final class_2680 blockState;
    public final class_4538 level;
    public final class_2338 pos;
    boolean isColorResolved = false;
    int baseColor = 0;
    boolean needShade = true;
    boolean needPostTinting = false;
    int tintIndex = 0;
    public static final int FLOWER_COLOR_SCALE = 5;
    private static final class_2350[] DIRECTION_ORDER = new class_2350[]{class_2350.field_11036, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039, class_2350.field_11035, class_2350.field_11033};

    public ClientBlockStateCache(class_2680 blockState, IClientLevelWrapper samplingLevel, DhBlockPos samplingPos) {
        this.blockState = blockState;
        this.level = (class_4538)samplingLevel.getWrappedMcObject();
        this.pos = McObjectConverter.Convert(samplingPos);
        this.resolveColors();
    }

    private static int getWidth(class_1058 texture) {
        return texture.method_4578();
    }

    private static int getHeight(class_1058 texture) {
        return texture.method_4595();
    }

    private static int calculateColorFromTexture(class_1058 texture, ColorMode colorMode) {
        int tempColor;
        int count = 0;
        double alpha = 0.0;
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        for (int u = 0; u < ClientBlockStateCache.getWidth(texture); ++u) {
            for (int v = 0; v < ClientBlockStateCache.getHeight(texture); ++v) {
                tempColor = TextureAtlasSpriteWrapper.getPixelRGBA(texture, 0, u, v);
                double r = (double)(tempColor & 0xFF) / 255.0;
                double g = (double)((tempColor & 0xFF00) >>> 8) / 255.0;
                double b = (double)((tempColor & 0xFF0000) >>> 16) / 255.0;
                double a = (double)((tempColor & 0xFF000000) >>> 24) / 255.0;
                int scale = 1;
                if (colorMode == ColorMode.Leaves) {
                    r *= a;
                    g *= a;
                    b *= a;
                    a = 1.0;
                } else {
                    if (a == 0.0) continue;
                    if (colorMode == ColorMode.Flower && (g + 0.1 < b || g + 0.1 < r)) {
                        scale = 5;
                    }
                }
                count += scale;
                alpha += a * a * (double)scale;
                red += r * r * (double)scale;
                green += g * g * (double)scale;
                blue += b * b * (double)scale;
            }
        }
        tempColor = count == 0 ? ColorUtil.rgbToInt(0, 255, 255, 255) : ColorUtil.rgbToInt((int)(Math.sqrt(alpha / (double)count) * 255.0), (int)(Math.sqrt(red / (double)count) * 255.0), (int)(Math.sqrt(green / (double)count) * 255.0), (int)(Math.sqrt(blue / (double)count) * 255.0));
        return tempColor;
    }

    private void resolveColors() {
        if (this.isColorResolved) {
            return;
        }
        if (this.blockState.method_26227().method_15769()) {
            List quads = null;
            for (class_2350 direction : DIRECTION_ORDER) {
                quads = class_310.method_1551().method_1554().method_4743().method_3335(this.blockState).method_4707(this.blockState, direction, random);
                if (quads != null && !quads.isEmpty() && (!(this.blockState.method_26204() instanceof class_2465) || direction != class_2350.field_11036)) break;
            }
            if (quads == null || quads.isEmpty()) {
                quads = class_310.method_1551().method_1554().method_4743().method_3335(this.blockState).method_4707(this.blockState, null, random);
            }
            if (quads != null && !quads.isEmpty()) {
                this.needPostTinting = ((class_777)quads.get(0)).method_3360();
                this.needShade = ((class_777)quads.get(0)).method_24874();
                this.tintIndex = ((class_777)quads.get(0)).method_3359();
                this.baseColor = ClientBlockStateCache.calculateColorFromTexture(((class_777)quads.get(0)).method_35788(), ColorMode.getColorMode(this.blockState.method_26204()));
            } else {
                this.needPostTinting = false;
                this.needShade = false;
                this.tintIndex = 0;
                this.baseColor = ClientBlockStateCache.calculateColorFromTexture(class_310.method_1551().method_1554().method_4743().method_3339(this.blockState), ColorMode.getColorMode(this.blockState.method_26204()));
            }
        } else {
            this.needPostTinting = true;
            this.needShade = false;
            this.tintIndex = 0;
            this.baseColor = ClientBlockStateCache.calculateColorFromTexture(class_310.method_1551().method_1554().method_4743().method_3339(this.blockState), ColorMode.getColorMode(this.blockState.method_26204()));
        }
        this.isColorResolved = true;
    }

    public int getAndResolveFaceColor(BiomeWrapper biome, DhBlockPos pos) {
        int tintColor;
        block9: {
            if (!this.needPostTinting) {
                return this.baseColor;
            }
            if (BROKEN_BLOCK_STATES.contains(this.blockState)) {
                return this.baseColor;
            }
            tintColor = -1;
            try {
                if (!BLOCK_STATES_THAT_NEED_LEVEL.contains(this.blockState)) {
                    try {
                        tintColor = class_310.method_1551().method_1505().method_1697(this.blockState, (class_1920)new TintWithoutLevelOverrider(biome), McObjectConverter.Convert(pos), this.tintIndex);
                    }
                    catch (UnsupportedOperationException e) {
                        LOGGER.debug("Unable to use [" + TintWithoutLevelOverrider.class.getSimpleName() + "] to get the block tint for block: [" + this.blockState + "] and biome: [" + biome + "] at pos: " + pos + ". Error: [" + e.getMessage() + "]. Attempting to use backup method...", (Throwable)e);
                        BLOCK_STATES_THAT_NEED_LEVEL.add(this.blockState);
                    }
                }
                if (BLOCK_STATES_THAT_NEED_LEVEL.contains(this.blockState)) {
                    tintColor = class_310.method_1551().method_1505().method_1697(this.blockState, (class_1920)new TintGetterOverrideFast(this.level), McObjectConverter.Convert(pos), this.tintIndex);
                }
            }
            catch (Exception e) {
                if (BROKEN_BLOCK_STATES.contains(this.blockState)) break block9;
                LOGGER.warn("Failed to get block color for block: [" + this.blockState + "] and biome: [" + biome + "] at pos: " + pos + ". Error: [" + e.getMessage() + "]. Note: future errors for this block/biome will be ignored.", (Throwable)e);
                BROKEN_BLOCK_STATES.add(this.blockState);
            }
        }
        if (tintColor != -1) {
            return ColorUtil.multiplyARGBwithRGB(this.baseColor, tintColor);
        }
        return this.baseColor;
    }

    static enum ColorMode {
        Default,
        Flower,
        Leaves;


        static ColorMode getColorMode(class_2248 b) {
            if (b instanceof class_2397) {
                return Leaves;
            }
            if (b instanceof class_2356) {
                return Flower;
            }
            return Default;
        }
    }
}

