/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import java.util.Objects;
import java.util.Set;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_2843;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5539;
import net.minecraft.class_6749;
import net.minecraft.class_6755;
import net.minecraft.class_7522;

public class ChunkLoader {
    private static final Codec<class_2841<class_2680>> BLOCK_STATE_CODEC = class_2841.method_44343((class_2359)class_2248.field_10651, (Codec)class_2680.field_24734, (class_2841.class_6563)class_2841.class_6563.field_34569, (Object)class_2246.field_10124.method_9564());
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;

    private static class_6749 readBlendingData(class_2487 chunkData) {
        class_6749 blendingData = null;
        if (chunkData.method_10573("blending_data", 10)) {
            Dynamic blendingDataTag = new Dynamic((DynamicOps)class_2509.field_11560, (Object)chunkData.method_10562("blending_data"));
            blendingData = class_6749.field_35682.parse(blendingDataTag).resultOrPartial(x$0 -> LOGGER.error((String)x$0, new Object[0])).orElse(null);
        }
        return blendingData;
    }

    private static class_2826[] readSections(class_1936 level, class_1923 chunkPos, class_2487 chunkData) {
        class_2378 biomes = level.method_30349().method_30530(class_2378.field_25114);
        Codec biomeCodec = class_2841.method_44343((class_2359)biomes.method_40295(), (Codec)biomes.method_40294(), (class_2841.class_6563)class_2841.class_6563.field_34570, (Object)biomes.method_40290(class_1972.field_9451));
        int i = level.method_32890();
        class_2826[] chunkSections = new class_2826[i];
        boolean isLightOn = chunkData.method_10577("isLightOn");
        boolean hasSkyLight = level.method_8597().comp_642();
        class_2499 tagSections = chunkData.method_10554("Sections", 10);
        if (tagSections.isEmpty()) {
            tagSections = chunkData.method_10554("sections", 10);
        }
        for (int j = 0; j < tagSections.size(); ++j) {
            class_2841 blockStateContainer;
            class_2487 tagSection = tagSections.method_10602(j);
            byte sectionYPos = tagSection.method_10571("Y");
            int sectionId = level.method_31603((int)sectionYPos);
            if (sectionId < 0 || sectionId >= chunkSections.length) continue;
            class_2841 class_28412 = tagSection.method_10573("block_states", 10) ? (class_2841)BLOCK_STATE_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tagSection.method_10562("block_states")).promotePartial(string -> ChunkLoader.logErrors(chunkPos, sectionYPos, string)).getOrThrow(false, x$0 -> LOGGER.error((String)x$0, new Object[0])) : (blockStateContainer = new class_2841((class_2359)class_2248.field_10651, (Object)class_2246.field_10124.method_9564(), class_2841.class_6563.field_34569));
            class_2841 biomeContainer = tagSection.method_10573("biomes", 10) ? (class_2841)biomeCodec.parse((DynamicOps)class_2509.field_11560, (Object)tagSection.method_10562("biomes")).promotePartial(string -> ChunkLoader.logErrors(chunkPos, i, string)).getOrThrow(false, x$0 -> LOGGER.error((String)x$0, new Object[0])) : new class_2841(biomes.method_40295(), (Object)biomes.method_40290(class_1972.field_9451), class_2841.class_6563.field_34570);
            chunkSections[sectionId] = new class_2826((int)sectionYPos, blockStateContainer, (class_7522)biomeContainer);
        }
        return chunkSections;
    }

    private static void readHeightmaps(class_2818 chunk, class_2487 chunkData) {
        class_2487 tagHeightmaps = chunkData.method_10562("Heightmaps");
        for (class_2902.class_2903 type2 : class_2806.field_12803.method_12160()) {
            String heightmap = type2.method_12605();
            if (!tagHeightmaps.method_10573(heightmap, 12)) continue;
            chunk.method_12037(type2, tagHeightmaps.method_10565(heightmap));
        }
        class_2902.method_16684((class_2791)chunk, (Set)class_2806.field_12803.method_12160());
    }

    private static void readPostPocessings(class_2818 chunk, class_2487 chunkData) {
        class_2499 tagPostProcessings = chunkData.method_10554("PostProcessing", 9);
        for (int n = 0; n < tagPostProcessings.size(); ++n) {
            class_2499 listTag3 = tagPostProcessings.method_10603(n);
            for (int o = 0; o < listTag3.size(); ++o) {
                chunk.method_12029(listTag3.method_10609(o), n);
            }
        }
    }

    public static class_2806.class_2808 readChunkType(class_2487 tagLevel) {
        class_2806 chunkStatus = class_2806.method_12168((String)tagLevel.method_10558("Status"));
        if (chunkStatus != null) {
            return chunkStatus.method_12164();
        }
        return class_2806.class_2808.field_12808;
    }

    public static class_2818 read(class_5281 level, class_1923 chunkPos, class_2487 chunkData) {
        class_2487 tagLevel = chunkData;
        class_1923 actualPos = new class_1923(tagLevel.method_10550("xPos"), tagLevel.method_10550("zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            LOGGER.error("Chunk file at {} is in the wrong location; Ignoring. (Expected {}, got {})", chunkPos, chunkPos, actualPos);
            return null;
        }
        class_2806.class_2808 chunkType = ChunkLoader.readChunkType(tagLevel);
        class_6749 blendingData = ChunkLoader.readBlendingData(tagLevel);
        if (chunkType == class_2806.class_2808.field_12808 && blendingData == null) {
            return null;
        }
        long inhabitedTime = tagLevel.method_10537("InhabitedTime");
        class_2843 upgradeData = tagLevel.method_10573(TAG_UPGRADE_DATA, 10) ? new class_2843(tagLevel.method_10562(TAG_UPGRADE_DATA), (class_5539)level) : class_2843.field_12950;
        boolean isLightOn = tagLevel.method_10577("isLightOn");
        class_6755 blockTicks = class_6755.method_39368((class_2499)tagLevel.method_10554(BLOCK_TICKS_TAG_18, 10), string -> class_2378.field_11146.method_17966(class_2960.method_12829((String)string)), (class_1923)chunkPos);
        class_6755 fluidTicks = class_6755.method_39368((class_2499)tagLevel.method_10554(FLUID_TICKS_TAG_18, 10), string -> class_2378.field_11154.method_17966(class_2960.method_12829((String)string)), (class_1923)chunkPos);
        class_2826[] levelChunkSections = ChunkLoader.readSections((class_1936)level, chunkPos, tagLevel);
        class_2818 chunk = new class_2818((class_1937)level, chunkPos, upgradeData, blockTicks, fluidTicks, inhabitedTime, levelChunkSections, null, blendingData);
        chunk.method_12020(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        ChunkLoader.readPostPocessings(chunk, chunkData);
        return chunk;
    }

    private static void logErrors(class_1923 chunkPos, int i, String string) {
        LOGGER.error("Distant Horizons: Recoverable errors when loading section [" + chunkPos.field_9181 + ", " + i + ", " + chunkPos.field_9180 + "]: " + string, new Object[0]);
    }
}

