/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk;

import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.ArrayList;
import java.util.Arrays;

public class ChunkLightStorage {
    public int minY;
    public int maxY;
    public LightSection[] lightSections;

    public ChunkLightStorage(int minY, int maxY) {
        this.minY = minY;
        this.maxY = maxY;
    }

    public int get(int x, int y, int z) {
        LightSection lightSection;
        if (y < this.minY) {
            return 0;
        }
        if (y >= this.maxY) {
            return 15;
        }
        if (this.lightSections != null && (lightSection = this.lightSections[BitShiftUtil.divideByPowerOfTwo(y - this.minY, 4)]) != null) {
            return lightSection.get(x, y, z);
        }
        return 0;
    }

    public void set(int x, int y, int z, int lightLevel) {
        int index;
        LightSection lightSection;
        if (y < this.minY || y >= this.maxY) {
            return;
        }
        if (this.lightSections == null) {
            this.lightSections = new LightSection[BitShiftUtil.divideByPowerOfTwo(this.maxY - this.minY, 4)];
        }
        if ((lightSection = this.lightSections[index = y - this.minY >> 4]) == null) {
            this.lightSections[index] = lightSection = new LightSection(0);
        }
        lightSection.set(x, y, z, lightLevel);
    }

    public static class LightSection {
        public byte constantValue;
        public long[] data;
        public short[] counts;

        public LightSection(int initialValue) {
            this.constantValue = (byte)initialValue;
            this.counts = new short[16];
            this.counts[initialValue] = 4096;
        }

        public int get(int x, int y, int z) {
            if (this.constantValue >= 0) {
                return this.constantValue;
            }
            long bits = this.data[(z &= 0xF) << 4 | (x &= 0xF)];
            return (int)(bits >>> ((y &= 0xF) << 2)) & 0xF;
        }

        public void set(int x, int y, int z, int lightLevel) {
            int oldLightLevel = -1;
            if (this.constantValue >= 0) {
                oldLightLevel = this.constantValue;
                if (oldLightLevel == lightLevel) {
                    return;
                }
                this.data = DataRecycler.get();
                long payload = oldLightLevel;
                payload |= payload << 4;
                payload |= payload << 8;
                payload |= payload << 16;
                payload |= payload << 32;
                Arrays.fill(this.data, payload);
                this.constantValue = (byte)-1;
            }
            y &= 0xF;
            int index = (z &= 0xF) << 4 | (x &= 0xF);
            long bits = this.data[index];
            if (oldLightLevel < 0) {
                oldLightLevel = (int)(bits >>> (y << 2)) & 0xF;
            }
            bits &= 15L << (y << 2) ^ 0xFFFFFFFFFFFFFFFFL;
            this.data[index] = bits |= (long)lightLevel << (y << 2);
            int n = oldLightLevel;
            this.counts[n] = (short)(this.counts[n] - 1);
            int n2 = lightLevel;
            this.counts[n2] = (short)(this.counts[n2] + 1);
            if (this.counts[n2] == 4096) {
                this.constantValue = (byte)lightLevel;
                DataRecycler.reclaim(this.data);
                this.data = null;
            }
        }
    }

    static class DataRecycler {
        private static final ArrayList<long[]> recycled = new ArrayList(256);

        DataRecycler() {
        }

        static synchronized long[] get() {
            if (recycled.isEmpty()) {
                return new long[256];
            }
            return recycled.remove(recycled.size() - 1);
        }

        static synchronized void reclaim(long[] data) {
            if (recycled.size() < 256) {
                recycled.add(data);
            }
        }
    }
}

