/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkLightStorage;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.logging.log4j.Logger;

public class ChunkWrapper
implements IChunkWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final boolean RUN_RELATIVE_POS_INDEX_VALIDATION = ModInfo.IS_DEV_BUILD;
    private static final ThreadLocal<BlockPos.MutableBlockPos> MUTABLE_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new BlockPos.MutableBlockPos());
    private final ChunkAccess chunk;
    private final DhChunkPos chunkPos;
    private final LevelReader lightSource;
    private final ILevelWrapper wrappedLevel;
    private boolean isDhLightCorrect = false;
    private boolean isMcClientLightingCorrect = false;
    private ChunkLightStorage blockLightStorage;
    private ChunkLightStorage skyLightStorage;
    private ArrayList<DhBlockPos> blockLightPosList = null;
    private boolean useDhLighting;
    private static final ConcurrentLinkedQueue<ChunkWrapper> chunksNeedingClientLightUpdating = new ConcurrentLinkedQueue();

    public ChunkWrapper(ChunkAccess chunk, LevelReader lightSource, ILevelWrapper wrappedLevel) {
        boolean isDhGeneratedChunk;
        this.chunk = chunk;
        this.lightSource = lightSource;
        this.wrappedLevel = wrappedLevel;
        this.chunkPos = new DhChunkPos(chunk.m_7697_().f_45578_, chunk.m_7697_().f_45579_);
        this.useDhLighting = isDhGeneratedChunk = this.lightSource.getClass() == DhLitWorldGenRegion.class;
        chunksNeedingClientLightUpdating.add(this);
    }

    @Override
    public int getHeight() {
        return this.chunk.m_141928_();
    }

    @Override
    public int getMinBuildHeight() {
        return this.chunk.m_141937_();
    }

    @Override
    public int getMaxBuildHeight() {
        return this.chunk.m_151558_();
    }

    @Override
    public int getMinFilledHeight() {
        LevelChunkSection[] sections = this.chunk.m_7103_();
        for (int index = 0; index < sections.length; ++index) {
            if (sections[index] == null || sections[index].m_188008_()) continue;
            return this.chunk.m_151568_(index) * 16;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSolidHeightMapValue(int xRel, int zRel) {
        return this.chunk.m_6005_(Heightmap.Types.WORLD_SURFACE).m_64242_(xRel, zRel);
    }

    @Override
    public int getLightBlockingHeightMapValue(int xRel, int zRel) {
        return this.chunk.m_6005_(Heightmap.Types.MOTION_BLOCKING).m_64242_(xRel, zRel);
    }

    @Override
    public IBiomeWrapper getBiome(int relX, int relY, int relZ) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.chunk.m_203495_(QuartPos.m_175400_((int)relX), QuartPos.m_175400_((int)relY), QuartPos.m_175400_((int)relZ)), this.wrappedLevel);
    }

    @Override
    public DhChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public ChunkAccess getChunk() {
        return this.chunk;
    }

    @Override
    public int getMaxBlockX() {
        return this.chunk.m_7697_().m_45608_();
    }

    @Override
    public int getMaxBlockZ() {
        return this.chunk.m_7697_().m_45609_();
    }

    @Override
    public int getMinBlockX() {
        return this.chunk.m_7697_().m_45604_();
    }

    @Override
    public int getMinBlockZ() {
        return this.chunk.m_7697_().m_45605_();
    }

    @Override
    public long getLongChunkPos() {
        return this.chunk.m_7697_().m_45588_();
    }

    @Override
    public void setIsDhLightCorrect(boolean isDhLightCorrect) {
        this.isDhLightCorrect = isDhLightCorrect;
    }

    @Override
    public void setUseDhLighting(boolean useDhLighting) {
        this.useDhLighting = useDhLighting;
    }

    @Override
    public boolean isLightCorrect() {
        if (this.useDhLighting) {
            return this.isDhLightCorrect;
        }
        if (this.chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)this.chunk;
            if (levelChunk.m_62953_() instanceof ClientLevel) {
                return this.isMcClientLightingCorrect;
            }
            return this.chunk.m_6332_() && levelChunk.f_62775_;
        }
        return this.chunk.m_6332_();
    }

    @Override
    public int getDhBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getBlockLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhBlockLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getBlockLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getBlockLightStorage() {
        if (this.blockLightStorage == null) {
            this.blockLightStorage = new ChunkLightStorage(this.getMinBuildHeight(), this.getMaxBuildHeight());
        }
        return this.blockLightStorage;
    }

    @Override
    public int getDhSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getSkyLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhSkyLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getSkyLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getSkyLightStorage() {
        if (this.skyLightStorage == null) {
            this.skyLightStorage = new ChunkLightStorage(this.getMinBuildHeight(), this.getMaxBuildHeight());
        }
        return this.skyLightStorage;
    }

    @Override
    public int getBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getBlockLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.m_45517_(LightLayer.BLOCK, new BlockPos(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public int getSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        if (this.useDhLighting) {
            return this.getSkyLightStorage().get(relX, y, relZ);
        }
        return this.lightSource.m_45517_(LightLayer.SKY, new BlockPos(relX + this.getMinBlockX(), y, relZ + this.getMinBlockZ()));
    }

    @Override
    public ArrayList<DhBlockPos> getBlockLightPosList() {
        if (this.blockLightPosList == null) {
            this.blockLightPosList = new ArrayList();
            this.chunk.m_6267_().forEach(blockPos -> this.blockLightPosList.add(new DhBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_())));
        }
        return this.blockLightPosList;
    }

    @Override
    public boolean doNearbyChunksExist() {
        if (this.lightSource instanceof DhLitWorldGenRegion) {
            return true;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (dx == 0 && dz == 0 || this.lightSource.m_6522_(dx + this.chunk.m_7697_().f_45578_, dz + this.chunk.m_7697_().f_45579_, ChunkStatus.f_62317_, false) != null) continue;
                return false;
            }
        }
        return true;
    }

    public LevelReader getColorResolver() {
        return this.lightSource;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + this.chunk.m_7697_();
    }

    @Override
    public IBlockStateWrapper getBlockState(int relX, int relY, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, relY, relZ);
        BlockPos.MutableBlockPos blockPos = MUTABLE_BLOCK_POS_REF.get();
        blockPos.m_142451_(relX);
        blockPos.m_142448_(relY);
        blockPos.m_142443_(relZ);
        return BlockStateWrapper.fromBlockState(this.chunk.m_8055_((BlockPos)blockPos), this.wrappedLevel);
    }

    @Override
    public boolean isStillValid() {
        return this.wrappedLevel.tryGetChunk(this.chunkPos) == this;
    }

    public static void syncedUpdateClientLightStatus() {
        ChunkWrapper chunkWrapper = chunksNeedingClientLightUpdating.poll();
        while (chunkWrapper != null) {
            chunkWrapper.updateIsClientLightingCorrect();
            chunkWrapper = chunksNeedingClientLightUpdating.poll();
        }
    }

    private void updateIsClientLightingCorrect() {
        if (this.chunk instanceof LevelChunk && ((LevelChunk)this.chunk).m_62953_() instanceof ClientLevel) {
            LevelChunk levelChunk = (LevelChunk)this.chunk;
            ClientChunkCache clientChunkCache = ((ClientLevel)levelChunk.m_62953_()).m_7726_();
            this.isMcClientLightingCorrect = clientChunkCache.m_6196_(this.chunk.m_7697_().f_45578_, this.chunk.m_7697_().f_45579_) != null && levelChunk.m_196863_();
        }
    }

    private void throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(int x, int y, int z) throws IndexOutOfBoundsException {
        if (!RUN_RELATIVE_POS_INDEX_VALIDATION) {
            return;
        }
        int minHeight = this.getMinBuildHeight();
        int maxHeight = this.getMaxBuildHeight() + 1;
        if (x < 0 || x >= 16 || z < 0 || z >= 16 || y < minHeight || y > maxHeight) {
            String errorMessage = "Relative position [" + x + "," + y + "," + z + "] out of bounds. \nX/Z must be between 0 and 15 (inclusive) \nY must be between [" + minHeight + "] and [" + maxHeight + "] (inclusive).";
            throw new IndexOutOfBoundsException(errorMessage);
        }
    }

    public int relativeBlockPosToIndex(int xRel, int y, int zRel) {
        int yRel = y - this.getMinBuildHeight();
        return zRel * 16 * this.getHeight() + yRel * 16 + xRel;
    }

    public DhBlockPos indexToRelativeBlockPos(int index) {
        int zRel = index / (16 * this.getHeight());
        int y = (index -= zRel * 16 * this.getHeight()) / 16;
        int yRel = y + this.getMinBuildHeight();
        int xRel = index % 16;
        return new DhBlockPos(xRel, yRel, zRel);
    }
}

