/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Vector3f;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.ISodiumAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.math.Mat4f;
import com.seibel.distanthorizons.coreapi.util.math.Vec3d;
import com.seibel.distanthorizons.coreapi.util.math.Vec3f;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.WrapperFactory;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftClientWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final IWrapperFactory FACTORY = WrapperFactory.INSTANCE;
    private static final IOptifineAccessor OPTIFINE_ACCESSOR = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
    public HashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new HashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean usingBackupGetVanillaRenderedChunks = false;

    @Override
    public Vec3f getLookAtVector() {
        Camera camera = MinecraftRenderWrapper.MC.f_91063_.m_109153_();
        Vector3f cameraDir = camera.m_90596_();
        return new Vec3f(cameraDir.m_122239_(), cameraDir.m_122260_(), cameraDir.m_122269_());
    }

    @Override
    public DhBlockPos getCameraBlockPosition() {
        Camera camera = MinecraftRenderWrapper.MC.f_91063_.m_109153_();
        BlockPos blockPos = camera.m_90588_();
        return new DhBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        return MinecraftRenderWrapper.MC.f_91074_.m_21221_().get(MobEffects.f_19610_) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        Camera camera = MinecraftRenderWrapper.MC.f_91063_.m_109153_();
        Vec3 projectedView = camera.m_90583_();
        return new Vec3d(projectedView.f_82479_, projectedView.f_82480_, projectedView.f_82481_);
    }

    @Override
    public Mat4f getDefaultProjectionMatrix(float partialTicks) {
        return McObjectConverter.Convert(MinecraftRenderWrapper.MC.f_91063_.m_172716_(MinecraftRenderWrapper.MC.f_91063_.m_109141_(MinecraftRenderWrapper.MC.f_91063_.m_109153_(), partialTicks, true)));
    }

    @Override
    public double getGamma() {
        return (Double)MinecraftRenderWrapper.MC.f_91066_.m_231927_().m_231551_();
    }

    @Override
    public Color getFogColor(float partialTicks) {
        FogRenderer.m_109018_((Camera)MinecraftRenderWrapper.MC.f_91063_.m_109153_(), (float)partialTicks, (ClientLevel)MinecraftRenderWrapper.MC.f_91073_, (int)1, (float)MinecraftRenderWrapper.MC.f_91063_.m_109131_(partialTicks));
        float[] colorValues = RenderSystem.m_157198_();
        return new Color(Math.max(0.0f, Math.min(colorValues[0], 1.0f)), Math.max(0.0f, Math.min(colorValues[1], 1.0f)), Math.max(0.0f, Math.min(colorValues[2], 1.0f)), Math.max(0.0f, Math.min(colorValues[3], 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.f_91073_.m_6042_().f_223549_()) {
            Vec3 colorValues = MinecraftRenderWrapper.MC.f_91073_.m_171660_(MinecraftRenderWrapper.MC.f_91063_.m_109153_().m_90583_(), MC.m_91296_());
            return new Color((float)colorValues.f_82479_, (float)colorValues.f_82480_, (float)colorValues.f_82481_);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.f_91063_.m_109141_(MinecraftRenderWrapper.MC.f_91063_.m_109153_(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.f_91066_.m_193772_();
    }

    @Override
    public int getScreenWidth() {
        int width = MC.m_91268_().m_85441_();
        if (OPTIFINE_ACCESSOR != null) {
            width = (int)((double)width * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return width;
    }

    @Override
    public int getScreenHeight() {
        int height = MC.m_91268_().m_85442_();
        if (OPTIFINE_ACCESSOR != null) {
            height = (int)((double)height * OPTIFINE_ACCESSOR.getRenderResolutionMultiplier());
        }
        return height;
    }

    private RenderTarget getRenderTarget() {
        return MC.m_91385_();
    }

    @Override
    public int getTargetFrameBuffer() {
        int frameBufferOverrideId = DhApiRenderProxy.INSTANCE.targetFrameBufferOverride;
        if (frameBufferOverrideId != -1) {
            return frameBufferOverrideId;
        }
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return this.getRenderTarget().f_83920_;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        return this.getRenderTarget().m_83980_();
    }

    @Override
    public int getTargetFrameBufferViewportWidth() {
        return this.getRenderTarget().f_83917_;
    }

    @Override
    public int getTargetFrameBufferViewportHeight() {
        return this.getRenderTarget().f_83918_;
    }

    @Override
    public HashSet<DhChunkPos> getVanillaRenderedChunks() {
        ISodiumAccessor sodium = ModAccessorInjector.INSTANCE.get(ISodiumAccessor.class);
        if (sodium != null) {
            return sodium.getNormalRenderedChunks();
        }
        IOptifineAccessor optifine = ModAccessorInjector.INSTANCE.get(IOptifineAccessor.class);
        if (optifine != null) {
            HashSet<DhChunkPos> pos = optifine.getNormalRenderedChunks();
            if (pos == null) {
                pos = this.getMaximumRenderedChunks();
            }
            return pos;
        }
        if (!this.usingBackupGetVanillaRenderedChunks) {
            try {
                LevelRenderer levelRenderer = MinecraftRenderWrapper.MC.f_91060_;
                LinkedHashSet chunks = ((LevelRenderer.RenderChunkStorage)levelRenderer.f_194307_.get()).f_194376_;
                return chunks.stream().map(chunk -> {
                    AABB chunkBoundingBox = chunk.f_109839_.m_202440_();
                    return new DhChunkPos(Math.floorDiv((int)chunkBoundingBox.f_82288_, 16), Math.floorDiv((int)chunkBoundingBox.f_82290_, 16));
                }).collect(Collectors.toCollection(HashSet::new));
            }
            catch (LinkageError e) {
                try {
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7e\u00a7l\u00a7uWARNING: Distant Horizons: getVanillaRenderedChunks method failed. Using Backup Method.");
                    MinecraftClientWrapper.INSTANCE.sendChatMessage("\u00a7eOverdraw prevention will be worse than normal.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.error("getVanillaRenderedChunks Error: ", (Throwable)e);
                this.usingBackupGetVanillaRenderedChunks = true;
            }
        }
        return this.getMaximumRenderedChunks();
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.f_91063_.m_109153_().m_167685_() != FogType.NONE || isBlind;
    }

    public void updateLightmap(NativeImage lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        if (!this.lightmapByDimensionType.containsKey(dimensionType)) {
            this.lightmapByDimensionType.put(dimensionType, new LightMapWrapper());
        }
        this.lightmapByDimensionType.get(dimensionType).uploadLightmap(lightPixels);
    }
}

