/*
 * Decompiled with CFR 0.152.
 */
package chappie.displaycase.common.tile;

import chappie.displaycase.common.criterions.ExplosionOfDisplayCaseTrigger;
import chappie.displaycase.common.items.DisplayCaseItem;
import chappie.displaycase.common.items.DisplayCaseLidItem;
import chappie.displaycase.common.items.ModItems;
import chappie.displaycase.common.tile.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PlayerHeadItem;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DisplayCaseTileEntity
extends BlockEntity {
    private int rot = 0;
    private int timeToBoom = 0;
    private ItemStack stack = ItemStack.f_41583_;
    private ItemStack lidItem = ModItems.DISPLAY_CASE_LID.m_7968_();
    private boolean waxed = false;

    public DisplayCaseTileEntity(BlockPos pos, BlockState state) {
        super(ModTileEntities.DISPLAY_CASE, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, DisplayCaseTileEntity tile) {
        tile.rotTick();
        if (tile.timeToBoom > 0) {
            --tile.timeToBoom;
        }
        if (tile.timeToBoom == 1 && !level.m_5776_()) {
            level.m_46511_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 3.0f, Explosion.BlockInteraction.DESTROY);
            for (ServerPlayer entity : level.m_45976_(ServerPlayer.class, new AABB(pos, pos).m_82377_(10.0, 10.0, 10.0))) {
                ExplosionOfDisplayCaseTrigger.INSTANCE.trigger(entity);
            }
        }
    }

    public void rotTick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (!this.waxed && this.rot != Short.MIN_VALUE) {
            ++this.rot;
        }
    }

    public DyeColor getColor() {
        CompoundTag tag;
        if (this.getItem().m_41720_() instanceof PlayerHeadItem && (tag = this.getItem().m_41784_().m_128469_("SkullOwner")).m_128441_("Id") && tag.m_128342_("Id").toString().equals("8464971c-f5ac-4eb5-87aa-511a0eec65f6")) {
            return DyeColor.values()[this.rot % 75 / 5];
        }
        if (this.lidItem != null && !this.lidItem.m_41619_()) {
            tag = this.lidItem.m_41784_();
            return tag.m_128441_("Color") ? DyeColor.m_41057_((String)tag.m_128461_("Color"), (DyeColor)DyeColor.BLACK) : null;
        }
        return null;
    }

    public void setColor(DyeColor color) {
        if (this.lidItem != null) {
            if (color == null) {
                this.lidItem.m_41784_().m_128473_("Color");
            } else {
                this.lidItem.m_41784_().m_128359_("Color", color.m_41065_());
            }
        }
        this.markUpdated();
    }

    public boolean hasLid() {
        return this.lidItem != null && this.lidItem.m_41720_() instanceof DisplayCaseLidItem;
    }

    public ItemStack getLidItem() {
        return this.lidItem;
    }

    public void setLidItem(ItemStack lidItem) {
        this.lidItem = lidItem;
        this.markUpdated();
    }

    public int getRot() {
        return this.rot;
    }

    public boolean isWaxed() {
        return this.waxed;
    }

    public void setWaxed(boolean waxed) {
        this.waxed = waxed;
        this.markUpdated();
    }

    public ItemStack getItem() {
        return this.stack;
    }

    public boolean setItem(ItemStack stack) {
        if (this.timeToBoom > 0) {
            return false;
        }
        this.stack = stack;
        this.stack.m_41764_(1);
        if (stack.m_41720_() instanceof DisplayCaseItem) {
            ItemStack stack1 = stack;
            boolean shouldBoom = false;
            for (int i = 0; i < 11; ++i) {
                ItemStack displayCaseIn = ItemStack.m_41712_((CompoundTag)stack1.m_41784_().m_128469_("BlockEntityTag").m_128469_("Item"));
                if (!(displayCaseIn.m_41720_() instanceof DisplayCaseItem)) {
                    if (i != 9) break;
                    shouldBoom = true;
                    break;
                }
                stack1 = displayCaseIn;
            }
            if (shouldBoom) {
                if (this.f_58857_ != null) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_144172_, SoundSource.BLOCKS, 4.0f, 1.0f);
                }
                this.timeToBoom = 160;
            }
        }
        this.markUpdated();
        return true;
    }

    public void markUpdated() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Rotation", this.rot);
        nbt.m_128379_("Waxed", this.waxed);
        ListTag listTag = new ListTag();
        listTag.add(0, (Tag)(!this.stack.m_41619_() ? this.stack.m_41739_(new CompoundTag()) : new CompoundTag()));
        CompoundTag lidTag = new CompoundTag();
        if (!this.lidItem.m_41619_()) {
            listTag.add(1, (Tag)this.lidItem.m_41739_(lidTag));
        } else {
            lidTag.m_128359_("nothing", "");
            listTag.add(1, (Tag)lidTag);
        }
        nbt.m_128365_("Item", (Tag)listTag);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.rot = nbt.m_128451_("Rotation");
        ListTag list = nbt.m_128437_("Item", 10);
        this.stack = ItemStack.m_41712_((CompoundTag)list.m_128728_(0));
        this.lidItem = list.m_128728_(1).m_128456_() ? ModItems.DISPLAY_CASE_LID.m_7968_() : ItemStack.m_41712_((CompoundTag)list.m_128728_(1));
        this.waxed = nbt.m_128471_("Waxed");
    }
}

