/*
 * Decompiled with CFR 0.152.
 */
package com.sonicether.soundphysics.configbuilder;

import com.sonicether.soundphysics.configbuilder.Config;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class PropertyConfig
implements Config {
    protected Properties properties;
    protected Path path;

    public PropertyConfig(Path path) {
        this.path = path;
        this.properties = new Properties();
        this.loadInternal();
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }

    public void set(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void load() throws IOException {
        if (Files.exists(this.path, new LinkOption[0])) {
            try (InputStream inputStream = Files.newInputStream(this.path, new OpenOption[0]);){
                this.properties.load(inputStream);
            }
        }
    }

    private void loadInternal() {
        try {
            this.load();
        }
        catch (IOException e) {
            System.err.println("Failed to read " + this.path.getFileName().toString());
            System.err.println("Using default configuration values");
            e.printStackTrace();
        }
    }

    public void reload() {
        this.properties = new Properties();
        this.loadInternal();
    }

    public void saveSync() {
        try {
            Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to create parent directory of " + this.path.getFileName().toString());
            e.printStackTrace();
        }
        try (OutputStream stream = Files.newOutputStream(this.path, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.TRUNCATE_EXISTING);){
            this.properties.store(stream, "");
        }
        catch (IOException e) {
            System.err.println("Failed to save " + this.path.getFileName().toString());
            e.printStackTrace();
        }
    }

    public void save() {
        new Thread(() -> {
            PropertyConfig propertyConfig = this;
            synchronized (propertyConfig) {
                this.saveSync();
            }
        }).start();
    }

    @Override
    public Map<String, Object> getEntries() {
        return this.properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), Map.Entry::getValue));
    }
}

