/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread.forge.events;

import com.natamus.collective_common_forge.functions.WorldFunctions;
import com.natamus.netherportalspread_common_forge.events.SpreadEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ForgeSpreadEvent {
    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent e) {
        Level level = e.level;
        if (level.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        SpreadEvent.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        SpreadEvent.onWorldLoad((ServerLevel)level);
    }

    @SubscribeEvent
    public void onPortalSpawn(BlockEvent.PortalSpawnEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        SpreadEvent.onPortalSpawn(level, e.getPos(), e.getPortalSize());
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        Level level = player.m_20193_();
        if (level.f_46443_) {
            return;
        }
        SpreadEvent.onDimensionChange((ServerLevel)level, (ServerPlayer)player);
    }
}

