/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.IEntityCapReader;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraftforge.registries.ForgeRegistries;

public class SummonMobsGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:summonmobs");
    private final Mob mob;
    private LivingEntity target = null;
    private final SummonParams params;
    private final List<LivingEntity> summonedMobs = new ArrayList<LivingEntity>();
    private int ticksToNextUpdate = 0;

    public SummonMobsGoal(Mob mob, IAIParams params) {
        this.mob = mob;
        this.params = (SummonParams)params;
        PlayerTeam team = mob.f_19853_.m_6188_().m_83489_("bb:bossteam");
        if (team == null) {
            team = mob.f_19853_.m_6188_().m_83492_("bb:bossteam");
        }
        mob.f_19853_.m_6188_().m_6546_(mob.m_6302_(), team);
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_() && this.params.entityIDs.size() > 0) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void m_8056_() {
        this.ticksToNextUpdate = Math.max(50, this.ticksToNextUpdate);
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        this.summonedMobs.removeIf(summoned -> {
            if (!summoned.m_6084_()) {
                if (this.params.ownerdamage > 0.0f && this.mob.m_21223_() > this.mob.m_21233_() * 0.1f) {
                    this.mob.m_21153_(Math.max(this.mob.m_21233_() * 0.1f, this.mob.m_21223_() - this.mob.m_21233_() * this.params.ownerdamage));
                }
                return true;
            }
            return false;
        });
        if (--this.ticksToNextUpdate > 0) {
            if (this.ticksToNextUpdate < 30 && this.mob instanceof SpellcasterIllager) {
                ((SpellcasterIllager)this.mob).m_33727_(SpellcasterIllager.IllagerSpell.WOLOLO);
            }
            return;
        }
        if (this.mob instanceof SpellcasterIllager) {
            ((SpellcasterIllager)this.mob).m_33727_(SpellcasterIllager.IllagerSpell.NONE);
        }
        this.ticksToNextUpdate = this.params.interval;
        for (int i = 0; i < this.params.count; ++i) {
            this.trySummonMob();
        }
    }

    private void trySummonMob() {
        LivingEntity summoned;
        if (this.summonedMobs.size() >= this.params.maxcount) {
            return;
        }
        EntityType<? extends LivingEntity> entityType = this.params.entityIDs.get(BrutalBosses.rand.nextInt(this.params.entityIDs.size()));
        try {
            summoned = (LivingEntity)entityType.m_20615_(this.mob.f_19853_);
            if (this.params.entityNBTData.containsKey(ForgeRegistries.ENTITY_TYPES.getKey(entityType))) {
                CompoundTag nbt = this.params.entityNBTData.get(ForgeRegistries.ENTITY_TYPES.getKey(entityType));
                if (nbt.m_128441_("Pos")) {
                    summoned.m_20258_(nbt);
                } else {
                    if (nbt.m_128425_("ForgeCaps", 10) && summoned instanceof IEntityCapReader) {
                        ((IEntityCapReader)summoned).readCapsFrom(nbt.m_128469_("ForgeCaps"));
                    }
                    summoned.m_7378_(nbt);
                }
                summoned.m_20084_(UUID.randomUUID());
            } else if (summoned instanceof RangedAttackMob) {
                summoned.m_21008_(InteractionHand.MAIN_HAND, Items.f_42411_.m_7968_());
            }
        }
        catch (Exception e) {
            BossCapability bossCapability = (BossCapability)this.mob.getCapability(BossCapability.BOSS_CAP).orElse(null);
            if (bossCapability != null) {
                BrutalBosses.LOGGER.warn("Failed summoning add for boss:" + bossCapability.getBossType().getID(), (Throwable)e);
                return;
            }
            BrutalBosses.LOGGER.warn("Failed summoning addfor boss:", (Throwable)e);
            return;
        }
        BlockPos spawnPos = BossSpawnHandler.findSpawnPosForBoss((BlockGetter)((ServerLevel)this.mob.f_19853_), (Entity)summoned, this.mob.m_20183_());
        if (spawnPos == null) {
            return;
        }
        ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)spawnPos.m_123341_(), (double)(spawnPos.m_123342_() + 1), (double)spawnPos.m_123343_(), 20, 0.0, 0.0, 0.0, 0.0);
        if (summoned instanceof Mob) {
            PlayerTeam team = this.mob.f_19853_.m_6188_().m_83489_("bb:bossteam");
            if (team == null) {
                team = this.mob.f_19853_.m_6188_().m_83492_("bb:bossteam");
            }
            this.mob.f_19853_.m_6188_().m_6546_(summoned.m_6302_(), team);
            ((Mob)summoned).m_6710_(this.target);
        }
        summoned.m_6034_((double)spawnPos.m_123341_(), (double)spawnPos.m_123342_(), (double)spawnPos.m_123343_());
        this.mob.f_19853_.m_7967_((Entity)summoned);
        this.summonedMobs.add(summoned);
    }

    public static class SummonParams
    extends IAIParams.DefaultParams {
        private int interval = 500;
        private List<EntityType<? extends LivingEntity>> entityIDs = new ArrayList<EntityType<? extends LivingEntity>>();
        private int count = 1;
        private int maxcount = 2;
        private float ownerdamage = 0.0f;
        private Map<ResourceLocation, CompoundTag> entityNBTData = new HashMap<ResourceLocation, CompoundTag>();
        private static final String SUMM_INTERVAL = "interval";
        private static final String SUMM_MAX = "maxcount";
        private static final String SUMM_COUNT = "count";
        private static final String ENTITY_ID = "entityid";
        private static final String ENTITIES = "entities";
        private static final String OWNERDAMAGE = "ownerdamagepct";
        private static final String SUMM_ENTITY_NBT = "entitynbt";

        public SummonParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ENTITIES)) {
                HashMap<ResourceLocation, CompoundTag> entityData = new HashMap<ResourceLocation, CompoundTag>();
                ArrayList<EntityType<? extends LivingEntity>> types = new ArrayList<EntityType<? extends LivingEntity>>();
                for (JsonElement entityEntry : jsonElement.get(ENTITIES).getAsJsonArray()) {
                    ResourceLocation entityID = new ResourceLocation(((JsonObject)entityEntry).get(ENTITY_ID).getAsString());
                    types.add((EntityType<? extends LivingEntity>)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityID)));
                    if (!((JsonObject)entityEntry).has(SUMM_ENTITY_NBT)) continue;
                    try {
                        entityData.put(entityID, TagParser.m_129359_((String)((JsonObject)entityEntry).get(SUMM_ENTITY_NBT).getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.entityIDs = types;
                this.entityNBTData = entityData;
            }
            if (jsonElement.has(SUMM_INTERVAL)) {
                this.interval = jsonElement.get(SUMM_INTERVAL).getAsInt();
            }
            if (jsonElement.has(SUMM_COUNT)) {
                this.count = jsonElement.get(SUMM_COUNT).getAsInt();
            }
            if (jsonElement.has(SUMM_MAX)) {
                this.maxcount = jsonElement.get(SUMM_MAX).getAsInt();
            }
            if (jsonElement.has(OWNERDAMAGE)) {
                this.ownerdamage = jsonElement.get(OWNERDAMAGE).getAsFloat() / 100.0f;
            }
            return this;
        }
    }
}

