/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.illuminations.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.mojang.serialization.Codec;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.Month;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import ladysnake.illuminations.client.ClientHelper;
import ladysnake.illuminations.client.config.Config;
import ladysnake.illuminations.client.config.DefaultConfig;
import ladysnake.illuminations.client.data.AuraData;
import ladysnake.illuminations.client.data.IlluminationData;
import ladysnake.illuminations.client.data.OverheadData;
import ladysnake.illuminations.client.data.PlayerCosmeticData;
import ladysnake.illuminations.client.enums.HalloweenFeatures;
import ladysnake.illuminations.client.particle.WispTrailParticleEffect;
import ladysnake.illuminations.client.render.entity.model.hat.CrownModel;
import ladysnake.illuminations.client.render.entity.model.hat.HaloModel;
import ladysnake.illuminations.client.render.entity.model.hat.HornsModel;
import ladysnake.illuminations.client.render.entity.model.hat.TiaraModel;
import ladysnake.illuminations.client.render.entity.model.hat.VoidheartTiaraModel;
import ladysnake.illuminations.client.render.entity.model.hat.WreathModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod(value="illuminations")
public class Illuminations {
    public static final String MODID = "illuminations";
    public static final Logger logger = LogManager.getLogger((String)"Illuminations");
    public static final int EYES_VANISHING_DISTANCE = 5;
    public static final Gson COSMETICS_GSON = new GsonBuilder().registerTypeAdapter(PlayerCosmeticData.class, (Object)new PlayerCosmeticDataParser()).create();
    public static final BiPredicate<Level, BlockPos> FIREFLY_LOCATION_PREDICATE = (world, blockPos) -> {
        Block block = world.m_8055_(blockPos).m_60734_();
        return world.m_6042_().m_63967_() ? block == Blocks.f_50016_ || block == Blocks.f_50626_ : !(block != Blocks.f_50016_ || !Config.doesFireflySpawnAlways() && !Illuminations.isNightTime(world) || !Config.doesFireflySpawnUnderground() && !world.m_8055_(blockPos).m_60713_(Blocks.f_50016_));
    };
    public static final BiPredicate<Level, BlockPos> GLOWWORM_LOCATION_PREDICATE = (world, blockPos) -> world.m_8055_(blockPos).m_60734_() == Blocks.f_50627_;
    public static final BiPredicate<Level, BlockPos> PLANKTON_LOCATION_PREDICATE = (world, blockPos) -> world.m_8055_(blockPos).m_60819_().m_205070_(FluidTags.f_13131_) && world.m_46803_(blockPos) < 2;
    public static final BiPredicate<Level, BlockPos> EYES_LOCATION_PREDICATE = (world, blockPos) -> (Config.getHalloweenFeatures() == HalloweenFeatures.ENABLE && LocalDate.now().getMonth() == Month.OCTOBER || Config.getHalloweenFeatures() == HalloweenFeatures.ALWAYS) && (world.m_8055_(blockPos).m_60734_() == Blocks.f_50016_ || world.m_8055_(blockPos).m_60734_() == Blocks.f_50627_) && world.m_46803_(blockPos) <= 0 && world.m_45924_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 5.0, false) == null;
    public static final BiPredicate<Level, BlockPos> WISP_LOCATION_PREDICATE = (world, blockPos) -> world.m_8055_(blockPos).m_204336_(BlockTags.f_13085_);
    static final Type COSMETIC_SELECT_TYPE = new TypeToken<Map<UUID, PlayerCosmeticData>>(){}.getType();
    private static final String COSMETICS_URL = "https://doctor4t.uuid.gg/illuminations-data";
    public static ImmutableMap<String, AuraData> AURAS_DATA;
    public static ImmutableMap<String, SimpleParticleType> PETS_DATA;
    public static ImmutableMap<String, OverheadData> OVERHEADS_DATA;
    public static RegistryObject<SimpleParticleType> FIREFLY;
    public static RegistryObject<SimpleParticleType> GLOWWORM;
    public static RegistryObject<SimpleParticleType> PLANKTON;
    public static RegistryObject<SimpleParticleType> EYES;
    public static RegistryObject<SimpleParticleType> CHORUS_PETAL;
    public static RegistryObject<SimpleParticleType> WILL_O_WISP;
    public static RegistryObject<ParticleType<WispTrailParticleEffect>> WISP_TRAIL;
    public static RegistryObject<SimpleParticleType> PUMPKIN_SPIRIT;
    public static RegistryObject<SimpleParticleType> POLTERGEIST;
    public static RegistryObject<SimpleParticleType> PRISMARINE_CRYSTAL;
    public static RegistryObject<SimpleParticleType> TWILIGHT_AURA;
    public static RegistryObject<SimpleParticleType> GHOSTLY_AURA;
    public static RegistryObject<SimpleParticleType> CHORUS_AURA;
    public static RegistryObject<SimpleParticleType> AUTUMN_LEAVES_AURA;
    public static RegistryObject<SimpleParticleType> SCULK_TENDRIL_AURA;
    public static RegistryObject<SimpleParticleType> SHADOWBRINGER_AURA;
    public static RegistryObject<SimpleParticleType> GOLDENROD_AURA;
    public static RegistryObject<SimpleParticleType> CONFETTI_AURA;
    public static RegistryObject<SimpleParticleType> PRISMATIC_CONFETTI_AURA;
    public static RegistryObject<SimpleParticleType> PRISMARINE_AURA;
    public static RegistryObject<SimpleParticleType> PRIDE_PET;
    public static RegistryObject<SimpleParticleType> GAY_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> TRANS_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> JACKO_PET;
    public static RegistryObject<SimpleParticleType> LESBIAN_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> BI_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> ACE_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> NB_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> INTERSEX_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> ARO_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> PAN_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> AGENDER_PRIDE_PET;
    public static RegistryObject<SimpleParticleType> WILL_O_WISP_PET;
    public static RegistryObject<SimpleParticleType> GOLDEN_WILL_PET;
    public static RegistryObject<SimpleParticleType> FOUNDING_SKULL_PET;
    public static RegistryObject<SimpleParticleType> DISSOLUTION_WISP_PET;
    public static RegistryObject<SimpleParticleType> PUMPKIN_SPIRIT_PET;
    public static RegistryObject<SimpleParticleType> POLTERGEIST_PET;
    public static RegistryObject<SimpleParticleType> LANTERN_PET;
    public static RegistryObject<SimpleParticleType> SOUL_LANTERN_PET;
    public static RegistryObject<SimpleParticleType> CRYING_LANTERN_PET;
    public static RegistryObject<SimpleParticleType> SOOTHING_LANTERN_PET;
    public static RegistryObject<SimpleParticleType> GENDERFLUID_PRIDE_PET;
    public static ImmutableMap<ResourceLocation, ImmutableSet<IlluminationData>> ILLUMINATIONS_BIOME_CATEGORIES;
    public static ImmutableMap<ResourceLocation, ImmutableSet<IlluminationData>> ILLUMINATIONS_BIOMES;
    private static Map<UUID, PlayerCosmeticData> PLAYER_COSMETICS;

    @Nullable
    public static PlayerCosmeticData getCosmeticData(Player player) {
        return PLAYER_COSMETICS.get(player.m_20148_());
    }

    @Nullable
    public static PlayerCosmeticData getCosmeticData(UUID uuid) {
        return PLAYER_COSMETICS.get(uuid);
    }

    public static void loadPlayerCosmetics() {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            block10: {
                Map map;
                InputStreamReader reader = new InputStreamReader(new URL(COSMETICS_URL).openStream());
                try {
                    if (Config.isDebugMode()) {
                        logger.log(org.apache.logging.log4j.Level.INFO, "Retrieving Illuminations cosmetics from the dashboard...");
                    }
                    map = (Map)COSMETICS_GSON.fromJson((Reader)reader, COSMETIC_SELECT_TYPE);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (MalformedURLException e) {
                        if (Config.isDebugMode()) {
                            logger.log(org.apache.logging.log4j.Level.ERROR, "Could not get player cosmetics because of malformed URL: " + e.getMessage());
                        }
                        break block10;
                    }
                    catch (IOException e) {
                        if (!Config.isDebugMode()) break block10;
                        logger.log(org.apache.logging.log4j.Level.ERROR, "Could not get player cosmetics because of I/O Error: " + e.getMessage());
                    }
                }
                ((Reader)reader).close();
                return map;
            }
            return null;
        }).exceptionally(throwable -> {
            if (Config.isDebugMode()) {
                logger.log(org.apache.logging.log4j.Level.ERROR, "Could not get player cosmetics because wtf is happening", throwable);
            }
            return null;
        })).thenAcceptAsync(playerData -> {
            if (playerData != null) {
                PLAYER_COSMETICS = playerData;
                if (Config.isDebugMode()) {
                    logger.log(org.apache.logging.log4j.Level.INFO, "Player cosmetics successfully registered");
                }
            } else {
                PLAYER_COSMETICS = Collections.emptyMap();
                if (Config.isDebugMode()) {
                    logger.log(org.apache.logging.log4j.Level.WARN, "Player cosmetics could not registered, cosmetics will be ignored");
                }
            }
        });
    }

    public static boolean isNightTime(Level world) {
        return (double)world.m_46942_((float)world.m_46468_()) >= 0.25965086 && (double)world.m_46942_((float)world.m_46468_()) <= 0.7403491;
    }

    public Illuminations() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::onInitializeClient);
        DeferredRegister PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)MODID);
        FIREFLY = PARTICLE_TYPES.register("firefly", () -> new SimpleParticleType(true));
        GLOWWORM = PARTICLE_TYPES.register("glowworm", () -> new SimpleParticleType(true));
        PLANKTON = PARTICLE_TYPES.register("plankton", () -> new SimpleParticleType(true));
        EYES = PARTICLE_TYPES.register("eyes", () -> new SimpleParticleType(true));
        CHORUS_PETAL = PARTICLE_TYPES.register("chorus_petal", () -> new SimpleParticleType(true));
        WILL_O_WISP = PARTICLE_TYPES.register("will_o_wisp", () -> new SimpleParticleType(true));
        WISP_TRAIL = PARTICLE_TYPES.register("wisp_trail", () -> new ParticleType<WispTrailParticleEffect>(true, WispTrailParticleEffect.PARAMETERS_FACTORY){

            public Codec<WispTrailParticleEffect> m_7652_() {
                return WispTrailParticleEffect.CODEC;
            }
        });
        PUMPKIN_SPIRIT = PARTICLE_TYPES.register("pumpkin_spirit", () -> new SimpleParticleType(true));
        POLTERGEIST = PARTICLE_TYPES.register("poltergeist", () -> new SimpleParticleType(true));
        PRISMARINE_CRYSTAL = PARTICLE_TYPES.register("prismarine_crystal", () -> new SimpleParticleType(true));
        TWILIGHT_AURA = PARTICLE_TYPES.register("twilight_aura", () -> new SimpleParticleType(true));
        GHOSTLY_AURA = PARTICLE_TYPES.register("ghostly_aura", () -> new SimpleParticleType(true));
        CHORUS_AURA = PARTICLE_TYPES.register("chorus_aura", () -> new SimpleParticleType(true));
        AUTUMN_LEAVES_AURA = PARTICLE_TYPES.register("autumn_leaves", () -> new SimpleParticleType(true));
        SCULK_TENDRIL_AURA = PARTICLE_TYPES.register("sculk_tendril", () -> new SimpleParticleType(true));
        SHADOWBRINGER_AURA = PARTICLE_TYPES.register("shadowbringer_aura", () -> new SimpleParticleType(true));
        GOLDENROD_AURA = PARTICLE_TYPES.register("goldenrod_aura", () -> new SimpleParticleType(true));
        CONFETTI_AURA = PARTICLE_TYPES.register("confetti", () -> new SimpleParticleType(true));
        PRISMATIC_CONFETTI_AURA = PARTICLE_TYPES.register("prismatic_confetti", () -> new SimpleParticleType(true));
        PRISMARINE_AURA = PARTICLE_TYPES.register("prismarine_aura", () -> new SimpleParticleType(true));
        PRIDE_PET = PARTICLE_TYPES.register("pride_pet", () -> new SimpleParticleType(true));
        GAY_PRIDE_PET = PARTICLE_TYPES.register("gay_pride_pet", () -> new SimpleParticleType(true));
        TRANS_PRIDE_PET = PARTICLE_TYPES.register("trans_pride_pet", () -> new SimpleParticleType(true));
        LESBIAN_PRIDE_PET = PARTICLE_TYPES.register("lesbian_pride_pet", () -> new SimpleParticleType(true));
        BI_PRIDE_PET = PARTICLE_TYPES.register("bi_pride_pet", () -> new SimpleParticleType(true));
        ACE_PRIDE_PET = PARTICLE_TYPES.register("ace_pride_pet", () -> new SimpleParticleType(true));
        NB_PRIDE_PET = PARTICLE_TYPES.register("nb_pride_pet", () -> new SimpleParticleType(true));
        INTERSEX_PRIDE_PET = PARTICLE_TYPES.register("intersex_pride_pet", () -> new SimpleParticleType(true));
        ARO_PRIDE_PET = PARTICLE_TYPES.register("aro_pride_pet", () -> new SimpleParticleType(true));
        PAN_PRIDE_PET = PARTICLE_TYPES.register("pan_pride_pet", () -> new SimpleParticleType(true));
        AGENDER_PRIDE_PET = PARTICLE_TYPES.register("agender_pride_pet", () -> new SimpleParticleType(true));
        GENDERFLUID_PRIDE_PET = PARTICLE_TYPES.register("genderfluid_pride_pet", () -> new SimpleParticleType(true));
        WILL_O_WISP_PET = PARTICLE_TYPES.register("will_o_wisp_pet", () -> new SimpleParticleType(true));
        GOLDEN_WILL_PET = PARTICLE_TYPES.register("golden_will_pet", () -> new SimpleParticleType(true));
        FOUNDING_SKULL_PET = PARTICLE_TYPES.register("founding_skull_pet", () -> new SimpleParticleType(true));
        DISSOLUTION_WISP_PET = PARTICLE_TYPES.register("dissolution_wisp_pet", () -> new SimpleParticleType(true));
        JACKO_PET = PARTICLE_TYPES.register("jacko_pet", () -> new SimpleParticleType(true));
        PUMPKIN_SPIRIT_PET = PARTICLE_TYPES.register("pumpkin_spirit_pet", () -> new SimpleParticleType(true));
        POLTERGEIST_PET = PARTICLE_TYPES.register("poltergeist_pet", () -> new SimpleParticleType(true));
        LANTERN_PET = PARTICLE_TYPES.register("lantern_pet", () -> new SimpleParticleType(true));
        SOUL_LANTERN_PET = PARTICLE_TYPES.register("soul_lantern_pet", () -> new SimpleParticleType(true));
        CRYING_LANTERN_PET = PARTICLE_TYPES.register("crying_lantern_pet", () -> new SimpleParticleType(true));
        SOOTHING_LANTERN_PET = PARTICLE_TYPES.register("soothing_lantern_pet", () -> new SimpleParticleType(true));
        PARTICLE_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onInitializeClient(FMLClientSetupEvent event) {
        Config.load();
        Illuminations.loadPlayerCosmetics();
        ClientHelper.load();
        ImmutableMap.Builder biomeBuilder = ImmutableMap.builder();
        Config.getBiomeSettings().forEach((biome, settings) -> {
            ImmutableSet.Builder illuminationDataBuilder = ImmutableSet.builder();
            illuminationDataBuilder.add((Object)new IlluminationData((SimpleParticleType)FIREFLY.get(), FIREFLY_LOCATION_PREDICATE, () -> Float.valueOf(Config.getBiomeSettings((ResourceLocation)biome).fireflySpawnRate().spawnRate)));
            if (settings.glowwormSpawnRate() != null) {
                illuminationDataBuilder.add((Object)new IlluminationData((SimpleParticleType)GLOWWORM.get(), GLOWWORM_LOCATION_PREDICATE, () -> Float.valueOf(Config.getBiomeSettings((ResourceLocation)biome).glowwormSpawnRate().spawnRate)));
            }
            if (settings.planktonSpawnRate() != null) {
                illuminationDataBuilder.add((Object)new IlluminationData((SimpleParticleType)PLANKTON.get(), PLANKTON_LOCATION_PREDICATE, () -> Float.valueOf(Config.getBiomeSettings((ResourceLocation)biome).planktonSpawnRate().spawnRate)));
            }
            biomeBuilder.put(biome, (Object)illuminationDataBuilder.build());
        });
        ILLUMINATIONS_BIOME_CATEGORIES = biomeBuilder.build();
        ILLUMINATIONS_BIOMES = ImmutableMap.builder().put((Object)new ResourceLocation("minecraft:soul_sand_valley"), (Object)ImmutableSet.of((Object)new IlluminationData((SimpleParticleType)WILL_O_WISP.get(), WISP_LOCATION_PREDICATE, () -> Float.valueOf(Config.getWillOWispsSpawnRate().spawnRate)))).build();
        AURAS_DATA = ImmutableMap.builder().put((Object)"twilight", (Object)new AuraData((SimpleParticleType)TWILIGHT_AURA.get(), () -> DefaultConfig.getAuraSettings("twilight"))).put((Object)"ghostly", (Object)new AuraData((SimpleParticleType)GHOSTLY_AURA.get(), () -> DefaultConfig.getAuraSettings("ghostly"))).put((Object)"chorus", (Object)new AuraData((SimpleParticleType)CHORUS_AURA.get(), () -> DefaultConfig.getAuraSettings("chorus"))).put((Object)"autumn_leaves", (Object)new AuraData((SimpleParticleType)AUTUMN_LEAVES_AURA.get(), () -> DefaultConfig.getAuraSettings("autumn_leaves"))).put((Object)"sculk_tendrils", (Object)new AuraData((SimpleParticleType)SCULK_TENDRIL_AURA.get(), () -> DefaultConfig.getAuraSettings("sculk_tendrils"))).put((Object)"shadowbringer_soul", (Object)new AuraData((SimpleParticleType)SHADOWBRINGER_AURA.get(), () -> DefaultConfig.getAuraSettings("shadowbringer_soul"))).put((Object)"goldenrod", (Object)new AuraData((SimpleParticleType)GOLDENROD_AURA.get(), () -> DefaultConfig.getAuraSettings("goldenrod"))).put((Object)"confetti", (Object)new AuraData((SimpleParticleType)CONFETTI_AURA.get(), () -> DefaultConfig.getAuraSettings("confetti"))).put((Object)"prismatic_confetti", (Object)new AuraData((SimpleParticleType)PRISMATIC_CONFETTI_AURA.get(), () -> DefaultConfig.getAuraSettings("prismatic_confetti"))).put((Object)"prismarine", (Object)new AuraData((SimpleParticleType)PRISMARINE_AURA.get(), () -> DefaultConfig.getAuraSettings("prismarine"))).build();
        OVERHEADS_DATA = ImmutableMap.builder().put((Object)"solar_crown", (Object)new OverheadData(CrownModel::new, "solar_crown")).put((Object)"frost_crown", (Object)new OverheadData(CrownModel::new, "frost_crown")).put((Object)"pyro_crown", (Object)new OverheadData(CrownModel::new, "pyro_crown")).put((Object)"chorus_crown", (Object)new OverheadData(CrownModel::new, "chorus_crown")).put((Object)"bloodfiend_crown", (Object)new OverheadData(CrownModel::new, "bloodfiend_crown")).put((Object)"dreadlich_crown", (Object)new OverheadData(CrownModel::new, "dreadlich_crown")).put((Object)"mooncult_crown", (Object)new OverheadData(CrownModel::new, "mooncult_crown")).put((Object)"deepsculk_horns", (Object)new OverheadData(HornsModel::new, "deepsculk_horns")).put((Object)"springfae_horns", (Object)new OverheadData(HornsModel::new, "springfae_horns")).put((Object)"voidheart_tiara", (Object)new OverheadData(VoidheartTiaraModel::new, "voidheart_tiara")).put((Object)"worldweaver_halo", (Object)new OverheadData(HaloModel::new, "worldweaver_halo")).put((Object)"summerbreeze_wreath", (Object)new OverheadData(WreathModel::new, "summerbreeze_wreath")).put((Object)"glowsquid_cult_crown", (Object)new OverheadData(TiaraModel::new, "glowsquid_cult_crown")).put((Object)"timeaspect_cult_crown", (Object)new OverheadData(TiaraModel::new, "timeaspect_cult_crown")).put((Object)"prismarine_crown", (Object)new OverheadData(CrownModel::new, "prismarine_crown")).build();
        PETS_DATA = ImmutableMap.builder().put((Object)"pride", (Object)((SimpleParticleType)PRIDE_PET.get())).put((Object)"gay_pride", (Object)((SimpleParticleType)GAY_PRIDE_PET.get())).put((Object)"trans_pride", (Object)((SimpleParticleType)TRANS_PRIDE_PET.get())).put((Object)"lesbian_pride", (Object)((SimpleParticleType)LESBIAN_PRIDE_PET.get())).put((Object)"bi_pride", (Object)((SimpleParticleType)BI_PRIDE_PET.get())).put((Object)"ace_pride", (Object)((SimpleParticleType)ACE_PRIDE_PET.get())).put((Object)"nb_pride", (Object)((SimpleParticleType)NB_PRIDE_PET.get())).put((Object)"intersex_pride", (Object)((SimpleParticleType)INTERSEX_PRIDE_PET.get())).put((Object)"aro_pride", (Object)((SimpleParticleType)ARO_PRIDE_PET.get())).put((Object)"pan_pride", (Object)((SimpleParticleType)PAN_PRIDE_PET.get())).put((Object)"agender_pride", (Object)((SimpleParticleType)AGENDER_PRIDE_PET.get())).put((Object)"genderfluid_pride", (Object)((SimpleParticleType)GENDERFLUID_PRIDE_PET.get())).put((Object)"jacko", (Object)((SimpleParticleType)JACKO_PET.get())).put((Object)"will_o_wisp", (Object)((SimpleParticleType)WILL_O_WISP_PET.get())).put((Object)"golden_will", (Object)((SimpleParticleType)GOLDEN_WILL_PET.get())).put((Object)"founding_skull", (Object)((SimpleParticleType)FOUNDING_SKULL_PET.get())).put((Object)"dissolution_wisp", (Object)((SimpleParticleType)DISSOLUTION_WISP_PET.get())).put((Object)"pumpkin_spirit", (Object)((SimpleParticleType)PUMPKIN_SPIRIT_PET.get())).put((Object)"poltergeist", (Object)((SimpleParticleType)POLTERGEIST_PET.get())).put((Object)"lantern", (Object)((SimpleParticleType)LANTERN_PET.get())).put((Object)"soul_lantern", (Object)((SimpleParticleType)SOUL_LANTERN_PET.get())).put((Object)"crying_lantern", (Object)((SimpleParticleType)CRYING_LANTERN_PET.get())).put((Object)"soothing_lantern", (Object)((SimpleParticleType)SOOTHING_LANTERN_PET.get())).build();
    }

    static {
        PLAYER_COSMETICS = Collections.emptyMap();
    }

    private static class PlayerCosmeticDataParser
    implements JsonDeserializer<PlayerCosmeticData> {
        private PlayerCosmeticDataParser() {
        }

        public PlayerCosmeticData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            return new PlayerCosmeticData(jsonObject.get("aura"), jsonObject.get("color"), jsonObject.get("overhead"), jsonObject.get("pet"));
        }
    }
}

