/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.ApiStatus;

public final class ItemData
implements IData {
    public static final ResourceLocation ID = BuiltinDataUtil.rl("item");
    public static final ResourceLocation CONFIG_SYNC_NBT = BuiltinDataUtil.rl("item.nbt");
    public static final ResourceLocation CONFIG_MAX_HEIGHT = BuiltinDataUtil.rl("item.max_height");
    public static final ResourceLocation CONFIG_SORT_BY_COUNT = BuiltinDataUtil.rl("item.sort_by_count");
    private final IPluginConfig config;
    private final ArrayList<ItemStack> items = new ArrayList();
    private boolean syncNbt;

    public static ItemData of(IPluginConfig config) {
        return new ItemData(config);
    }

    public ItemData vanilla(Container container) {
        int size = container.m_6643_();
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(container.m_8020_(i));
        }
        return this;
    }

    public ItemData getter(IntFunction<ItemStack> getter, int size) {
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(getter.apply(i));
        }
        return this;
    }

    public ItemData add(ItemStack stack) {
        this.items.add(stack);
        return this;
    }

    public ItemData add(ItemStack ... stacks) {
        this.ensureSpace(stacks.length);
        Collections.addAll(this.items, stacks);
        return this;
    }

    public ItemData add(Collection<ItemStack> stacks) {
        this.items.addAll(stacks);
        return this;
    }

    public ItemData ensureSpace(int length) {
        this.items.ensureCapacity(this.items.size() + length);
        return this;
    }

    @ApiStatus.Internal
    private ItemData(IPluginConfig config) {
        this.config = config;
    }

    @ApiStatus.Internal
    public ItemData(FriendlyByteBuf buf) {
        this.config = null;
        this.syncNbt = buf.readBoolean();
        int size = buf.m_130242_();
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            Item item = (Item)buf.m_236816_((IdMap)Registry.f_122827_);
            int count = buf.m_130242_();
            ItemStack stack = new ItemStack((ItemLike)item, count);
            if (this.syncNbt) {
                stack.m_41751_(buf.m_130260_());
            }
            this.add(stack);
        }
    }

    @Override
    @ApiStatus.Internal
    public void write(FriendlyByteBuf buf) {
        boolean syncNbt = this.config.getBoolean(CONFIG_SYNC_NBT);
        buf.writeBoolean(syncNbt);
        buf.m_130130_(this.items.size());
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            buf.m_236818_((IdMap)Registry.f_122827_, (Object)stack.m_41720_());
            buf.m_130130_(stack.m_41613_());
            if (!syncNbt) continue;
            buf.m_130079_(stack.m_41783_());
        }
    }

    @ApiStatus.Internal
    public ArrayList<ItemStack> items() {
        return this.items;
    }

    @ApiStatus.Internal
    public boolean syncNbt() {
        return this.syncNbt;
    }
}

