/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;

public final class ProgressData
implements IData {
    public static final ResourceLocation ID = BuiltinDataUtil.rl("progress");
    private final float ratio;
    private final ArrayList<ItemStack> input = new ArrayList();
    private final ArrayList<ItemStack> output = new ArrayList();
    private IntFunction<ItemStack> inventory;

    public static ProgressData ratio(float ratio) {
        return new ProgressData(Mth.m_14036_((float)ratio, (float)0.0f, (float)1.0f));
    }

    public ProgressData input(ItemStack stack) {
        this.input.add(stack);
        return this;
    }

    public ProgressData input(ItemStack ... stacks) {
        this.ensureInputSpace(stacks.length);
        Collections.addAll(this.input, stacks);
        return this;
    }

    public ProgressData input(Collection<ItemStack> stacks) {
        this.input.addAll(stacks);
        return this;
    }

    public ProgressData input(int slot) {
        this.assertInventory();
        return this.input(this.inventory.apply(slot));
    }

    public ProgressData input(int ... slots) {
        this.assertInventory();
        this.ensureInputSpace(slots.length);
        for (int slot : slots) {
            this.input.add(this.inventory.apply(slot));
        }
        return this;
    }

    public ProgressData output(ItemStack stack) {
        this.output.add(stack);
        return this;
    }

    public ProgressData output(ItemStack ... stacks) {
        this.ensureOutputSpace(stacks.length);
        Collections.addAll(this.output, stacks);
        return this;
    }

    public ProgressData output(Collection<ItemStack> stacks) {
        this.output.addAll(stacks);
        return this;
    }

    public ProgressData output(int slot) {
        this.assertInventory();
        return this.output(this.inventory.apply(slot));
    }

    public ProgressData output(int ... slots) {
        this.assertInventory();
        this.ensureOutputSpace(slots.length);
        for (int slot : slots) {
            this.output.add(this.inventory.apply(slot));
        }
        return this;
    }

    public ProgressData itemGetter(IntFunction<ItemStack> inventory) {
        this.inventory = inventory;
        return this;
    }

    public ProgressData ensureInputSpace(int length) {
        this.ensureSpace(this.input, length);
        return this;
    }

    public ProgressData ensureOutputSpace(int length) {
        this.ensureSpace(this.output, length);
        return this;
    }

    @ApiStatus.Internal
    private ProgressData(float ratio) {
        this.ratio = ratio;
    }

    @ApiStatus.Internal
    public ProgressData(FriendlyByteBuf buf) {
        this.ratio = buf.readFloat();
        int inputSize = buf.m_130242_();
        this.input.ensureCapacity(inputSize);
        for (int i = 0; i < inputSize; ++i) {
            this.input.add(buf.m_130267_());
        }
        int outputSize = buf.m_130242_();
        this.output.ensureCapacity(outputSize);
        for (int i = 0; i < outputSize; ++i) {
            this.output.add(buf.m_130267_());
        }
    }

    @Override
    @ApiStatus.Internal
    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.ratio);
        buf.m_130130_(this.input.size());
        for (ItemStack stack : this.input) {
            buf.m_130055_(stack);
        }
        buf.m_130130_(this.output.size());
        for (ItemStack stack : this.output) {
            buf.m_130055_(stack);
        }
    }

    @ApiStatus.Internal
    private void assertInventory() {
        Preconditions.checkState((this.inventory != null ? 1 : 0) != 0, (Object)"Call inventory() with stack getter first");
    }

    @ApiStatus.Internal
    private void ensureSpace(ArrayList<ItemStack> list, int toAdd) {
        list.ensureCapacity(list.size() + toAdd);
    }

    @ApiStatus.Internal
    public float ratio() {
        return this.ratio;
    }

    @ApiStatus.Internal
    public ArrayList<ItemStack> input() {
        return this.input;
    }

    @ApiStatus.Internal
    public ArrayList<ItemStack> output() {
        return this.output;
    }
}

