/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.core.pick;

import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.api.IObjectPicker;
import mcp.mobius.waila.api.IPickerAccessor;
import mcp.mobius.waila.api.IPickerResults;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.WailaConstants;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public enum ObjectPicker implements IObjectPicker
{
    INSTANCE;


    @Override
    public void pick(IPickerAccessor accessor, IPickerResults results, IPluginConfig config) {
        Entity camera = accessor.getCameraEntity();
        if (camera == null) {
            return;
        }
        boolean showBlock = config.getBoolean(WailaConstants.CONFIG_SHOW_BLOCK);
        boolean showFluid = config.getBoolean(WailaConstants.CONFIG_SHOW_FLUID);
        boolean showEntity = config.getBoolean(WailaConstants.CONFIG_SHOW_ENTITY);
        if (!(showBlock || showFluid || showEntity)) {
            return;
        }
        float frameDelta = accessor.getFrameDelta();
        double maxDistance = accessor.getMaxDistance();
        Vec3 viewVec = camera.m_20252_(frameDelta);
        Vec3 start = camera.m_20299_(frameDelta);
        Vec3 end = start.m_82520_(viewVec.f_82479_ * maxDistance, viewVec.f_82480_ * maxDistance, viewVec.f_82481_ * maxDistance);
        Level world = camera.m_9236_();
        if (showBlock || showFluid) {
            BlockGetter.m_151361_((Vec3)start, (Vec3)end, (Object)Unit.INSTANCE, (unit, pos) -> {
                VoxelShape fluidShape;
                BlockHitResult fluidHit;
                FluidState fluidState;
                BlockState blockState;
                if (showBlock && !(blockState = world.m_8055_(pos)).m_60795_()) {
                    VoxelShape blockShape = blockState.m_60808_((BlockGetter)world, pos);
                    BlockHitResult blockHit = world.m_45558_(start, end, pos.m_7949_(), blockShape, blockState);
                    if (blockHit != null) {
                        results.add((HitResult)blockHit, start.m_82557_(blockHit.m_82450_()));
                    }
                }
                if (showFluid && (fluidState = world.m_6425_(pos)).m_76170_() && (fluidHit = (fluidShape = fluidState.m_76183_((BlockGetter)world, pos)).m_83220_(start, end, pos)) != null) {
                    results.add((HitResult)fluidHit, start.m_82557_(fluidHit.m_82450_()));
                }
                return null;
            }, unit -> unit);
        }
        if (showEntity) {
            List entities = camera.f_19853_.m_6249_(camera, new AABB(start, end), EntitySelector.f_20402_);
            for (Entity entity : entities) {
                AABB bounds = entity.m_20191_();
                Vec3 clip = bounds.m_82371_(start, end).orElse(null);
                if (bounds.m_82390_(start)) {
                    clip = Objects.requireNonNullElse(clip, start);
                }
                if (clip == null) continue;
                results.add((HitResult)new EntityHitResult(entity, clip), start.m_82557_(clip));
            }
        }
    }
}

