/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.IllegalFormatException;
import java.util.Random;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public final class DisplayUtil
extends GuiComponent {
    private static final Random RANDOM = new Random();
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static void renderStack(int x, int y, ItemStack stack) {
        DisplayUtil.renderStack(x, y, stack, stack.m_41613_() > 1 ? WailaHelper.suffix(stack.m_41613_()) : "");
    }

    public static void renderStack(int x, int y, ItemStack stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.m_91291_().m_115123_(stack, x, y);
            CLIENT.m_91291_().m_115174_(DisplayUtil.CLIENT.f_91062_, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionUtil.dump(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    public static void enable3DRender() {
        Lighting.m_84931_();
        RenderSystem.m_69482_();
    }

    public static void enable2DRender() {
        Lighting.m_84930_();
        RenderSystem.m_69465_();
    }

    public static void renderRectBorder(Matrix4f matrix, BufferBuilder buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void renderComponent(PoseStack matrices, ITooltipComponent component, int x, int y, int cw, float delta) {
        component.render(matrices, x, y, delta);
        if (WailaClient.showComponentBounds) {
            matrices.m_85836_();
            float scale = (float)Minecraft.m_91087_().m_91268_().m_85449_();
            matrices.m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
            RenderSystem.m_69472_();
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buf = tesselator.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int bx = Mth.m_14107_((double)((double)((float)x * scale) + 0.5));
            int by = Mth.m_14107_((double)((double)((float)y * scale) + 0.5));
            int bw = Mth.m_14107_((double)((double)((float)(cw == 0 ? component.getWidth() : cw) * scale) + 0.5));
            int bh = Mth.m_14107_((double)((double)((float)component.getHeight() * scale) + 0.5));
            int color = -16777216 + Mth.m_14169_((float)RANDOM.nextFloat(), (float)RANDOM.nextFloat(), (float)1.0f);
            DisplayUtil.renderRectBorder(matrices.m_85850_().m_85861_(), buf, bx, by, bw, bh, 1, color, color);
            tesselator.m_85914_();
            RenderSystem.m_69493_();
            matrices.m_85849_();
        }
    }

    public static void fillGradient(Matrix4f matrix, BufferBuilder buf, int x, int y, int w, int h, int start, int end) {
        DisplayUtil.m_93123_((Matrix4f)matrix, (BufferBuilder)buf, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)0, (int)start, (int)end);
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }
}

