/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.capabilities;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.capabilities.IMapCollection;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public class MapCollectionCap
implements IMapCollection,
INBTSerializable<CompoundTag> {
    public static final Capability<MapCollectionCap> ATLAS_CAP_TOKEN = CapabilityManager.get((CapabilityToken)new CapabilityToken<MapCollectionCap>(){});
    public static final String MAP_LIST_NBT = "maps";
    private final Map<MapKey, MapDataHolder> maps = new HashMap<MapKey, MapDataHolder>();
    private final Set<Integer> ids = new HashSet<Integer>();
    private final Map<ResourceKey<Level>, Map<MapType, TreeSet<Integer>>> dimensionSlices = new HashMap<ResourceKey<Level>, Map<MapType, TreeSet<Integer>>>();
    private byte scale = 0;
    private CompoundTag lazyNbt = null;
    private final Set<Integer> duplicates = new HashSet<Integer>();
    private static final TreeSet<Integer> TOP = (TreeSet)Util.m_137537_(() -> {
        TreeSet<Integer> t = new TreeSet<Integer>();
        t.add(Integer.MAX_VALUE);
        return t;
    });

    public static void register(RegisterCapabilitiesEvent event) {
        event.register(MapCollectionCap.class);
    }

    public boolean isInitialized() {
        return this.lazyNbt == null;
    }

    private void assertInitialized() {
        Preconditions.checkState((this.lazyNbt == null ? 1 : 0) != 0, (Object)"map collection capability was not initialized");
    }

    public void fixDuplicates(Level level) {
        this.duplicates.removeIf(i -> this.add((int)i, level));
    }

    public void initialize(Level level) {
        if (level.f_46443_) {
            boolean bl = true;
        }
        if (this.lazyNbt != null) {
            int[] array = this.lazyNbt.m_128465_(MAP_LIST_NBT);
            this.lazyNbt = null;
            for (int i : array) {
                this.add(i, level);
            }
        }
    }

    public CompoundTag serializeNBT() {
        if (!this.isInitialized()) {
            return this.lazyNbt;
        }
        CompoundTag c = new CompoundTag();
        c.m_128408_(MAP_LIST_NBT, this.ids.stream().toList());
        return c;
    }

    @Override
    public int[] getAllIds() {
        if (!this.isInitialized()) {
            return this.lazyNbt.m_128465_(MAP_LIST_NBT);
        }
        return this.ids.stream().mapToInt(Integer::intValue).toArray();
    }

    public void deserializeNBT(CompoundTag c) {
        this.lazyNbt = c.m_6426_();
    }

    @Override
    public int getCount() {
        this.assertInitialized();
        return this.ids.size();
    }

    @Override
    public boolean isEmpty() {
        this.assertInitialized();
        return this.maps.isEmpty();
    }

    @Override
    public boolean add(int intId, Level level) {
        MapItemSavedData d;
        this.assertInitialized();
        MapDataHolder found = MapDataHolder.findFromId(level, intId);
        if (this.isEmpty() && found != null) {
            this.scale = found.data.f_77890_;
        }
        if (found == null) {
            if (level instanceof ServerLevel) {
                ItemStack map = MapAtlasesAccessUtils.createMapItemStackFromId(intId);
                MapItemSavedData d2 = MapItem.m_42853_((ItemStack)map, (Level)level);
                String mapString = MapItem.m_42848_((int)MapItem.m_151131_((ItemStack)map));
                found = new MapDataHolder(mapString, d2);
            } else {
                this.ids.add(intId);
                if (!this.duplicates.contains(intId)) {
                    this.duplicates.add(intId);
                }
                return false;
            }
        }
        if ((d = found.data) != null && d.f_77890_ == this.scale) {
            MapKey key = found.makeKey();
            if (this.maps.containsKey(key)) {
                this.ids.add(intId);
                if (!this.duplicates.contains(intId)) {
                    this.duplicates.add(intId);
                }
                return false;
            }
            this.ids.add(intId);
            this.maps.put(key, found);
            this.addToDimensionMap(key);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(MapDataHolder map) {
        this.assertInitialized();
        boolean success = this.ids.remove(map.id);
        if (this.maps.remove(map.makeKey()) != null) {
            this.dimensionSlices.clear();
            for (MapKey j : this.maps.keySet()) {
                this.addToDimensionMap(j);
            }
        }
        return success;
    }

    private void addToDimensionMap(MapKey j) {
        this.dimensionSlices.computeIfAbsent(j.dimension(), d -> new EnumMap(MapType.class)).computeIfAbsent(j.slice().type(), a -> new TreeSet()).add(j.slice().height() == null ? Integer.MAX_VALUE : j.slice().height());
    }

    @Override
    public byte getScale() {
        this.assertInitialized();
        return this.scale;
    }

    @Override
    public Collection<MapType> getAvailableTypes(ResourceKey<Level> dimension) {
        this.assertInitialized();
        Map<MapType, TreeSet<Integer>> mapTypeTreeSetMap = this.dimensionSlices.get(dimension);
        if (mapTypeTreeSetMap != null) {
            return mapTypeTreeSetMap.keySet();
        }
        return List.of();
    }

    @Override
    public Collection<ResourceKey<Level>> getAvailableDimensions() {
        this.assertInitialized();
        return this.dimensionSlices.keySet();
    }

    public TreeSet<Integer> getHeightTree(ResourceKey<Level> dimension, MapType kind) {
        this.assertInitialized();
        Map<MapType, TreeSet<Integer>> d = this.dimensionSlices.get(dimension);
        if (d != null) {
            return d.getOrDefault((Object)kind, TOP);
        }
        return TOP;
    }

    public List<MapDataHolder> getAll() {
        this.assertInitialized();
        return new ArrayList<MapDataHolder>(this.maps.values());
    }

    @Override
    public List<MapDataHolder> selectSection(ResourceKey<Level> dimension, Slice type) {
        this.assertInitialized();
        return this.maps.entrySet().stream().filter(e -> ((MapKey)e.getKey()).isSameDimSameSlice(dimension, type)).map(Map.Entry::getValue).toList();
    }

    @Override
    public List<MapDataHolder> filterSection(ResourceKey<Level> dimension, Slice slice, Predicate<MapItemSavedData> predicate) {
        this.assertInitialized();
        return new ArrayList<MapDataHolder>(this.maps.entrySet().stream().filter(e -> ((MapKey)e.getKey()).isSameDimSameSlice(dimension, slice) && predicate.test(((MapDataHolder)e.getValue()).data)).map(Map.Entry::getValue).toList());
    }

    @Override
    @Nullable
    public MapDataHolder selectWithKey(MapKey key) {
        this.assertInitialized();
        return this.maps.get(key);
    }

    public Pair<String, MapItemSavedData> select(MapKey key) {
        MapDataHolder r = this.selectWithKey(key);
        if (r == null) {
            return null;
        }
        return Pair.of((Object)r.stringId, (Object)r.data);
    }

    @Override
    @Nullable
    public MapDataHolder getClosest(double x, double z, ResourceKey<Level> dimension, Slice slice) {
        this.assertInitialized();
        MapDataHolder minDistState = null;
        for (Map.Entry<MapKey, MapDataHolder> e : this.maps.entrySet()) {
            MapKey key = e.getKey();
            if (!key.isSameDimSameSlice(dimension, slice)) continue;
            if (minDistState == null) {
                minDistState = e.getValue();
                continue;
            }
            if (!(MapCollectionCap.distSquare(minDistState.data, x, z) > MapCollectionCap.distSquare(e.getValue().data, x, z))) continue;
            minDistState = e.getValue();
        }
        return minDistState;
    }

    public static double distSquare(MapItemSavedData mapState, double x, double z) {
        return Mth.m_144952_((double)((double)mapState.f_77885_ - x)) + Mth.m_144952_((double)((double)mapState.f_77886_ - z));
    }

    public boolean hasOneSlice() {
        return this.maps.keySet().stream().anyMatch(k -> k.slice() != null);
    }
}

