/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.capabilities.MapCollectionCap;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.ui.MapAtlasesHUD;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.lifecycle.MapAtlasesClientEvents;
import pepjebs.mapatlases.mixin.MapDataAccessor;
import pepjebs.mapatlases.networking.S2CMapPacketWrapper;
import pepjebs.mapatlases.networking.S2CSetMapDataPacket;
import pepjebs.mapatlases.networking.S2CSyncMapCenterPacket;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasesClient {
    private static final ThreadLocal<Float> globalDecorationScale = ThreadLocal.withInitial(() -> Float.valueOf(1.0f));
    private static final ThreadLocal<Float> globalDecorationRotation = ThreadLocal.withInitial(() -> Float.valueOf(0.0f));
    @Nullable
    private static MapKey currentActiveMapKey = null;
    private static Integer lastActiveId = 0;
    private static ItemStack currentActiveAtlas = ItemStack.f_41583_;
    public static final Material OVERWORLD_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas"));
    public static final Material NETHER_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas_nether"));
    public static final Material END_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas_end"));
    public static final Material OTHER_TEXTURE = new Material(InventoryMenu.f_39692_, MapAtlasesMod.res("entity/lectern_atlas_unknown"));
    public static final List<String> DIMENSION_TEXTURE_ORDER = List.of(Level.f_46428_.m_135782_().toString(), Level.f_46429_.m_135782_().toString(), Level.f_46430_.m_135782_().toString(), "aether:the_aether", "twilightforest:twilight_forest", "undergarden:undergarden", "tropicraft:tropics", "thebetweenlands:betweenlands", "blue_skies:everbright", "the_bumblezone:the_bumblezone");
    public static final KeyMapping OPEN_ATLAS_KEYBIND = new KeyMapping("key.map_atlases.open_minimap", InputConstants.Type.KEYSYM, 77, "category.map_atlases.minimap");
    public static final KeyMapping INCREASE_MINIMAP_ZOOM = new KeyMapping("key.map_atlases.zoom_in_minimap", InputConstants.Type.KEYSYM, 334, "category.map_atlases.minimap");
    public static final KeyMapping DECREASE_MINIMAP_ZOOM = new KeyMapping("key.map_atlases.zoom_out_minimap", InputConstants.Type.KEYSYM, 333, "category.map_atlases.minimap");
    public static ShaderInstance TEXT_ALPHA_SHADER;
    public static MapAtlasesHUD HUD;

    public static void cachePlayerState(Player player) {
        ItemStack atlas;
        if (player != Minecraft.m_91087_().f_91074_) {
            return;
        }
        currentActiveAtlas = atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig(player);
        if (!atlas.m_41619_()) {
            MapDataHolder closest;
            MapCollectionCap maps = MapAtlasItem.getMaps(atlas, player.f_19853_);
            maps.fixDuplicates(player.f_19853_);
            Slice slice = MapAtlasItem.getSelectedSlic(atlas, (ResourceKey<Level>)player.f_19853_.m_46472_());
            currentActiveMapKey = MapKey.at(maps.getScale(), player, slice);
            MapDataHolder select = maps.selectWithKey(currentActiveMapKey);
            if (select == null && (closest = maps.getClosest(player, slice)) != null) {
                currentActiveMapKey = closest.makeKey();
            }
        } else {
            currentActiveMapKey = null;
        }
    }

    public static ItemStack getCurrentActiveAtlas() {
        return currentActiveAtlas;
    }

    public static MapKey getActiveMapKey() {
        return currentActiveMapKey;
    }

    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().register(MapAtlasesClient.class);
        MinecraftForge.EVENT_BUS.register(MapAtlasesClientEvents.class);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ItemProperties.register((Item)MapAtlasesMod.MAP_ATLAS.get(), (ResourceLocation)MapAtlasesMod.res("atlas"), MapAtlasesClient::getPredicateForAtlas);
    }

    @SubscribeEvent
    public static void registerShaders(RegisterShadersEvent event) {
        try {
            ShaderInstance shader = new ShaderInstance((ResourceProvider)event.getResourceManager(), MapAtlasesMod.res("text_alpha_color"), DefaultVertexFormat.f_85820_);
            event.registerShader(shader, s -> {
                TEXT_ALPHA_SHADER = s;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void textures(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            event.addSprite(END_TEXTURE.m_119203_());
            event.addSprite(OVERWORLD_TEXTURE.m_119203_());
            event.addSprite(NETHER_TEXTURE.m_119203_());
            event.addSprite(OTHER_TEXTURE.m_119203_());
        }
    }

    @SubscribeEvent
    public static void registerOverlay(RegisterGuiOverlaysEvent event) {
        HUD = new MapAtlasesHUD();
        event.registerBelow(VanillaGuiOverlay.DEBUG_TEXT.id(), "atlas", (IGuiOverlay)HUD);
    }

    @SubscribeEvent
    public static void registerKeyBinding(RegisterKeyMappingsEvent event) {
        event.register(OPEN_ATLAS_KEYBIND);
        event.register(DECREASE_MINIMAP_ZOOM);
        event.register(INCREASE_MINIMAP_ZOOM);
    }

    @Deprecated(forRemoval=true)
    public static float getWorldMapZoomLevel() {
        return globalDecorationScale.get().floatValue();
    }

    public static void setDecorationsScale(float i) {
        globalDecorationScale.set(Float.valueOf(i));
    }

    public static void setDecorationRotation(float i) {
        globalDecorationRotation.set(Float.valueOf(i));
    }

    public static float getPredicateForAtlas(ItemStack stack, ClientLevel world, LivingEntity entity, int seed) {
        if (world == null && entity != null) {
            world = (ClientLevel)entity.f_19853_;
        }
        if (world == null) {
            return 0.0f;
        }
        boolean unlocked = !MapAtlasItem.isLocked(stack);
        ResourceKey dimension = world.m_46472_();
        int i = DIMENSION_TEXTURE_ORDER.indexOf(dimension.m_135782_().toString());
        if (i == -1) {
            return unlocked ? 0.96f : 1.0f;
        }
        return (float)i / 10.0f + (unlocked ? 0.0f : 0.05f);
    }

    public static void setClientMapData(S2CSetMapDataPacket packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level level = player.f_19853_;
        level.m_142325_(packet.mapId, packet.mapData);
    }

    public static void setMapCenter(S2CSyncMapCenterPacket packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        MapItemSavedData data = level.m_7489_(packet.mapId);
        if (data != null) {
            MapAtlasesClient.setCenter(data, packet.centerX, packet.centerZ);
        }
    }

    public static void setCenter(MapItemSavedData data, int centerX, int centerZ) {
        ((MapDataAccessor)data).setX(centerX);
        ((MapDataAccessor)data).setZ(centerZ);
    }

    public static void openScreen(ItemStack atlas, @Nullable LecternBlockEntity lectern) {
        if (!MapAtlasItem.getMaps(atlas, (Level)Minecraft.m_91087_().f_91073_).isEmpty()) {
            Minecraft.m_91087_().m_91152_((Screen)new AtlasOverviewScreen(atlas, lectern));
        }
    }

    public static void openScreen(@Nullable BlockPos lecternPos) {
        @Nullable LecternBlockEntity lectern = null;
        ItemStack atlas = ItemStack.f_41583_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (lecternPos == null) {
            atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player);
        } else {
            BlockEntity blockEntity = player.f_19853_.m_7702_(lecternPos);
            if (blockEntity instanceof LecternBlockEntity) {
                LecternBlockEntity lec;
                lectern = lec = (LecternBlockEntity)blockEntity;
                atlas = lec.m_59566_();
            }
        }
        if (atlas.m_41720_() instanceof MapAtlasItem) {
            MapAtlasesClient.openScreen(atlas, lectern);
        }
    }

    public static void openScreen(ItemStack atlas) {
        MapAtlasesClient.openScreen(atlas, null);
    }

    public static ContainerLevelAccess getClientAccess() {
        return ContainerLevelAccess.m_39289_((Level)Minecraft.m_91087_().f_91073_, (BlockPos)BlockPos.f_121853_);
    }

    public static void modifyTextDecorationTransform(PoseStack poseStack, float textWidth, float textScale) {
        Float scale = globalDecorationScale.get();
        if (scale != null) {
            float s = textWidth * textScale / 2.0f;
            poseStack.m_85837_((double)s, -4.0, 0.0);
            Float rot = globalDecorationRotation.get();
            if (rot != null) {
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(rot.floatValue()));
            }
            poseStack.m_85837_((double)(-s * scale.floatValue()), (double)(4.0f * scale.floatValue()), 0.0);
            poseStack.m_85841_(scale.floatValue(), scale.floatValue(), 1.0f);
        }
    }

    public static void modifyDecorationTransform(PoseStack poseStack) {
        Float scale;
        Float rot = globalDecorationRotation.get();
        if (rot != null) {
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(rot.floatValue()));
        }
        if ((scale = globalDecorationScale.get()) != null) {
            poseStack.m_85841_(scale.floatValue(), scale.floatValue(), 1.0f);
        }
    }

    public static void handleMapPacketWrapperPacket(S2CMapPacketWrapper packet) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        Minecraft.m_91087_().f_91074_.f_108617_.m_7633_(packet.packet);
        MapItemSavedData data = level.m_7489_(MapItem.m_42848_((int)packet.packet.m_132445_()));
        if (data instanceof MapDataAccessor) {
            MapDataAccessor d = (MapDataAccessor)data;
            try {
                d.setX(packet.centerX);
                d.setZ(packet.centerZ);
                d.setDimension((ResourceKey<Level>)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)packet.dimension));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

