/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.BookmarkButton;
import pepjebs.mapatlases.integration.CustomDecorationButton;
import pepjebs.mapatlases.networking.C2SRemoveMarkerPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.MapDataHolder;

public abstract class DecorationBookmarkButton
extends BookmarkButton {
    public static final ResourceLocation MAP_ICON_TEXTURE = new ResourceLocation("textures/map/map_icons.png");
    private static final int BUTTON_H = 14;
    private static final int BUTTON_W = 24;
    protected final MapDataHolder mapData;
    protected int index = 0;
    protected boolean shfting = false;

    protected DecorationBookmarkButton(int pX, int pY, AtlasOverviewScreen parentScreen, MapDataHolder data) {
        super(pX - 24, pY, 24, 14, 0, 203, parentScreen);
        this.mapData = data;
    }

    public static DecorationBookmarkButton of(int px, int py, Object mapDecoration, MapDataHolder data, AtlasOverviewScreen screen) {
        if (mapDecoration instanceof MapDecoration) {
            MapDecoration md = (MapDecoration)mapDecoration;
            return new Vanilla(px, py, screen, data, md);
        }
        return CustomDecorationButton.create(px, py, screen, data, mapDecoration);
    }

    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.parentScreen.getMinecraft().f_91066_.f_92090_.m_90832_(pKeyCode, pScanCode)) {
            this.shfting = false;
            this.tooltip = this.createTooltip();
        }
        return false;
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.parentScreen.getMinecraft().f_91066_.f_92090_.m_90832_(pKeyCode, pScanCode)) {
            this.shfting = true;
            this.tooltip = List.of(Component.m_237115_((String)"tooltip.map_atlases.delete_marker"));
        }
        return false;
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setSelected(true);
        if (this.shfting) {
            this.deleteMarker();
            this.parentScreen.removeBookmark(this);
        } else {
            this.parentScreen.focusDecoration(this);
        }
    }

    protected abstract void deleteMarker();

    public abstract double getWorldX();

    public abstract double getWorldZ();

    public abstract Component getDecorationName();

    protected static double getDecorationPos(int decoX, MapItemSavedData data) {
        float s = (float)(1 << data.f_77890_) * 128.0f;
        return (double)s / 2.0 - (double)s / 2.0 * (double)((float)(decoX + 128) / 128.0f);
    }

    public int getBatchGroup() {
        return 0;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void m_6303_(PoseStack matrices, int pMouseX, int pMouseY, float pPartialTick) {
        matrices.m_85836_();
        matrices.m_85837_(0.0, 0.0, 0.01 * (double)this.index);
        super.m_6303_(matrices, pMouseX, pMouseY, pPartialTick);
        if (this.shfting && !this.parentScreen.isPlacingPin() && !this.parentScreen.isEditingText()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)AtlasOverviewScreen.ATLAS_TEXTURE);
            this.m_93228_(matrices, this.f_93620_, this.f_93621_, 24, 167, 5, 5);
        }
        this.renderDecoration(matrices, pMouseX, pMouseY);
        matrices.m_85849_();
        this.setSelected(false);
    }

    protected abstract void renderDecoration(PoseStack var1, int var2, int var3);

    @Override
    public List<Component> createTooltip() {
        Component mapIconComponent = this.getDecorationName();
        MutableComponent coordsComponent = Component.m_237113_((String)("X: " + this.getWorldX() + ", Z: " + this.getWorldZ()));
        MutableComponent formattedCoords = coordsComponent.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY));
        return List.of(mapIconComponent, formattedCoords);
    }

    public static class Vanilla
    extends DecorationBookmarkButton {
        private final MapDecoration decoration;

        public Vanilla(int px, int py, AtlasOverviewScreen screen, MapDataHolder data, MapDecoration mapDecoration) {
            super(px, py, screen, data);
            this.decoration = mapDecoration;
            this.tooltip = this.createTooltip();
        }

        @Override
        public double getWorldX() {
            return (double)this.mapData.data.f_77885_ - Vanilla.getDecorationPos(this.decoration.m_77804_(), this.mapData.data);
        }

        @Override
        public double getWorldZ() {
            return (double)this.mapData.data.f_77886_ - Vanilla.getDecorationPos(this.decoration.m_77805_(), this.mapData.data);
        }

        @Override
        public Component getDecorationName() {
            Component name = this.decoration.m_77810_();
            return name == null ? Component.m_237113_((String)AtlasOverviewScreen.getReadableName(this.decoration.m_77803_().name().toLowerCase(Locale.ROOT))) : name;
        }

        @Override
        public List<Component> createTooltip() {
            Component name = this.decoration.m_77810_();
            Component mapIconComponent = name == null ? Component.m_237113_((String)AtlasOverviewScreen.getReadableName(this.decoration.m_77803_().name().toLowerCase(Locale.ROOT))) : name;
            MutableComponent coordsComponent = Component.m_237113_((String)("X: " + this.decoration.m_77804_() + ", Z: " + this.decoration.m_77805_()));
            MutableComponent formattedCoords = coordsComponent.m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GRAY));
            return List.of(mapIconComponent, formattedCoords);
        }

        @Override
        protected void renderDecoration(PoseStack matrices, int pMouseX, int pMouseY) {
            byte b = this.decoration.m_77802_();
            int u = b % 16 * 8;
            int v = b / 16 * 8;
            matrices.m_85837_((double)((float)this.f_93620_ + (float)this.f_93618_ / 2.0f), (double)((float)this.f_93621_ + (float)this.f_93619_ / 2.0f), 1.0);
            matrices.m_85845_(Vector3f.f_122227_.m_122240_((float)(this.decoration.m_77806_() * 360) / 16.0f));
            matrices.m_85841_(-1.0f, -1.0f, 1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)MAP_ICON_TEXTURE);
            Vanilla.m_93133_((PoseStack)matrices, (int)-4, (int)-4, (float)u, (float)v, (int)8, (int)8, (int)128, (int)128);
        }

        @Override
        protected void deleteMarker() {
            Map decorations = this.mapData.data.f_77894_;
            for (Map.Entry d : decorations.entrySet()) {
                MapDecoration deco = (MapDecoration)d.getValue();
                if (deco != this.decoration) continue;
                MapAtlasesNetworking.sendToServer(new C2SRemoveMarkerPacket(this.mapData.stringId, deco.hashCode()));
                decorations.remove(d.getKey());
                return;
            }
        }
    }
}

