/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.Level;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.BookmarkButton;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;

public class DimensionBookmarkButton
extends BookmarkButton {
    private static final int BUTTON_H = 18;
    private static final int BUTTON_W = 24;
    private final int dimY;
    private final ResourceKey<Level> dimension;

    protected DimensionBookmarkButton(int pX, int pY, ResourceKey<Level> dimension, AtlasOverviewScreen screen) {
        super(pX, pY, 24, 18, 0, 167, screen);
        this.dimension = dimension;
        this.tooltip = this.createTooltip();
        int i = MapAtlasesClient.DIMENSION_TEXTURE_ORDER.indexOf(dimension.m_135782_().toString());
        if (i == -1) {
            i = 10;
        }
        this.dimY = 16 * i;
    }

    @Override
    public List<Component> createTooltip() {
        return List.of(Component.m_237113_((String)AtlasOverviewScreen.getReadableName(this.dimension.m_135782_())));
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public void m_6303_(PoseStack pose, int pMouseX, int pMouseY, float pPartialTick) {
        pose.m_85836_();
        if (this.selected()) {
            pose.m_85837_(0.0, 0.0, 2.0);
        }
        super.m_6303_(pose, pMouseX, pMouseY, pPartialTick);
        RenderSystem.m_157456_((int)0, (ResourceLocation)AtlasOverviewScreen.ATLAS_TEXTURE);
        this.m_93228_(pose, this.f_93620_ + 4, this.f_93621_ + 2, 162, this.dimY, 16, 16);
        pose.m_85849_();
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setSelected(true);
        this.parentScreen.selectDimension(this.dimension);
    }

    public void m_7435_(SoundManager pHandler) {
        pHandler.m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)MapAtlasesMod.ATLAS_PAGE_TURN_SOUND_EVENT.get(), (float)1.0f, (float)((float)MapAtlasesClientConfig.soundScalar.get().doubleValue())));
    }
}

