/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import pepjebs.mapatlases.client.AbstractAtlasWidget;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.client.ui.MapAtlasesHUD;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.networking.C2STeleportPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.MapDataHolder;

public class MapWidget
extends AbstractAtlasWidget
implements GuiEventListener,
NarratableEntry,
Widget {
    private static final int PAN_BUCKET = 25;
    private static final int ZOOM_BUCKET = 2;
    private final AtlasOverviewScreen mapScreen;
    protected final int x;
    protected final int y;
    protected final int width;
    protected final int height;
    private float cumulativeZoomValue;
    private float startZoom = 1.0f;
    private float cumulativeMouseX = 0.0f;
    private float cumulativeMouseY = 0.0f;
    protected double targetXCenter;
    protected double targetZCenter;
    protected float targetZoomLevel;
    private boolean isHovered;
    private float animationProgress = 0.0f;
    private float scaleAlpha = 0.0f;

    public MapWidget(int x, int y, int width, int height, int atlasesCount, AtlasOverviewScreen screen, MapDataHolder originalCenterMap) {
        super(atlasesCount);
        this.initialize(originalCenterMap);
        this.targetZoomLevel = this.zoomLevel;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.mapScreen = screen;
        this.drawBigPlayerMarker = false;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        this.currentXCenter = player.m_20185_();
        this.currentZCenter = player.m_20189_();
    }

    @Override
    protected void applyScissors(PoseStack graphics, int x, int y, int x1, int y1) {
        Vector4f v = this.mapScreen.transformPos(x, y);
        Vector4f v2 = this.mapScreen.transformPos(x1, y1);
        super.applyScissors(graphics, (int)v.m_123601_(), (int)v.m_123615_(), (int)v2.m_123601_(), (int)v2.m_123615_());
    }

    public void m_6305_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        this.isHovered = this.m_5953_(pMouseX, pMouseY);
        MapAtlasesClient.setDecorationsScale(this.zoomLevel * (float)MapAtlasesClientConfig.worldMapDecorationScale.get().doubleValue());
        this.drawAtlas(poseStack, this.x, this.y, this.width, this.height, (Player)player, this.zoomLevel, MapAtlasesClientConfig.worldMapBorder.get(), this.mapScreen.getSelectedSlice().type(), 0xF000F0);
        MapAtlasesClient.setDecorationsScale(1.0f);
        this.mapScreen.updateVisibleDecoration((int)this.currentXCenter, (int)this.currentZCenter, this.zoomLevel / 2.0f * (float)this.mapBlocksSize, this.followingPlayer);
        if (this.isHovered && this.mapScreen.isPlacingPin()) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)((float)pMouseX - 2.5f), (double)((float)pMouseY - 2.5f), 10.0);
            RenderSystem.m_157456_((int)0, (ResourceLocation)DecorationBookmarkButton.MAP_ICON_TEXTURE);
            int textureW = 128;
            int textureH = 128;
            int width = 8;
            int height = 8;
            int x = 0;
            int y = 0;
            int x1 = x + width;
            int y1 = y + height;
            float u0 = 40.0f / (float)textureW;
            float u1 = u0 + (float)width / (float)textureW;
            float centerU = (u0 + u1) / 2.0f;
            float v0 = 0.0f / (float)textureH;
            float v1 = v0 + (float)height / (float)textureH;
            float centerV = (v0 + v1) / 2.0f;
            float shrink = 4.0f / (float)textureW;
            float nu0 = Mth.m_14179_((float)shrink, (float)u0, (float)centerU);
            float nu1 = Mth.m_14179_((float)shrink, (float)u1, (float)centerU);
            float nv0 = Mth.m_14179_((float)shrink, (float)v0, (float)centerV);
            float nv1 = Mth.m_14179_((float)shrink, (float)v1, (float)centerV);
            Matrix4f pMatrix = poseStack.m_85850_().m_85861_();
            float pBlitOffset = 0.0f;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_85982_(pMatrix, (float)x, (float)y1, pBlitOffset).m_7421_(nu0, nv1).m_5752_();
            bufferbuilder.m_85982_(pMatrix, (float)x1, (float)y1, pBlitOffset).m_7421_(nu1, nv1).m_5752_();
            bufferbuilder.m_85982_(pMatrix, (float)x1, (float)y, pBlitOffset).m_7421_(nu1, nv0).m_5752_();
            bufferbuilder.m_85982_(pMatrix, (float)x, (float)y, pBlitOffset).m_7421_(nu0, nv0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
            poseStack.m_85849_();
        }
        if (this.isHovered && !this.mapScreen.isEditingText()) {
            this.renderPositionText(poseStack, mc.f_91062_, pMouseX, pMouseY);
            if (this.mapScreen.canTeleport()) {
                this.mapScreen.m_96602_(poseStack, (Component)Component.m_237115_((String)"chat.coordinates.tooltip").m_130940_(ChatFormatting.GREEN), pMouseX, pMouseY);
            }
        }
        this.renderScaleText(poseStack, mc);
    }

    private void renderScaleText(PoseStack poseStack, Minecraft mc) {
        boolean animation;
        boolean bl = animation = this.zoomLevel != this.targetZoomLevel;
        if (animation || this.scaleAlpha != 0.0f) {
            this.scaleAlpha = animation ? 1.0f : Math.max(0.0f, this.scaleAlpha - 0.03f);
            int a = (int)(this.scaleAlpha * 255.0f);
            if (a > 10) {
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, 0.0, 4.0);
                mc.f_91062_.m_92889_(poseStack, (Component)Component.m_237110_((String)"message.map_atlases.map_scale", (Object[])new Object[]{String.format("%.1f", Float.valueOf(this.targetZoomLevel))}), (float)this.x, (float)(this.y + this.height - 8), FastColor.ARGB32.m_13660_((int)a, (int)255, (int)255, (int)255));
                poseStack.m_85849_();
            }
        }
    }

    @Override
    public MapDataHolder getMapWithCenter(int centerX, int centerZ) {
        return this.mapScreen.findMapEntryForCenter(centerX, centerZ);
    }

    private void renderPositionText(PoseStack graphics, Font font, int mouseX, int mouseY) {
        if (!MapAtlasesClientConfig.drawWorldMapCoords.get().booleanValue()) {
            return;
        }
        ColumnPos pos = this.getHoveredPos(mouseX, mouseY);
        float textScaling = (float)MapAtlasesClientConfig.worldMapCoordsScale.get().doubleValue();
        String coordsToDisplay = "X: " + pos.f_140723_() + ", Z: " + pos.f_140724_();
        MapAtlasesHUD.drawScaledComponent(graphics, font, this.x, this.y + this.height + 8, coordsToDisplay, textScaling, this.width, this.width);
    }

    public boolean m_5953_(double pMouseX, double pMouseY) {
        return pMouseX >= (double)this.x && pMouseY >= (double)this.y && pMouseX < (double)(this.x + this.width) && pMouseY < (double)(this.y + this.height);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double deltaX, double deltaY) {
        if (pButton == 0) {
            double newZCenter;
            double newXCenter;
            boolean discrete;
            this.cumulativeMouseX = (float)((double)this.cumulativeMouseX + deltaX);
            this.cumulativeMouseY = (float)((double)this.cumulativeMouseY + deltaY);
            boolean bl = discrete = MapAtlasesClientConfig.worldMapSmoothPanning.get() == false;
            if (discrete) {
                newXCenter = (int)(this.currentXCenter - (double)(MapWidget.round((int)this.cumulativeMouseX, 25) / 25 * this.mapBlocksSize));
                newZCenter = (int)(this.currentZCenter - (double)(MapWidget.round((int)this.cumulativeMouseY, 25) / 25 * this.mapBlocksSize));
            } else {
                newXCenter = this.currentXCenter - (double)(this.cumulativeMouseX * this.zoomLevel * (float)(this.mapBlocksSize / 128));
                newZCenter = this.currentZCenter - (double)(this.cumulativeMouseY * this.zoomLevel * (float)(this.mapBlocksSize / 128));
            }
            if (newXCenter != this.currentXCenter) {
                this.targetXCenter = newXCenter;
                if (!discrete) {
                    this.currentXCenter = this.targetXCenter;
                }
                this.cumulativeMouseX = 0.0f;
            }
            if (newZCenter != this.currentZCenter) {
                this.targetZCenter = newZCenter;
                if (!discrete) {
                    this.currentZCenter = this.targetZCenter;
                }
                this.cumulativeMouseY = 0.0f;
            }
            this.followingPlayer = false;
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, deltaX, deltaY);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.targetZoomLevel > 20.0f && pDelta < 0.0) {
            return false;
        }
        if (MapAtlasesClientConfig.worldMapSmoothZooming.get().booleanValue()) {
            float c = (float)pDelta;
            float v = -c / 10.0f;
            this.targetZoomLevel = Math.max(this.startZoom, this.targetZoomLevel + v);
            this.zoomLevel = this.targetZoomLevel - 0.001f;
        } else {
            this.cumulativeZoomValue = (float)((double)this.cumulativeZoomValue - pDelta);
            this.cumulativeZoomValue = Math.max(this.cumulativeZoomValue, 0.0f);
            float zl = MapWidget.round((int)this.cumulativeZoomValue, 2) / 2;
            zl = Math.max(zl, 0.0f);
            this.targetZoomLevel = this.startZoom + 2.0f * zl + 1.0f;
        }
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int pButton) {
        if (this.isHovered) {
            if (this.mapScreen.isPlacingPin()) {
                ColumnPos pos = this.getHoveredPos(mouseX, mouseY);
                this.mapScreen.placePinAt(pos);
                this.mapScreen.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
            } else if (this.mapScreen.canTeleport()) {
                ColumnPos pos = this.getHoveredPos(mouseX, mouseY);
                MapAtlasesNetworking.sendToServer(new C2STeleportPacket(pos.f_140723_(), pos.f_140724_(), this.mapScreen.getSelectedSlice().height(), this.mapScreen.getSelectedDimension()));
                return true;
            }
            return !this.mapScreen.isEditingText();
        }
        return false;
    }

    @NotNull
    private ColumnPos getHoveredPos(double mouseX, double mouseY) {
        double atlasMapsRelativeMouseX = Mth.m_144914_((double)mouseX, (double)this.x, (double)(this.x + this.width), (double)-1.0, (double)1.0);
        double atlasMapsRelativeMouseZ = Mth.m_144914_((double)mouseY, (double)this.y, (double)(this.y + this.height), (double)-1.0, (double)1.0);
        int hackOffset = 3;
        return new ColumnPos((int)(Math.floor(atlasMapsRelativeMouseX * (double)this.zoomLevel * ((double)this.mapBlocksSize / 2.0)) + this.currentXCenter) + hackOffset, (int)(Math.floor(atlasMapsRelativeMouseZ * (double)this.zoomLevel * ((double)this.mapBlocksSize / 2.0)) + this.currentZCenter) + hackOffset);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public void resetAndCenter(int centerX, int centerZ, boolean followPlayer, boolean animation) {
        this.targetXCenter = centerX;
        this.targetZCenter = centerZ;
        if (!animation) {
            this.currentXCenter = centerX;
            this.currentZCenter = centerZ;
        }
        this.cumulativeMouseX = 0.0f;
        this.cumulativeMouseY = 0.0f;
        this.cumulativeZoomValue = 0.0f;
        this.followingPlayer = followPlayer;
        this.resetZoom();
    }

    public void resetZoom() {
        this.targetZoomLevel = (float)this.atlasesCount * this.mapScreen.getSelectedSlice().type().getDefaultZoomFactor();
    }

    public void tick() {
        float animationSpeed = 0.4f;
        if (this.animationProgress != 0.0f) {
            this.animationProgress = (float)((double)this.animationProgress - ((double)(this.animationProgress * animationSpeed) - 0.01));
            this.animationProgress = Math.max(0.0f, this.animationProgress);
        }
        if (this.zoomLevel != this.targetZoomLevel) {
            this.zoomLevel = (float)this.interpolate(this.targetZoomLevel, this.zoomLevel, animationSpeed);
        }
        boolean test = true;
        if (this.currentXCenter != this.targetXCenter) {
            this.currentXCenter = this.interpolate(this.targetXCenter, this.currentXCenter, animationSpeed);
            test = false;
        }
        if (this.currentZCenter != this.targetZCenter) {
            this.currentZCenter = this.interpolate(this.targetZCenter, this.currentZCenter, animationSpeed);
            test = false;
        }
        if (this.followingPlayer) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.targetXCenter = (int)player.m_20185_();
            this.targetZCenter = (int)player.m_20189_();
        }
    }

    private double interpolate(double targetZCenter, double currentZCenter, double animationSpeed) {
        double diff = targetZCenter - currentZCenter;
        if (diff < 0.0) {
            return Math.max(targetZCenter, currentZCenter + diff * animationSpeed - 0.001);
        }
        return Math.min(targetZCenter, currentZCenter + diff * animationSpeed + 0.001);
    }
}

