/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.capabilities.MapCollectionCap;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.client.AbstractAtlasWidget;
import pepjebs.mapatlases.client.Anchoring;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.config.MapAtlasesClientConfig;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasesHUD
extends AbstractAtlasWidget
implements IGuiOverlay {
    public static final ResourceLocation MAP_BACKGROUND = MapAtlasesMod.res("textures/gui/hud/map_background.png");
    public static final ResourceLocation MAP_FOREGROUND = MapAtlasesMod.res("textures/gui/hud/map_foreground.png");
    private static final int BACKGROUND_SIZE = 128;
    protected final int BG_SIZE = 64;
    private final Minecraft mc;
    private boolean needsInit = true;
    private ItemStack currentAtlas = ItemStack.f_41583_;
    private MapKey currentMapKey = null;
    private float globalScale = 1.0f;
    private boolean displaysY = true;

    public MapAtlasesHUD() {
        super(1);
        this.mc = Minecraft.m_91087_();
        this.rotatesWithPlayer = true;
        this.zoomLevel = 1.0f;
    }

    @Override
    @Nullable
    public MapDataHolder getMapWithCenter(int centerX, int centerZ) {
        Slice slice = this.currentMapKey.slice();
        MapCollectionCap maps = MapAtlasItem.getMaps(this.currentAtlas, (Level)this.mc.f_91073_);
        return maps.selectWithKey(centerX, centerZ, this.currentMapKey.dimension(), slice);
    }

    @Override
    protected void initialize(MapDataHolder originalCenterMap) {
        super.initialize(originalCenterMap);
        this.followingPlayer = MapAtlasesClientConfig.miniMapFollowPlayer.get();
        this.rotatesWithPlayer = MapAtlasesClientConfig.miniMapRotate.get();
        this.globalScale = (float)MapAtlasesClientConfig.miniMapScale.get().doubleValue();
        this.displaysY = MapAtlasesClientConfig.yOnlyWithSlice.get() == false || MapAtlasItem.getMaps(this.currentAtlas, (Level)this.mc.f_91073_).hasOneSlice();
        this.drawBigPlayerMarker = MapAtlasesClientConfig.miniMapFollowPlayer.get();
    }

    @Override
    protected void applyScissors(PoseStack graphics, int x, int y, int x1, int y1) {
        super.applyScissors(graphics, (int)((float)x * this.globalScale), (int)((float)y * this.globalScale), (int)((float)x1 * this.globalScale), (int)((float)y1 * this.globalScale));
    }

    public void render(ForgeGui forgeGui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (this.mc.f_91073_ == null || this.mc.f_91074_ == null) {
            return;
        }
        if (this.mc.f_91066_.f_92063_) {
            return;
        }
        if (!MapAtlasesClientConfig.drawMiniMapHUD.get().booleanValue()) {
            return;
        }
        ItemStack atlas = MapAtlasesClient.getCurrentActiveAtlas();
        if (MapAtlasesClientConfig.hideWhenInHand.get().booleanValue() && (this.mc.f_91074_.m_21205_().m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()) || this.mc.f_91074_.m_21206_().m_150930_((Item)MapAtlasesMod.MAP_ATLAS.get()))) {
            return;
        }
        if (this.currentAtlas != atlas) {
            this.needsInit = true;
        }
        this.currentAtlas = atlas;
        if (atlas.m_41619_()) {
            return;
        }
        ClientLevel level = this.mc.f_91073_;
        LocalPlayer player = this.mc.f_91074_;
        MapCollectionCap maps = MapAtlasItem.getMaps(atlas, (Level)level);
        this.currentMapKey = MapAtlasesClient.getActiveMapKey();
        if (this.currentMapKey == null) {
            return;
        }
        MapDataHolder activeMap = maps.selectWithKey(this.currentMapKey);
        if (activeMap == null) {
            return;
        }
        if (this.needsInit) {
            this.needsInit = false;
            this.initialize(activeMap);
        }
        poseStack.m_85836_();
        poseStack.m_85841_(this.globalScale, this.globalScale, 1.0f);
        int mapWidgetSize = 58;
        Anchoring anchorLocation = MapAtlasesClientConfig.miniMapAnchoring.get();
        int x = anchorLocation.isLeft ? 0 : (int)((float)screenWidth / this.globalScale) - 64;
        int y = anchorLocation.isUp ? 0 : (int)((float)screenHeight / this.globalScale) - 64;
        x = (int)((float)x + (float)MapAtlasesClientConfig.miniMapHorizontalOffset.get().intValue() / this.globalScale);
        y = (int)((float)y + (float)MapAtlasesClientConfig.miniMapVerticalOffset.get().intValue() / this.globalScale);
        if (anchorLocation.isUp && !anchorLocation.isLeft) {
            boolean hasBeneficial = false;
            boolean hasNegative = false;
            for (MobEffectInstance e : player.m_21220_()) {
                MobEffect effect = e.m_19544_();
                if (effect.m_19486_()) {
                    hasBeneficial = true;
                    continue;
                }
                hasNegative = true;
            }
            int offsetForEffects = MapAtlasesClientConfig.activePotionVerticalOffset.get();
            if (hasNegative && y < 2 * offsetForEffects) {
                y += 2 * offsetForEffects - y;
            } else if (hasBeneficial && y < offsetForEffects) {
                y += offsetForEffects - y;
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)MAP_BACKGROUND);
        GuiComponent.m_93160_((PoseStack)poseStack, (int)x, (int)y, (int)64, (int)64, (float)0.0f, (float)0.0f, (int)128, (int)128, (int)128, (int)128);
        poseStack.m_85836_();
        if (this.followingPlayer) {
            this.currentXCenter = player.m_20185_();
            this.currentZCenter = player.m_20189_();
        }
        MapAtlasesClient.setDecorationsScale((float)((double)this.zoomLevel * MapAtlasesClientConfig.miniMapDecorationScale.get()));
        float yRot = player.m_146908_();
        if (this.rotatesWithPlayer) {
            MapAtlasesClient.setDecorationRotation(yRot - 180.0f);
        }
        int light = MapAtlasesClientConfig.minimapSkyLight.get() == false ? 0xF000F0 : LightTexture.m_109885_((int)0, (int)level.m_45517_(LightLayer.SKY, player.m_20097_().m_7494_()));
        int borderSize = (64 - mapWidgetSize) / 2;
        this.drawAtlas(poseStack, x + borderSize, y + borderSize, mapWidgetSize, mapWidgetSize, (Player)player, this.zoomLevel * (float)MapAtlasesClientConfig.miniMapZoomMultiplier.get().doubleValue(), MapAtlasesClientConfig.miniMapBorder.get(), this.currentMapKey.slice().type(), light);
        MapAtlasesClient.setDecorationsScale(1.0f);
        if (this.rotatesWithPlayer) {
            MapAtlasesClient.setDecorationRotation(0.0f);
        }
        if (this.rotatesWithPlayer) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)DecorationBookmarkButton.MAP_ICON_TEXTURE);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(x + mapWidgetSize / 2 - 1), (int)(y + mapWidgetSize / 2 - 1), (float)0.0f, (float)0.0f, (int)8, (int)8, (int)128, (int)128);
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)x + (float)mapWidgetSize / 2.0f + 3.0f), (double)((float)y + (float)mapWidgetSize / 2.0f + 3.0f), 0.0);
        if (!this.rotatesWithPlayer) {
            poseStack.m_85845_(Vector3f.f_122226_.m_122240_(180.0f - yRot));
        }
        poseStack.m_85837_(-4.5, -4.0, 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)DecorationBookmarkButton.MAP_ICON_TEXTURE);
        MapAtlasesHUD.m_93133_((PoseStack)poseStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)128, (int)128);
        poseStack.m_85849_();
        poseStack.m_85849_();
        float textScaling = (float)MapAtlasesClientConfig.minimapCoordsAndBiomeScale.get().doubleValue();
        int textHeightOffset = 0;
        int actualBgSize = (int)(64.0f * this.globalScale);
        if (!anchorLocation.isUp) {
            // empty if block
        }
        Font font = this.mc.f_91062_;
        if (MapAtlasesClientConfig.drawMinimapCoords.get().booleanValue()) {
            this.drawMapComponentCoords(poseStack, font, x, (int)((float)(y + 64) + (float)textHeightOffset / this.globalScale), actualBgSize, textScaling, new BlockPos(new Vec3i(MapAtlasesHUD.towardsZero(player.m_20182_().f_82479_), MapAtlasesHUD.towardsZero(player.m_20182_().f_82480_), MapAtlasesHUD.towardsZero(player.m_20182_().f_82481_))));
            textHeightOffset = (int)((float)textHeightOffset + 10.0f * textScaling);
        }
        if (MapAtlasesClientConfig.drawMinimapBiome.get().booleanValue()) {
            this.drawMapComponentBiome(poseStack, font, x, (int)((float)(y + 64) + (float)textHeightOffset / this.globalScale), actualBgSize, textScaling, player.m_20183_(), (Level)level);
        }
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)x + 32.0f), (double)((float)y + 32.0f), 5.0);
        Pair<Float, Float> p = MapAtlasesHUD.getDirectionPos(29.0f, this.rotatesWithPlayer ? yRot : 180.0f);
        float a = ((Float)p.getFirst()).floatValue();
        float b = ((Float)p.getSecond()).floatValue();
        this.drawLetter(poseStack, font, a, b, "N");
        if (!MapAtlasesClientConfig.miniMapOnlyNorth.get().booleanValue()) {
            this.drawLetter(poseStack, font, -a, -b, "S");
            this.drawLetter(poseStack, font, -b, a, "E");
            this.drawLetter(poseStack, font, b, -a, "W");
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private void drawLetter(PoseStack pose, Font font, float a, float b, String letter) {
        pose.m_85836_();
        float scale = (float)MapAtlasesClientConfig.miniMapCardinalsScale.get().doubleValue() / this.globalScale;
        pose.m_85841_(scale, scale, 1.0f);
        float f = a / scale - (float)font.m_92895_(letter) / 2.0f;
        float f2 = b / scale;
        Objects.requireNonNull(font);
        MapAtlasesHUD.drawStringWithLighterShadow(pose, font, letter, f, f2 - 9.0f / 2.0f);
        pose.m_85849_();
    }

    private static void playSoundIfMapChanged(String curMapId, ClientLevel level, LocalPlayer player) {
    }

    private static int towardsZero(double d) {
        if (d < 0.0) {
            return -1 * (int)Math.floor(-1.0 * d);
        }
        return (int)Math.floor(d);
    }

    public void drawMapComponentCoords(PoseStack context, Font font, int x, int y, int targetWidth, float textScaling, BlockPos pos) {
        String coordsToDisplay = this.displaysY ? pos.m_123344_() : pos.m_123341_() + ", " + pos.m_123343_();
        MapAtlasesHUD.drawScaledComponent(context, font, x, y, coordsToDisplay, textScaling / this.globalScale, targetWidth, (int)((float)targetWidth / this.globalScale));
    }

    public void drawMapComponentBiome(PoseStack context, Font font, int x, int y, int targetWidth, float textScaling, BlockPos blockPos, Level level) {
        String biomeToDisplay = "";
        Optional key = level.m_204166_(blockPos).m_203543_();
        if (key.isPresent()) {
            ResourceKey biomeKey = (ResourceKey)key.get();
            biomeToDisplay = Component.m_237115_((String)Util.m_137492_((String)"biome", (ResourceLocation)biomeKey.m_135782_())).getString();
        }
        MapAtlasesHUD.drawScaledComponent(context, font, x, y, biomeToDisplay, textScaling / this.globalScale, targetWidth, (int)((float)targetWidth / this.globalScale));
    }

    public static void drawScaledComponent(PoseStack pose, Font font, int x, int y, String text, float textScaling, int maxWidth, int targetWidth) {
        float textWidth = font.m_92895_(text);
        float scale = Math.min(1.0f, (float)maxWidth * textScaling / textWidth);
        float centerX = (float)x + (float)targetWidth / 2.0f;
        pose.m_85836_();
        pose.m_85837_((double)centerX, (double)(y + 4), 5.0);
        pose.m_85841_(scale *= textScaling, scale, 1.0f);
        pose.m_85837_((double)(-textWidth / 2.0f), -4.0, 0.0);
        MapAtlasesHUD.drawStringWithLighterShadow(pose, font, text, 0.0f, 0.0f);
        pose.m_85849_();
    }

    private static void drawStringWithLighterShadow(PoseStack pose, Font font, String text, float x, float y) {
        font.m_92883_(pose, text, x + 1.0f, y + 1.0f, 0x595959);
        font.m_92883_(pose, text, x, y, 0xE0E0E0);
    }

    private static Pair<Float, Float> getDirectionPos(float radius, float angleDegrees) {
        float y;
        float x;
        angleDegrees = Mth.m_14177_((float)(90.0f - angleDegrees));
        float angleRadians = (float)Math.toRadians(angleDegrees);
        if (angleDegrees >= -45.0f && angleDegrees < 45.0f) {
            x = radius;
            y = radius * (float)Math.tan(angleRadians);
        } else if (angleDegrees >= 45.0f && angleDegrees < 135.0f) {
            x = radius / (float)Math.tan(angleRadians);
            y = radius;
        } else if (angleDegrees >= 135.0f || angleDegrees < -135.0f) {
            x = -radius;
            y = -radius * (float)Math.tan(angleRadians);
        } else {
            x = -radius / (float)Math.tan(angleRadians);
            y = -radius;
        }
        return Pair.of((Object)Float.valueOf(x), (Object)Float.valueOf(y));
    }

    public void decreaseZoom() {
        this.zoomLevel = Math.max(1.0f, this.zoomLevel - 0.5f);
    }

    public void increaseZoom() {
        this.zoomLevel = Math.min(10.0f, this.zoomLevel + 0.5f);
    }
}

