/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.DataObjectReference;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.integration.CustomDecorationButton;
import pepjebs.mapatlases.utils.MapDataHolder;

public class ClientMarker {
    private static final TagKey<MapDecorationType<?, ?>> PINS = TagKey.m_203882_((ResourceKey)MapDecorationRegistry.REGISTRY_KEY, (ResourceLocation)MapAtlasesMod.res("pins"));
    private static int name = 0;
    private static final Map<String, Set<MapBlockMarker<?>>> markers = new HashMap();
    private static final Map<MapItemSavedData, String> mapLookup = new IdentityHashMap<MapItemSavedData, String>();
    private static final DataObjectReference<MapDecorationType<?, ?>> PIN = new DataObjectReference(MapAtlasesMod.res("pin"), MapDecorationRegistry.REGISTRY_KEY);

    public static void saveClientMarkers() {
        if (markers.isEmpty()) {
            return;
        }
        try {
            Path path = ClientMarker.getPath();
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            try (FileOutputStream outputstream = new FileOutputStream(path.toFile());){
                NbtIo.m_128947_((CompoundTag)ClientMarker.save(), (OutputStream)outputstream);
            }
            boolean bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        markers.clear();
    }

    public static void loadClientMarkers(int hash) {
        markers.clear();
        mapLookup.clear();
        name = hash;
        Path path = ClientMarker.getPath();
        try (FileInputStream inputStream = new FileInputStream(path.toFile());){
            ClientMarker.load(NbtIo.m_128939_((InputStream)inputStream));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    private static Path getPath() {
        return FMLPaths.GAMEDIR.get().resolve("map_atlases/" + name + ".nbt");
    }

    public static void addMarker(MapDataHolder holder, ColumnPos pos, String text, int index) {
        List<Holder<MapDecorationType<?, ?>>> pins = ClientMarker.getPins();
        MapBlockMarker marker = ((MapDecorationType)pins.get(index % pins.size()).get()).createEmptyMarker();
        if (!text.isEmpty()) {
            marker.setName((Component)Component.m_237115_((String)text));
        }
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        Integer h = holder.height;
        if (h == null) {
            h = level.m_46472_().equals((Object)holder.data.f_77887_) ? level.m_6924_(Heightmap.Types.MOTION_BLOCKING, pos.f_140724_(), pos.f_140724_()) : 64;
        }
        marker.setPos(new BlockPos(pos.f_140723_(), h.intValue(), pos.f_140724_()));
        markers.computeIfAbsent(holder.stringId, k -> new HashSet()).add(marker);
        ((ExpandedMapData)holder.data).addCustomMarker(marker);
    }

    @NotNull
    private static List<Holder<MapDecorationType<?, ?>>> getPins() {
        return ((HolderSet.Named)MapDecorationRegistry.getRegistry((RegistryAccess)Utils.hackyGetRegistryAccess()).m_203431_(PINS).get()).m_203614_().toList();
    }

    private static void load(CompoundTag tag) {
        for (String k : tag.m_128431_()) {
            HashSet<MapBlockMarker> l = new HashSet<MapBlockMarker>();
            ListTag listNbt = tag.m_128437_(k, 10);
            for (int j = 0; j < listNbt.size(); ++j) {
                CompoundTag c = listNbt.m_128728_(j);
                MapBlockMarker marker = MapDataInternal.readWorldMarker((CompoundTag)c);
                if (marker == null) continue;
                l.add(marker);
            }
            markers.put(k, l);
        }
    }

    private static CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, Set<MapBlockMarker<?>>> v : markers.entrySet()) {
            ListTag listNBT = new ListTag();
            for (MapBlockMarker<?> marker : v.getValue()) {
                CompoundTag c = new CompoundTag();
                c.m_128365_(marker.getTypeId(), (Tag)marker.saveToNBT(new CompoundTag()));
                listNBT.add((Object)c);
            }
            tag.m_128365_(v.getKey().toString(), (Tag)listNBT);
        }
        return tag;
    }

    public static Set<MapBlockMarker<?>> send(Integer integer, MapItemSavedData data) {
        String stringId = mapLookup.computeIfAbsent(data, g -> {
            String st = Objects.requireNonNull(MapDataHolder.findFromId((Level)Minecraft.m_91087_().f_91073_, (int)integer.intValue())).stringId;
            Set<MapBlockMarker<?>> mr = markers.get(st);
            if (mr != null) {
                for (MapBlockMarker<?> mapBlockMarker : mr) {
                }
            }
            return st;
        });
        Set<MapBlockMarker<?>> m = markers.get(stringId);
        if (m != null) {
            return m;
        }
        return Set.of();
    }

    public static void removeDeco(String mapId, String key) {
        Set<MapBlockMarker<?>> mr = markers.get(mapId);
        if (mr != null) {
            mr.removeIf(m -> m.getMarkerId().equals(key));
        }
    }

    public static void renderPin(PoseStack poseStack, float x, float y, int index, boolean outline) {
        List<Holder<MapDecorationType<?, ?>>> p = ClientMarker.getPins();
        Holder<MapDecorationType<?, ?>> t = p.get(index % p.size());
        CustomMapDecoration d = new CustomMapDecoration((MapDecorationType)t.m_203334_(), 0, 0, 0, null);
        CustomDecorationButton.renderStaticMarker(poseStack, d, null, x, y, 1, outline);
    }
}

