/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.client.DecorationRenderer;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationClientHandler;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.client.screen.AtlasOverviewScreen;
import pepjebs.mapatlases.client.screen.DecorationBookmarkButton;
import pepjebs.mapatlases.integration.ClientMarker;
import pepjebs.mapatlases.networking.C2SRemoveMarkerPacket;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.utils.MapDataHolder;

public class CustomDecorationButton
extends DecorationBookmarkButton {
    private final CustomMapDecoration decoration;

    public static DecorationBookmarkButton create(int px, int py, AtlasOverviewScreen screen, MapDataHolder data, Object mapDecoration) {
        return new CustomDecorationButton(px, py, screen, data, (CustomMapDecoration)mapDecoration);
    }

    private CustomDecorationButton(int px, int py, AtlasOverviewScreen screen, MapDataHolder data, CustomMapDecoration mapDecoration) {
        super(px, py, screen, data);
        this.decoration = mapDecoration;
        this.tooltip = this.createTooltip();
    }

    @Override
    public double getWorldX() {
        return (double)this.mapData.data.f_77885_ - CustomDecorationButton.getDecorationPos(this.decoration.getX(), this.mapData.data);
    }

    @Override
    public double getWorldZ() {
        return (double)this.mapData.data.f_77886_ - CustomDecorationButton.getDecorationPos(this.decoration.getY(), this.mapData.data);
    }

    @Override
    public int getBatchGroup() {
        return 1;
    }

    @Override
    public Component getDecorationName() {
        Component displayName = this.decoration.getDisplayName();
        return displayName == null ? Component.m_237113_((String)AtlasOverviewScreen.getReadableName(Utils.getID((MapDecorationType)this.decoration.getType()).m_135815_().toLowerCase(Locale.ROOT))) : displayName;
    }

    @Override
    protected void renderDecoration(PoseStack pGuiGraphics, int pMouseX, int pMouseY) {
        CustomDecorationButton.renderStaticMarker(pGuiGraphics, this.decoration, this.mapData.data, (float)this.f_93620_ + (float)this.f_93618_ / 2.0f, (float)this.f_93621_ + (float)this.f_93619_ / 2.0f, this.index, false);
    }

    @Override
    protected void deleteMarker() {
        Map decorations = ((ExpandedMapData)this.mapData.data).getCustomDecorations();
        for (Map.Entry d : decorations.entrySet()) {
            CustomMapDecoration deco = (CustomMapDecoration)d.getValue();
            if (deco != this.decoration) continue;
            MapAtlasesNetworking.sendToServer(new C2SRemoveMarkerPacket(this.mapData.stringId, deco.hashCode()));
            decorations.remove(d.getKey());
            ClientMarker.removeDeco(this.mapData.stringId, (String)d.getKey());
            return;
        }
    }

    public static void renderStaticMarker(PoseStack poseStack, CustomMapDecoration decoration, MapItemSavedData data, float x, float y, int index, boolean outline) {
        DecorationRenderer renderer = MapDecorationClientHandler.getRenderer((CustomMapDecoration)decoration);
        if (renderer != null) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)x, (double)y, 1.0);
            poseStack.m_85837_((double)(-((float)decoration.getX()) / 2.0f - 64.0f), (double)(-((float)decoration.getY()) / 2.0f - 64.0f), (double)-0.02f);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            renderer.rendersText = false;
            if (outline) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ResourceLocation id = Utils.getID((MapDecorationType)decoration.getType());
                ResourceLocation texture = new ResourceLocation(id.m_135827_(), "map_markers/" + id.m_135815_());
                VertexConsumer vb2 = buffer.m_6299_(R.COLOR_TEXT.apply(texture));
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (j == 0 && k == 0) continue;
                        poseStack.m_85836_();
                        poseStack.m_85837_((double)j * 0.5, (double)k * 0.5, -0.01);
                        renderer.render(decoration, poseStack, (MultiBufferSource)buffer, vb2, data, false, 0xF000F0, index);
                        poseStack.m_85849_();
                    }
                }
            }
            renderer.render(decoration, poseStack, (MultiBufferSource)buffer, data, false, 0xF000F0, index);
            renderer.rendersText = true;
            poseStack.m_85849_();
        }
    }

    private static class R
    extends RenderType {
        protected static final RenderStateShard.ShaderStateShard SHARD = new RenderStateShard.ShaderStateShard(() -> MapAtlasesClient.TEXT_ALPHA_SHADER);
        public static final Function<ResourceLocation, RenderType> COLOR_TEXT = Util.m_143827_(p_173249_ -> R.m_173215_((String)"map_atlases_text_colored", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(SHARD).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(p_173249_, false, true)).m_110685_(f_110139_).m_110671_(f_110152_).m_110691_(false)));

        public R(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

