/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.integration;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.integration.ClientMarker;
import pepjebs.mapatlases.utils.MapDataHolder;

public class MoonlightCompat {
    public static void init() {
        if (PlatformHelper.getEnv().isClient()) {
            ResourceLocation a = MapDataInternal.GENERIC_STRUCTURE_ID;
            MapDecorationRegistry.addDynamicClientMarkersEvent(ClientMarker::send);
        }
    }

    public static Collection<Pair<Object, MapDataHolder>> getCustomDecorations(MapDataHolder map) {
        return ((ExpandedMapData)map.data).getCustomDecorations().values().stream().map(a -> Pair.of((Object)a, (Object)map)).toList();
    }

    public static void addDecoration(MapItemSavedData data, BlockPos pos, ResourceLocation id, @Nullable Component name) {
        MapDecorationType type = MapDecorationRegistry.get((ResourceLocation)id);
        if (type != null) {
            MapBlockMarker defaultMarker = type.createEmptyMarker();
            defaultMarker.setPos(pos);
            defaultMarker.setName(name);
            ((ExpandedMapData)data).addCustomMarker(defaultMarker);
        }
    }

    public static void removeCustomDecoration(MapItemSavedData data, int hash) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData d = (ExpandedMapData)data;
            d.getCustomDecorations().entrySet().removeIf(e -> ((CustomMapDecoration)e.getValue()).hashCode() == hash);
        }
    }
}

