/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.lifecycle;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.capabilities.MapCollectionCap;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.SupplementariesCompat;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.networking.MapAtlasesNetworking;
import pepjebs.mapatlases.networking.S2CWorldHashPacket;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;
import pepjebs.mapatlases.utils.MapDataHolder;
import pepjebs.mapatlases.utils.Slice;

public class MapAtlasesServerEvents {
    private static final ReentrantLock mutex = new ReentrantLock();
    private static final WeakHashMap<Player, HashMap<String, MapUpdateTicket>> updateQueue = new WeakHashMap();

    @SubscribeEvent
    public static void mapAtlasesPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == LogicalSide.CLIENT) {
            MapAtlasesClient.cachePlayerState(event.player);
        } else {
            ServerPlayer player = (ServerPlayer)event.player;
            MinecraftServer server = player.f_8924_;
            ItemStack atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player);
            if (atlas.m_41619_()) {
                return;
            }
            Level level = player.f_19853_;
            MapCollectionCap maps = MapAtlasItem.getMaps(atlas, level);
            Slice slice = MapAtlasItem.getSelectedSlic(atlas, (ResourceKey<Level>)level.m_46472_());
            MapKey activeKey = MapKey.at(maps.getScale(), (Player)player, slice);
            int playX = player.m_20183_().m_123341_();
            int playZ = player.m_20183_().m_123343_();
            byte scale = maps.getScale();
            int scaleWidth = (1 << scale) * 128;
            Set<Vec2> discoveringEdges = MapAtlasesServerEvents.getPlayerDiscoveringMapEdges(activeKey.mapX(), activeKey.mapZ(), scaleWidth, playX, playZ, slice.getDiscoveryReach());
            List<MapDataHolder> nearbyExistentMaps = maps.filterSection((ResourceKey<Level>)level.m_46472_(), slice, e -> discoveringEdges.stream().anyMatch(edge -> edge.f_82470_ == (float)e.f_77885_ && edge.f_82471_ == (float)e.f_77886_));
            MapDataHolder activeInfo = maps.selectWithKey(activeKey);
            if (activeInfo == null) {
                MapAtlasesServerEvents.maybeCreateNewMapEntry(player, atlas, maps, slice, Mth.m_14107_((double)player.m_20185_()), Mth.m_14107_((double)player.m_20189_()));
            }
            if (!nearbyExistentMaps.isEmpty()) {
                if (MapAtlasesConfig.roundRobinUpdate.get().booleanValue()) {
                    selected = nearbyExistentMaps.get(server.m_129921_() % nearbyExistentMaps.size());
                    selected.updateMap(player);
                } else {
                    for (int j = 0; j < MapAtlasesConfig.mapUpdatePerTick.get(); ++j) {
                        selected = MapAtlasesServerEvents.getMapToUpdate(nearbyExistentMaps, player);
                        selected.updateMap(player);
                    }
                }
            }
            if (activeInfo != null && MapAtlasesServerEvents.isTimeToUpdate(activeInfo.data, (Player)player, slice, 5, 20)) {
                activeInfo.updateMap(player);
            }
            if (activeInfo != null) {
                nearbyExistentMaps.add(activeInfo);
            }
            for (MapDataHolder mapInfo : nearbyExistentMaps) {
                MapAtlasesAccessUtils.updateMapDataAndSync(mapInfo, player, atlas);
            }
            if (!MapAtlasesConfig.enableEmptyMapEntryAndFill.get().booleanValue() || MapAtlasItem.isLocked(atlas)) {
                return;
            }
            if (MapAtlasesServerEvents.isPlayerTooFarAway(activeKey, (Player)player, scaleWidth)) {
                MapAtlasesServerEvents.maybeCreateNewMapEntry(player, atlas, maps, slice, Mth.m_14107_((double)player.m_20185_()), Mth.m_14107_((double)player.m_20189_()));
            }
            discoveringEdges.removeIf(e -> nearbyExistentMaps.stream().anyMatch(d -> (float)d.data.f_77885_ == e.f_82470_ && (float)d.data.f_77886_ == e.f_82471_));
            for (Vec2 edge : discoveringEdges) {
                MapAtlasesServerEvents.maybeCreateNewMapEntry(player, atlas, maps, slice, (int)edge.f_82470_, (int)edge.f_82471_);
            }
        }
    }

    private static boolean isTimeToUpdate(MapItemSavedData data, Player player, Slice slice, int min, int max) {
        int i = 1 << data.f_77890_;
        int range = slice != null && MapAtlasesMod.SUPPLEMENTARIES ? SupplementariesCompat.getSliceReach() / i : 128 / i;
        Level level = player.f_19853_;
        int rx = level.f_46441_.m_216332_(-range, range);
        int rz = level.f_46441_.m_216332_(-range, range);
        int x = (int)Mth.m_14008_((double)((player.m_20185_() + (double)rx - (double)data.f_77885_) / (double)i + 64.0), (double)0.0, (double)127.0);
        int z = (int)Mth.m_14008_((double)((player.m_20189_() + (double)rz - (double)data.f_77886_) / (double)i + 64.0), (double)0.0, (double)127.0);
        boolean filled = data.f_77891_[x + z * 128] != 0;
        int interval = filled ? max : min;
        return level.m_46467_() % (long)interval == 0L;
    }

    private static MapDataHolder getMapToUpdate(List<MapDataHolder> nearbyExistentMaps, ServerPlayer player) {
        HashMap m = updateQueue.computeIfAbsent((Player)player, a -> new HashMap());
        HashSet<String> nearbyIds = new HashSet<String>();
        for (MapDataHolder holder : nearbyExistentMaps) {
            nearbyIds.add(holder.stringId);
            m.computeIfAbsent(holder.stringId, a -> new MapUpdateTicket(holder));
        }
        int px = player.m_146903_();
        int pz = player.m_146907_();
        Iterator it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry t = it.next();
            if (!nearbyIds.contains(t.getKey())) {
                it.remove();
                continue;
            }
            ((MapUpdateTicket)t.getValue()).updatePriority(px, pz);
        }
        MapUpdateTicket selected = m.values().stream().max(MapUpdateTicket.COMPARATOR).orElseThrow();
        selected.waitTime = 0;
        return selected.holder;
    }

    public static boolean isPlayerTooFarAway(MapKey key, Player player, int width) {
        return Mth.m_144952_((double)((double)key.mapX() - player.m_20185_())) + Mth.m_144952_((double)((double)key.mapZ() - player.m_20189_())) > (double)(width * width);
    }

    private static void maybeCreateNewMapEntry(ServerPlayer player, ItemStack atlas, MapCollectionCap maps, Slice slice, int destX, int destZ) {
        Level level = player.f_19853_;
        if (atlas.m_41783_() == null) {
            MapAtlasItem.setEmptyMaps(atlas, MapAtlasesConfig.pityActivationMapCount.get());
        }
        int emptyCount = MapAtlasItem.getEmptyMaps(atlas);
        boolean bypassEmptyMaps = MapAtlasesConfig.requireEmptyMapsToExpand.get() == false;
        boolean addedMap = false;
        if (!mutex.isLocked() && (emptyCount > 0 || player.m_7500_() || bypassEmptyMaps)) {
            byte scale;
            ItemStack newMap;
            Integer mapId;
            Integer height;
            mutex.lock();
            if (!player.m_7500_() && !bypassEmptyMaps) {
                MapAtlasItem.increaseEmptyMaps(atlas, -1);
            }
            if ((height = slice.height()) != null && !((TreeSet)maps.getHeightTree(player.f_19853_.m_46472_(), slice.type())).contains(height)) {
                boolean bl = true;
            }
            if ((mapId = MapItem.m_151131_((ItemStack)(newMap = slice.createNewMap(destX, destZ, scale = maps.getScale(), player.f_19853_)))) != null) {
                MapDataHolder newData = MapDataHolder.findFromId(level, mapId);
                if (newData != null) {
                    MapAtlasesAccessUtils.updateMapDataAndSync(newData, player, newMap);
                }
                addedMap = maps.add(mapId, level);
            }
            mutex.unlock();
        }
        if (addedMap) {
            player.f_19853_.m_5594_(null, player.m_20183_(), MapAtlasesMod.ATLAS_CREATE_MAP_SOUND_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    private static Set<Vec2> getPlayerDiscoveringMapEdges(int xCenter, int zCenter, int width, int xPlayer, int zPlayer, int reach) {
        int halfWidth = width / 2;
        HashSet<Vec2> results = new HashSet<Vec2>();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 && j == 0) continue;
                int qI = xCenter;
                int qJ = zCenter;
                if (i == -1 && xPlayer - reach <= xCenter - halfWidth) {
                    qI -= width;
                } else if (i == 1 && xPlayer + reach >= xCenter + halfWidth) {
                    qI += width;
                }
                if (j == -1 && zPlayer - reach <= zCenter - halfWidth) {
                    qJ -= width;
                } else if (j == 1 && zPlayer + reach >= zCenter + halfWidth) {
                    qJ += width;
                }
                if (qI == xCenter && qJ == zCenter) continue;
                results.add(new Vec2((float)qI, (float)qJ));
            }
        }
        return results;
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (MapAtlasesMod.MOONLIGHT) {
                MapAtlasesNetworking.sendToClientPlayer(sp, new S2CWorldHashPacket(sp));
            }
        }
    }

    private static class MapUpdateTicket {
        private static final Comparator<MapUpdateTicket> COMPARATOR = Comparator.comparingDouble(MapUpdateTicket::getPriority);
        private final MapDataHolder holder;
        private int waitTime = 20;
        private double lastDistance = 1000000.0;
        private double currentPriority;

        private MapUpdateTicket(MapDataHolder data) {
            this.holder = data;
        }

        public double getPriority() {
            return this.currentPriority;
        }

        public void updatePriority(int px, int pz) {
            ++this.waitTime;
            double distSquared = Mth.m_211589_((double)(px - this.holder.data.f_77885_), (double)(pz - this.holder.data.f_77886_));
            double distanceWeight = 20.0;
            double waitTimeWeight = 1.0;
            double deltaDist = distanceWeight * (this.lastDistance - distSquared);
            this.currentPriority = deltaDist + waitTimeWeight * (double)this.waitTime * (double)this.waitTime;
            this.lastDistance = distSquared;
        }
    }
}

