/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.client.MapAtlasesClient;
import pepjebs.mapatlases.item.MapAtlasItem;
import pepjebs.mapatlases.utils.MapAtlasesAccessUtils;

public class C2SCOpenAtlasScreenPacket {
    @Nullable
    private final BlockPos lecternPos;

    public C2SCOpenAtlasScreenPacket(FriendlyByteBuf buf) {
        this.lecternPos = buf.m_236860_(FriendlyByteBuf::m_130135_).orElse(null);
    }

    public C2SCOpenAtlasScreenPacket() {
        this((BlockPos)null);
    }

    public C2SCOpenAtlasScreenPacket(BlockPos lecternPos) {
        this.lecternPos = lecternPos;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_236835_(Optional.ofNullable(this.lecternPos), FriendlyByteBuf::m_130064_);
    }

    public void apply(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)context.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                MapAtlasesClient.openScreen(this.lecternPos);
            } else {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player == null) {
                    return;
                }
                ItemStack atlas = ItemStack.f_41583_;
                if (this.lecternPos != null) {
                    BlockEntity patt1985$temp = player.f_19853_.m_7702_(this.lecternPos);
                    if (patt1985$temp instanceof LecternBlockEntity) {
                        LecternBlockEntity le = (LecternBlockEntity)patt1985$temp;
                        atlas = le.m_59566_();
                    }
                } else {
                    atlas = MapAtlasesAccessUtils.getAtlasFromPlayerByConfig((Player)player);
                }
                if (atlas.m_41720_() instanceof MapAtlasItem) {
                    MapAtlasItem.syncAndOpenGui(player, atlas, this.lecternPos);
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

