/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.MapAtlasesMod;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.integration.MoonlightCompat;
import pepjebs.mapatlases.mixin.MapDataAccessor;

public class C2SMarkerPacket {
    private final ColumnPos pos;
    private final String mapId;
    private final String name;

    public C2SMarkerPacket(FriendlyByteBuf buf) {
        this.pos = this.fromLong(buf.readLong());
        this.mapId = buf.m_130277_();
        this.name = buf.m_236860_(FriendlyByteBuf::m_130277_).orElse(null);
    }

    public ColumnPos fromLong(long combinedValue) {
        int x = (int)combinedValue;
        int z = (int)(combinedValue >>> 32);
        return new ColumnPos(x, z);
    }

    public C2SMarkerPacket(ColumnPos pos, String map, @Nullable String name) {
        this.pos = pos;
        this.mapId = map;
        this.name = name;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeLong(this.pos.m_143200_());
        buf.m_130070_(this.mapId);
        buf.m_236835_(Optional.ofNullable(this.name), FriendlyByteBuf::m_130070_);
    }

    public void apply(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.f_19853_;
            MapItemSavedData data = level.m_7489_(this.mapId);
            if (data instanceof MapDataAccessor) {
                MapDataAccessor d = (MapDataAccessor)data;
                double d0 = (double)this.pos.f_140723_() + 0.5;
                double d1 = (double)this.pos.f_140724_() + 0.5;
                String str = MapAtlasesConfig.pinMarkerId.get();
                if (!str.isEmpty()) {
                    MutableComponent literal;
                    ResourceLocation id = new ResourceLocation(str);
                    MutableComponent mutableComponent = literal = this.name == null ? null : Component.m_237113_((String)this.name);
                    if (id.m_135827_().equals("minecraft")) {
                        Optional<MapDecoration.Type> opt = Arrays.stream(MapDecoration.Type.values()).filter(t -> t.toString().toLowerCase().equals(id.m_135815_())).findFirst();
                        opt.ifPresent(type -> d.invokeAddDecoration((MapDecoration.Type)type, (LevelAccessor)level, "pin_" + this.pos, d0, d1, 180.0, (Component)literal));
                    } else if (MapAtlasesMod.MOONLIGHT) {
                        MoonlightCompat.addDecoration(data, new BlockPos(this.pos.f_140723_(), 0, this.pos.f_140724_()), id, (Component)literal);
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

