/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.networking;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundMapItemDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.network.NetworkEvent;
import pepjebs.mapatlases.client.MapAtlasesClient;

public class S2CMapPacketWrapper {
    public final ClientboundMapItemDataPacket packet;
    public final ResourceLocation dimension;
    public final int centerX;
    public final int centerZ;

    public S2CMapPacketWrapper(MapItemSavedData data, ClientboundMapItemDataPacket packet) {
        this.packet = packet;
        this.centerX = data.f_77885_;
        this.centerZ = data.f_77886_;
        this.dimension = data.f_77887_.m_135782_();
    }

    public S2CMapPacketWrapper(FriendlyByteBuf buf) {
        this.dimension = buf.m_130281_();
        this.centerX = buf.m_130242_();
        this.centerZ = buf.m_130242_();
        this.packet = new ClientboundMapItemDataPacket(buf);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension);
        buf.m_130130_(this.centerX);
        buf.m_130130_(this.centerZ);
        this.packet.m_5779_(buf);
    }

    public void apply(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> MapAtlasesClient.handleMapPacketWrapperPacket(this));
        context.get().setPacketHandled(true);
    }
}

