/*
 * Decompiled with CFR 0.152.
 */
package pepjebs.mapatlases.utils;

import com.mojang.datafixers.util.Pair;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;
import pepjebs.mapatlases.capabilities.MapKey;
import pepjebs.mapatlases.config.MapAtlasesConfig;
import pepjebs.mapatlases.utils.MapType;
import pepjebs.mapatlases.utils.Slice;

public class MapDataHolder {
    public final int id;
    public final String stringId;
    public final MapItemSavedData data;
    public final Slice slice;
    public final MapType type;
    @Nullable
    public final Integer height;
    private static final ExecutorService EXECUTORS = Executors.newFixedThreadPool(6);

    public MapDataHolder(String name, MapItemSavedData data) {
        this(MapDataHolder.findMapIntFromString(name), name, data);
    }

    private MapDataHolder(int id, String stringId, MapItemSavedData data) {
        this.id = id;
        this.stringId = stringId;
        this.data = data;
        this.type = MapType.fromKey(stringId, data);
        this.height = this.type.getHeight(data);
        this.slice = Slice.of(this.type, this.height);
    }

    private static int findMapIntFromString(String id) {
        return Integer.parseInt(id.split("_")[1]);
    }

    @Nullable
    public static MapDataHolder findFromId(Level level, int id) {
        for (MapType t : MapType.values()) {
            Pair<String, MapItemSavedData> d = t.getMapData(level, id);
            if (d == null) continue;
            return new MapDataHolder(id, (String)d.getFirst(), (MapItemSavedData)d.getSecond());
        }
        return null;
    }

    public MapKey makeKey() {
        return MapKey.at(this.data.f_77890_, this.data.f_77885_, this.data.f_77886_, (ResourceKey<Level>)this.data.f_77887_, this.slice);
    }

    public void updateMap(ServerPlayer player) {
        if (MapAtlasesConfig.mapUpdateMultithreaded.get().booleanValue()) {
            EXECUTORS.submit(() -> ((MapItem)this.type.filled).m_42893_(player.f_19853_, (Entity)player, this.data));
        } else {
            ((MapItem)this.type.filled).m_42893_(player.f_19853_, (Entity)player, this.data);
        }
    }
}

