/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.reg.forge;

import corgitaco.enhancedcelestials.reg.RegistrationProvider;
import corgitaco.enhancedcelestials.reg.RegistryObject;
import corgitaco.enhancedcelestials.reg.forge.ForgeBusGetter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.DeferredRegister;

public class ForgeRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        DeferredRegister register = DeferredRegister.create(resourceKey, (String)modId);
        register.register(ForgeRegistrationFactory.getBus(modId));
        return new Provider(modId, register);
    }

    @Nonnull
    private static IEventBus getBus(String modId) {
        Optional containerOpt;
        if (modId.equals("minecraft")) {
            modId = "forge";
        }
        if ((containerOpt = ModList.get().getModContainerById(modId)).isEmpty()) {
            throw new NullPointerException("Cannot find mod container for id " + modId);
        }
        IEventBus modBus = ForgeBusGetter.getBus((ModContainer)containerOpt.get());
        if (modBus == null) {
            throw new NullPointerException("Cannot get the mod event bus for the mod container with the mod id of " + modId);
        }
        return modBus;
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final DeferredRegister<T> registry;
        private final Set<RegistryObject<T>> entries = new HashSet<RegistryObject<T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries);

        private Provider(String modId, DeferredRegister<T> registry) {
            this.modId = modId;
            this.registry = registry;
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public ResourceKey<? extends Registry<T>> getRegistryKey() {
            return this.registry.getRegistryKey();
        }

        @Override
        public Registry<T> getRegistry() {
            return (Registry)Provider.get(Registry.f_122897_, this.getRegistryKey());
        }

        private static <T> T get(Registry<T> registry, ResourceKey<?> key) {
            return (T)registry.m_6246_(key);
        }

        @Override
        public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> supplier) {
            final net.minecraftforge.registries.RegistryObject obj = this.registry.register(name, supplier);
            RegistryObject ro = new RegistryObject<I>(){

                @Override
                public ResourceKey<I> getResourceKey() {
                    return obj.getKey();
                }

                @Override
                public ResourceLocation getId() {
                    return obj.getId();
                }

                @Override
                public I get() {
                    return obj.get();
                }

                @Override
                public Holder<I> asHolder() {
                    return (Holder)obj.getHolder().orElseThrow();
                }
            };
            this.entries.add(ro);
            return ro;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }
    }
}

