/*
 * Decompiled with CFR 0.152.
 */
package com.matyrobbrt.gml.mappings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.matyrobbrt.gml.mappings.LoadedMappings;
import com.matyrobbrt.gml.mappings.ManifestMetaFile;
import com.matyrobbrt.gml.mappings.OfficialParser;
import com.matyrobbrt.gml.mappings.SrgParser;
import com.matyrobbrt.gml.mappings.VersionMetaFile;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.TypesafeMap;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.commons.codec.binary.Hex;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.slf4j.Logger;

public class MappingsProvider
implements GroovyObject {
    private static final Logger LOGGER;
    public static final MappingsProvider INSTANCE;
    private static final String PISTON_META = "https://piston-meta.mojang.com/mc/game/version_manifest_v2.json";
    private static final String MAPPINGS_THREAD = "GML Mappings Thread";
    private static final String VERSION_JSON = "version.json";
    private static final String OFFICIAL = "official.txt";
    private static final String MCPCONFIG_ZIP = "srg.zip";
    private static final String JOINED_PATH = "config/joined.tsrg";
    private static final Gson GSON;
    private final String version;
    private final Path gameDir;
    private final Path cacheDir;
    private final String mcpVersion;
    private final String mcpConfigURL;
    private final CompletableFuture<LoadedMappings> mappingsProvider;
    private boolean setup;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    private MappingsProvider() {
        InputStream is;
        block22: {
            MetaClass metaClass;
            boolean bl;
            String string;
            Path path;
            String string2;
            this.version = string2 = FMLLoader.versionInfo().mcVersion();
            Object t = Launcher.INSTANCE.environment().getProperty((TypesafeMap.Key)IndyInterface.bootstrap("cast", "()", 0, IEnvironment.Keys.GAMEDIR.get())).get();
            this.gameDir = IndyInterface.bootstrap("cast", "()", 0, t);
            this.cacheDir = path = this.gameDir.resolve("mod_data/gml");
            this.mcpVersion = string = FMLLoader.versionInfo().mcpVersion();
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.version, this.mcpVersion, this.version, this.mcpVersion}, new String[]{"https://maven.minecraftforge.net/de/oceanlabs/mcp/mcp_config/", "-", "/mcp_config-", "-", ".zip"});
            this.mcpConfigURL = IndyInterface.bootstrap("cast", "()", 0, gStringImpl);
            CompletableFuture completableFuture = new CompletableFuture();
            this.mappingsProvider = completableFuture;
            this.setup = bl = false;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            is = this.getClass().getResourceAsStream("/mod_data_readme.txt");
            Throwable __$$primaryExc0 = null;
            try {
                try {
                    Files.createDirectories(this.cacheDir, new FileAttribute[0]);
                    Files.write(this.cacheDir.resolve("README"), is.readAllBytes(), new OpenOption[0]);
                }
                catch (Throwable __$$t0) {
                    Throwable throwable;
                    __$$primaryExc0 = throwable = __$$t0;
                    throw __$$t0;
                }
                if (!(__$$primaryExc0 != null)) break block22;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc0 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = is;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc0) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc0;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc0);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = is;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = is;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc0) {
                Object v4;
                Throwable throwable = __$$primaryExc0;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc0);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = is;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private Thread setupMappingsThread(Runnable runnable) {
        Thread mappingsThread = new Thread(runnable, MAPPINGS_THREAD);
        public final class _setupMappingsThread_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setupMappingsThread_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Boolean doCall(Object t, Object e) {
                MappingsProvider.pfaccess$0(null).error("Caught exception while setting up mappings...", (Throwable)((Object)IndyInterface.bootstrap("cast", "()", 0, e)));
                return ((MappingsProvider)this.getThisObject()).getMappingsProvider().complete(null);
            }

            @Generated
            public Boolean call(Object t, Object e) {
                return this.doCall(t, e);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setupMappingsThread_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                return MethodHandles.lookup();
            }
        }
        mappingsThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)((Object)IndyInterface.bootstrap("cast", "()", 0, new _setupMappingsThread_closure1(this, this))));
        return mappingsThread;
    }

    public synchronized void startMappingsSetup() {
        if (!this.setup) {
            boolean bl;
            this.setup = bl = true;
            URL url = new URL(PISTON_META);
            try {
                Reference connection = new Reference((Object)url.openConnection());
                ((URLConnection)connection.get()).connect();
                LOGGER.info("Starting runtime mappings setup...");
                public final class _startMappingsSetup_closure2
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference connection;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _startMappingsSetup_closure2(Object _outerInstance, Object _thisObject, Reference connection) {
                        super(_outerInstance, _thisObject);
                        Reference reference;
                        this.connection = reference = connection;
                    }

                    public Void doCall(Object it) {
                        InputStream manifestInput = ((URLConnection)this.connection.get()).getInputStream();
                        BufferedReader manifestReader = new BufferedReader(new InputStreamReader(manifestInput));
                        CallSite manifestMeta = IndyInterface.bootstrap("cast", "()", 0, MappingsProvider.pfaccess$1(null).fromJson((Reader)manifestReader, ManifestMetaFile.class));
                        public final class _closure7
                        extends Closure
                        implements GeneratedClosure {
                            private static /* synthetic */ ClassInfo $staticClassInfo;
                            public static transient /* synthetic */ boolean __$stMC;

                            public _closure7(Object _outerInstance, Object _thisObject) {
                                super(_outerInstance, _thisObject);
                            }

                            public Boolean doCall(Object it) {
                                return ScriptBytecodeAdapter.compareEqual((Object)((ManifestMetaFile.VersionMeta)it).getId(), (Object)((MappingsProvider)this.getThisObject()).getVersion());
                            }

                            @Generated
                            public Object call(Object args) {
                                return this.doCall(args);
                            }

                            @Generated
                            public Object call() {
                                return this.doCall(null);
                            }

                            @Generated
                            public Boolean doCall() {
                                return this.doCall(null);
                            }

                            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                if (((Object)((Object)this)).getClass() != _closure7.class) {
                                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                }
                                ClassInfo classInfo = $staticClassInfo;
                                if (classInfo == null) {
                                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                }
                                return classInfo.getMetaClass();
                            }

                            public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                return MethodHandles.lookup();
                            }
                        }
                        CallSite versionMeta = IndyInterface.bootstrap("cast", "()", 0, DefaultGroovyMethods.find(((ManifestMetaFile)((Object)manifestMeta)).getVersions(), (Closure)new _closure7((Object)this, this.getThisObject())));
                        if (!Files.exists(((MappingsProvider)this.getThisObject()).getCacheDir(), new LinkOption[0])) {
                            Files.createDirectories(((MappingsProvider)this.getThisObject()).getCacheDir(), new FileAttribute[0]);
                        }
                        MappingsProvider.pfaccess$0(null).info("Found version metadata from piston-meta.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).checkAndUpdateVersionFile((ManifestMetaFile.VersionMeta)((Object)versionMeta));
                        MappingsProvider.pfaccess$0(null).info("version.json is up to date.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).checkAndUpdateOfficialFile();
                        MappingsProvider.pfaccess$0(null).info("Official mappings are up to date.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).checkAndUpdateMCPConfigFile();
                        MappingsProvider.pfaccess$0(null).info("MCPConfig is up to date.");
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).loadLayeredMappings();
                        MappingsProvider.pfaccess$0(null).info("Finished runtime mappings setup.");
                        CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, null);
                        try {
                            return callSite;
                        }
                        catch (IOException e) {
                            throw (Throwable)e;
                        }
                        catch (NoSuchElementException e) {
                            throw (Throwable)e;
                        }
                    }

                    @Generated
                    public URLConnection getConnection() {
                        return IndyInterface.bootstrap("cast", "()", 0, this.connection.get());
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Void doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _startMappingsSetup_closure2.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Thread mappingsThread = this.setupMappingsThread((Runnable)((Object)new _startMappingsSetup_closure2(this, this, connection)));
                mappingsThread.start();
            }
            catch (IOException e) {
                LOGGER.info("Couldn't connect to piston-meta. Looking for cached file instead.");
                public final class _startMappingsSetup_closure3
                extends Closure
                implements GeneratedClosure {
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;

                    public _startMappingsSetup_closure3(Object _outerInstance, Object _thisObject) {
                        super(_outerInstance, _thisObject);
                    }

                    public Void doCall(Object it) {
                        ((MappingsProvider)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getThisObject()))).loadLayeredMappings();
                        MappingsProvider.pfaccess$0(null).info("Finished runtime mappings setup.");
                        return IndyInterface.bootstrap("cast", "()", 0, null);
                    }

                    @Generated
                    public Object call(Object args) {
                        return this.doCall(args);
                    }

                    @Generated
                    public Object call() {
                        return this.doCall(null);
                    }

                    @Generated
                    public Void doCall() {
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _startMappingsSetup_closure3.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    public /* synthetic */ MethodHandles.Lookup $getLookup() {
                        return MethodHandles.lookup();
                    }
                }
                Thread mappingsThread = this.setupMappingsThread((Runnable)((Object)new _startMappingsSetup_closure3(this, this)));
                mappingsThread.start();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadLayeredMappings() throws IOException {
        Throwable __$$primaryExc1;
        ZipFile zip;
        block108: {
            Path zipPath = this.cacheDir.resolve(MCPCONFIG_ZIP);
            Path officialPath = this.cacheDir.resolve(OFFICIAL);
            zip = new ZipFile(zipPath.toFile());
            __$$primaryExc1 = null;
            try {
                Throwable __$$primaryExc2;
                InputStream joined;
                block107: {
                    joined = zip.getInputStream(new ZipEntry(JOINED_PATH));
                    __$$primaryExc2 = null;
                    try {
                        Throwable __$$primaryExc3;
                        Reference srgParser;
                        block106: {
                            srgParser = new Reference((Object)new SrgParser(new BufferedReader(new InputStreamReader(joined))));
                            __$$primaryExc3 = null;
                            try {
                                Throwable __$$primaryExc4;
                                InputStream officialStream;
                                block105: {
                                    officialStream = Files.newInputStream(officialPath, new OpenOption[0]);
                                    __$$primaryExc4 = null;
                                    try {
                                        Reference officialParser = new Reference((Object)new OfficialParser(new BufferedReader(new InputStreamReader(officialStream))));
                                        Throwable __$$primaryExc5 = null;
                                        try {
                                            ((SrgParser)srgParser.get()).parse();
                                            ((OfficialParser)officialParser.get()).parse();
                                            Reference methodsMap = new Reference(new HashMap());
                                            Reference fieldsMap = new Reference(new HashMap());
                                            public final class _loadLayeredMappings_closure4
                                            extends Closure
                                            implements GeneratedClosure {
                                                private /* synthetic */ Reference srgParser;
                                                private /* synthetic */ Reference officialParser;
                                                private /* synthetic */ Reference methodsMap;
                                                private /* synthetic */ Reference fieldsMap;
                                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                                public static transient /* synthetic */ boolean __$stMC;

                                                public _loadLayeredMappings_closure4(Object _outerInstance, Object _thisObject, Reference srgParser, Reference officialParser, Reference methodsMap, Reference fieldsMap) {
                                                    super(_outerInstance, _thisObject);
                                                    Reference reference;
                                                    Reference reference2;
                                                    Reference reference3;
                                                    Reference reference4;
                                                    this.srgParser = reference4 = srgParser;
                                                    this.officialParser = reference3 = officialParser;
                                                    this.methodsMap = reference2 = methodsMap;
                                                    this.fieldsMap = reference = fieldsMap;
                                                }

                                                public Map<String, String> doCall(String official, String obf) {
                                                    Reference methods = new Reference(new HashMap());
                                                    Reference fields = new Reference(new HashMap());
                                                    Reference srgMethods = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ((SrgParser)this.srgParser.get()).getMethods().get(obf)));
                                                    Reference srgFields = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, ((SrgParser)this.srgParser.get()).getFields().get(obf)));
                                                    if ((Map)srgFields.get() == null || (Map)srgMethods.get() == null) {
                                                        return IndyInterface.bootstrap("cast", "()", 0, null);
                                                    }
                                                    public final class _closure8
                                                    extends Closure
                                                    implements GeneratedClosure {
                                                        private /* synthetic */ Reference srgFields;
                                                        private /* synthetic */ Reference fields;
                                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                                        public static transient /* synthetic */ boolean __$stMC;

                                                        public _closure8(Object _outerInstance, Object _thisObject, Reference srgFields, Reference fields) {
                                                            super(_outerInstance, _thisObject);
                                                            Reference reference;
                                                            Reference reference2;
                                                            this.srgFields = reference2 = srgFields;
                                                            this.fields = reference = fields;
                                                        }

                                                        public Void doCall(Object fMoj, Object fObf) {
                                                            CallSite srg = IndyInterface.bootstrap("cast", "()", 0, ((Map)this.srgFields.get()).get(fObf));
                                                            if (srg == null) {
                                                                return IndyInterface.bootstrap("cast", "()", 0, null);
                                                            }
                                                            return IndyInterface.bootstrap("cast", "()", 0, ((HashMap)this.fields.get()).put(fMoj, srg));
                                                        }

                                                        @Generated
                                                        public Void call(Object fMoj, Object fObf) {
                                                            return this.doCall(fMoj, fObf);
                                                        }

                                                        @Generated
                                                        public Object getSrgFields() {
                                                            return this.srgFields.get();
                                                        }

                                                        @Generated
                                                        public Object getFields() {
                                                            return this.fields.get();
                                                        }

                                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                            if (((Object)((Object)this)).getClass() != _closure8.class) {
                                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                            }
                                                            ClassInfo classInfo = $staticClassInfo;
                                                            if (classInfo == null) {
                                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                            }
                                                            return classInfo.getMetaClass();
                                                        }

                                                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                            return MethodHandles.lookup();
                                                        }
                                                    }
                                                    ((OfficialParser)this.officialParser.get()).getFields().get(obf).forEach((BiConsumer<String, String>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _closure8((Object)this, this.getThisObject(), srgFields, fields))));
                                                    public final class _closure9
                                                    extends Closure
                                                    implements GeneratedClosure {
                                                        private /* synthetic */ Reference srgMethods;
                                                        private /* synthetic */ Reference methods;
                                                        private static /* synthetic */ ClassInfo $staticClassInfo;
                                                        public static transient /* synthetic */ boolean __$stMC;

                                                        public _closure9(Object _outerInstance, Object _thisObject, Reference srgMethods, Reference methods) {
                                                            super(_outerInstance, _thisObject);
                                                            Reference reference;
                                                            Reference reference2;
                                                            this.srgMethods = reference2 = srgMethods;
                                                            this.methods = reference = methods;
                                                        }

                                                        public Void doCall(Object mMoj, Object mObf) {
                                                            public final class _closure10
                                                            extends Closure
                                                            implements GeneratedClosure {
                                                                private /* synthetic */ Reference srgMethods;
                                                                private static /* synthetic */ ClassInfo $staticClassInfo;
                                                                public static transient /* synthetic */ boolean __$stMC;

                                                                public _closure10(Object _outerInstance, Object _thisObject, Reference srgMethods) {
                                                                    super(_outerInstance, _thisObject);
                                                                    Reference reference;
                                                                    this.srgMethods = reference = srgMethods;
                                                                }

                                                                public Object doCall(Object it) {
                                                                    return ((Map)this.srgMethods.get()).get(it);
                                                                }

                                                                @Generated
                                                                public Object getSrgMethods() {
                                                                    return this.srgMethods.get();
                                                                }

                                                                @Generated
                                                                public Object call(Object args) {
                                                                    return this.doCall(args);
                                                                }

                                                                @Generated
                                                                public Object call() {
                                                                    return this.doCall(null);
                                                                }

                                                                @Generated
                                                                public Object doCall() {
                                                                    return this.doCall(null);
                                                                }

                                                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                                    if (((Object)((Object)this)).getClass() != _closure10.class) {
                                                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                                    }
                                                                    ClassInfo classInfo = $staticClassInfo;
                                                                    if (classInfo == null) {
                                                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                                    }
                                                                    return classInfo.getMetaClass();
                                                                }

                                                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                                    return MethodHandles.lookup();
                                                                }
                                                            }
                                                            List srg = DefaultGroovyMethods.collect((Iterable)((Object)IndyInterface.bootstrap("cast", "()", 0, mObf)), (Closure)new _closure10((Object)this, this.getThisObject(), this.srgMethods));
                                                            if (srg == null || srg.isEmpty()) {
                                                                return IndyInterface.bootstrap("cast", "()", 0, null);
                                                            }
                                                            return IndyInterface.bootstrap("cast", "()", 0, ((HashMap)this.methods.get()).put(mMoj, srg));
                                                        }

                                                        @Generated
                                                        public Void call(Object mMoj, Object mObf) {
                                                            return this.doCall(mMoj, mObf);
                                                        }

                                                        @Generated
                                                        public Object getSrgMethods() {
                                                            return this.srgMethods.get();
                                                        }

                                                        @Generated
                                                        public Object getMethods() {
                                                            return this.methods.get();
                                                        }

                                                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                            if (((Object)((Object)this)).getClass() != _closure9.class) {
                                                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                            }
                                                            ClassInfo classInfo = $staticClassInfo;
                                                            if (classInfo == null) {
                                                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                            }
                                                            return classInfo.getMetaClass();
                                                        }

                                                        public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                            return MethodHandles.lookup();
                                                        }
                                                    }
                                                    ((OfficialParser)this.officialParser.get()).getMethods().get(obf).forEach((BiConsumer<String, List<String>>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _closure9((Object)this, this.getThisObject(), srgMethods, methods))));
                                                    ((HashMap)this.methodsMap.get()).put(official.replace("/", "."), (HashMap)methods.get());
                                                    return IndyInterface.bootstrap("cast", "()", 0, ((HashMap)this.fieldsMap.get()).put(official.replace("/", "."), (HashMap)fields.get()));
                                                }

                                                @Generated
                                                public Map<String, String> call(String official, String obf) {
                                                    return this.doCall(official, obf);
                                                }

                                                @Generated
                                                public SrgParser getSrgParser() {
                                                    return IndyInterface.bootstrap("cast", "()", 0, this.srgParser.get());
                                                }

                                                @Generated
                                                public OfficialParser getOfficialParser() {
                                                    return IndyInterface.bootstrap("cast", "()", 0, this.officialParser.get());
                                                }

                                                @Generated
                                                public Object getMethodsMap() {
                                                    return this.methodsMap.get();
                                                }

                                                @Generated
                                                public Object getFieldsMap() {
                                                    return this.fieldsMap.get();
                                                }

                                                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                                                    if (((Object)((Object)this)).getClass() != _loadLayeredMappings_closure4.class) {
                                                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                                                    }
                                                    ClassInfo classInfo = $staticClassInfo;
                                                    if (classInfo == null) {
                                                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                                                    }
                                                    return classInfo.getMetaClass();
                                                }

                                                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                                                    return MethodHandles.lookup();
                                                }
                                            }
                                            ((OfficialParser)officialParser.get()).getClasses().forEach((BiConsumer<String, String>)((Object)IndyInterface.bootstrap("cast", "()", 0, new _loadLayeredMappings_closure4(this, this, srgParser, officialParser, methodsMap, fieldsMap))));
                                            this.mappingsProvider.complete(new LoadedMappings((HashMap)methodsMap.get(), (HashMap)fieldsMap.get()));
                                        }
                                        catch (Throwable __$$t5) {
                                            Throwable throwable;
                                            __$$primaryExc5 = throwable = __$$t5;
                                            throw __$$t5;
                                        }
                                        {
                                            catch (Throwable throwable) {
                                                Object v2;
                                                if (__$$primaryExc5 != null) {
                                                    try {
                                                        Object v0;
                                                        OfficialParser officialParser2 = (OfficialParser)officialParser.get();
                                                        if (officialParser2 != null) {
                                                            officialParser2.close();
                                                            v0 = null;
                                                            throw throwable;
                                                        }
                                                        v0 = null;
                                                        throw throwable;
                                                    }
                                                    catch (Throwable __$$suppressedExc5) {
                                                        Object v1;
                                                        Throwable throwable2 = __$$primaryExc5;
                                                        if (throwable2 != null) {
                                                            throwable2.addSuppressed(__$$suppressedExc5);
                                                            v1 = null;
                                                            throw throwable;
                                                        }
                                                        v1 = null;
                                                        throw throwable;
                                                    }
                                                }
                                                OfficialParser officialParser3 = (OfficialParser)officialParser.get();
                                                if (officialParser3 != null) {
                                                    officialParser3.close();
                                                    v2 = null;
                                                    throw throwable;
                                                }
                                                v2 = null;
                                                throw throwable;
                                            }
                                        }
                                        if (__$$primaryExc5 != null) {
                                            try {
                                                Object v3;
                                                OfficialParser officialParser4 = (OfficialParser)officialParser.get();
                                                if (officialParser4 != null) {
                                                    officialParser4.close();
                                                    v3 = null;
                                                    break block105;
                                                }
                                                v3 = null;
                                            }
                                            catch (Throwable __$$suppressedExc5) {
                                                Object v4;
                                                Throwable throwable = __$$primaryExc5;
                                                if (throwable != null) {
                                                    throwable.addSuppressed(__$$suppressedExc5);
                                                    v4 = null;
                                                    break block105;
                                                }
                                                v4 = null;
                                            }
                                            break block105;
                                        }
                                        OfficialParser officialParser5 = (OfficialParser)officialParser.get();
                                        if (officialParser5 != null) {
                                            officialParser5.close();
                                            v5 = null;
                                        } else {
                                            v5 = null;
                                        }
                                    }
                                    catch (Throwable __$$t4) {
                                        Throwable throwable;
                                        __$$primaryExc4 = throwable = __$$t4;
                                        throw __$$t4;
                                    }
                                }
                                if (__$$primaryExc4 != null) {
                                    try {
                                        Object v6;
                                        InputStream inputStream = officialStream;
                                        if (inputStream != null) {
                                            inputStream.close();
                                            v6 = null;
                                            break block106;
                                        }
                                        v6 = null;
                                    }
                                    catch (Throwable __$$suppressedExc4) {
                                        Object v7;
                                        Throwable throwable = __$$primaryExc4;
                                        if (throwable != null) {
                                            throwable.addSuppressed(__$$suppressedExc4);
                                            v7 = null;
                                            break block106;
                                        }
                                        v7 = null;
                                    }
                                    break block106;
                                }
                                InputStream inputStream = officialStream;
                                if (inputStream != null) {
                                    inputStream.close();
                                    v8 = null;
                                    break block106;
                                } else {
                                    v8 = null;
                                }
                                break block106;
                                catch (Throwable throwable) {
                                    Object v11;
                                    if (__$$primaryExc4 != null) {
                                        try {
                                            Object v9;
                                            InputStream inputStream2 = officialStream;
                                            if (inputStream2 != null) {
                                                inputStream2.close();
                                                v9 = null;
                                                throw throwable;
                                            }
                                            v9 = null;
                                            throw throwable;
                                        }
                                        catch (Throwable __$$suppressedExc4) {
                                            Object v10;
                                            Throwable throwable3 = __$$primaryExc4;
                                            if (throwable3 != null) {
                                                throwable3.addSuppressed(__$$suppressedExc4);
                                                v10 = null;
                                                throw throwable;
                                            }
                                            v10 = null;
                                            throw throwable;
                                        }
                                    }
                                    InputStream inputStream3 = officialStream;
                                    if (inputStream3 != null) {
                                        inputStream3.close();
                                        v11 = null;
                                        throw throwable;
                                    }
                                    v11 = null;
                                    throw throwable;
                                }
                            }
                            catch (Throwable __$$t3) {
                                Throwable throwable;
                                __$$primaryExc3 = throwable = __$$t3;
                                throw __$$t3;
                            }
                        }
                        if (__$$primaryExc3 != null) {
                            try {
                                Object v12;
                                SrgParser srgParser2 = (SrgParser)srgParser.get();
                                if (srgParser2 != null) {
                                    srgParser2.close();
                                    v12 = null;
                                    break block107;
                                }
                                v12 = null;
                            }
                            catch (Throwable __$$suppressedExc3) {
                                Object v13;
                                Throwable throwable = __$$primaryExc3;
                                if (throwable != null) {
                                    throwable.addSuppressed(__$$suppressedExc3);
                                    v13 = null;
                                    break block107;
                                }
                                v13 = null;
                            }
                            break block107;
                        }
                        SrgParser srgParser3 = (SrgParser)srgParser.get();
                        if (srgParser3 != null) {
                            srgParser3.close();
                            v14 = null;
                            break block107;
                        } else {
                            v14 = null;
                        }
                        break block107;
                        catch (Throwable throwable) {
                            Object v17;
                            if (__$$primaryExc3 != null) {
                                try {
                                    Object v15;
                                    SrgParser srgParser4 = (SrgParser)srgParser.get();
                                    if (srgParser4 != null) {
                                        srgParser4.close();
                                        v15 = null;
                                        throw throwable;
                                    }
                                    v15 = null;
                                    throw throwable;
                                }
                                catch (Throwable __$$suppressedExc3) {
                                    Object v16;
                                    Throwable throwable4 = __$$primaryExc3;
                                    if (throwable4 != null) {
                                        throwable4.addSuppressed(__$$suppressedExc3);
                                        v16 = null;
                                        throw throwable;
                                    }
                                    v16 = null;
                                    throw throwable;
                                }
                            }
                            SrgParser srgParser5 = (SrgParser)srgParser.get();
                            if (srgParser5 != null) {
                                srgParser5.close();
                                v17 = null;
                                throw throwable;
                            }
                            v17 = null;
                            throw throwable;
                        }
                    }
                    catch (Throwable __$$t2) {
                        Throwable throwable;
                        __$$primaryExc2 = throwable = __$$t2;
                        throw __$$t2;
                    }
                }
                if (__$$primaryExc2 != null) {
                    try {
                        Object v18;
                        InputStream inputStream = joined;
                        if (inputStream != null) {
                            inputStream.close();
                            v18 = null;
                            break block108;
                        }
                        v18 = null;
                    }
                    catch (Throwable __$$suppressedExc2) {
                        Object v19;
                        Throwable throwable = __$$primaryExc2;
                        if (throwable != null) {
                            throwable.addSuppressed(__$$suppressedExc2);
                            v19 = null;
                            break block108;
                        }
                        v19 = null;
                    }
                    break block108;
                }
                InputStream inputStream = joined;
                if (inputStream != null) {
                    inputStream.close();
                    v20 = null;
                    break block108;
                } else {
                    v20 = null;
                }
                break block108;
                catch (Throwable throwable) {
                    Object v23;
                    if (__$$primaryExc2 != null) {
                        try {
                            Object v21;
                            InputStream inputStream4 = joined;
                            if (inputStream4 != null) {
                                inputStream4.close();
                                v21 = null;
                                throw throwable;
                            }
                            v21 = null;
                            throw throwable;
                        }
                        catch (Throwable __$$suppressedExc2) {
                            Object v22;
                            Throwable throwable5 = __$$primaryExc2;
                            if (throwable5 != null) {
                                throwable5.addSuppressed(__$$suppressedExc2);
                                v22 = null;
                                throw throwable;
                            }
                            v22 = null;
                            throw throwable;
                        }
                    }
                    InputStream inputStream5 = joined;
                    if (inputStream5 != null) {
                        inputStream5.close();
                        v23 = null;
                        throw throwable;
                    }
                    v23 = null;
                    throw throwable;
                }
            }
            catch (Throwable __$$t1) {
                Throwable throwable;
                __$$primaryExc1 = throwable = __$$t1;
                throw __$$t1;
            }
        }
        if (__$$primaryExc1 != null) {
            try {
                ZipFile zipFile = zip;
                if (zipFile == null) return;
                zipFile.close();
                return;
            }
            catch (Throwable __$$suppressedExc1) {
                Throwable throwable = __$$primaryExc1;
                if (throwable == null) return;
                throwable.addSuppressed(__$$suppressedExc1);
                return;
            }
        }
        ZipFile zipFile = zip;
        if (zipFile == null) return;
        zipFile.close();
        return;
        catch (Throwable throwable) {
            Object v26;
            if (__$$primaryExc1 != null) {
                try {
                    Object v24;
                    ZipFile zipFile2 = zip;
                    if (zipFile2 != null) {
                        zipFile2.close();
                        v24 = null;
                        throw throwable;
                    }
                    v24 = null;
                    throw throwable;
                }
                catch (Throwable __$$suppressedExc1) {
                    Object v25;
                    Throwable throwable6 = __$$primaryExc1;
                    if (throwable6 != null) {
                        throwable6.addSuppressed(__$$suppressedExc1);
                        v25 = null;
                        throw throwable;
                    }
                    v25 = null;
                    throw throwable;
                }
            }
            ZipFile zipFile3 = zip;
            if (zipFile3 != null) {
                zipFile3.close();
                v26 = null;
                throw throwable;
            }
            v26 = null;
            throw throwable;
        }
    }

    private void checkAndUpdateVersionFile(ManifestMetaFile.VersionMeta versionMeta) throws IOException {
        InputStream versionStream;
        block24: {
            String sha1 = versionMeta.getSha1();
            Path versionJson = this.cacheDir.resolve(VERSION_JSON);
            if (Files.exists(versionJson, new LinkOption[0])) {
                byte[] existingSha1 = MappingsProvider.calcSha1(versionJson);
                byte[] knownSha1 = Hex.decodeHex((String)sha1);
                if (Arrays.equals(knownSha1, existingSha1)) {
                    return;
                }
            }
            versionStream = new URL(versionMeta.getUrl()).openStream();
            Throwable __$$primaryExc6 = null;
            try {
                try {
                    Files.copy(versionStream, versionJson, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable __$$t6) {
                    Throwable throwable;
                    __$$primaryExc6 = throwable = __$$t6;
                    throw __$$t6;
                }
                if (!(__$$primaryExc6 != null)) break block24;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc6 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = versionStream;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc6) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc6;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc6);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = versionStream;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = versionStream;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc6) {
                Object v4;
                Throwable throwable = __$$primaryExc6;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc6);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = versionStream;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private void checkAndUpdateMCPConfigFile() throws IOException {
        InputStream officialStream;
        block23: {
            Path srg = this.cacheDir.resolve(MCPCONFIG_ZIP);
            if (Files.exists(srg, new LinkOption[0])) {
                return;
            }
            officialStream = new URL(this.mcpConfigURL).openStream();
            Throwable __$$primaryExc7 = null;
            try {
                try {
                    Files.copy(officialStream, srg, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable __$$t7) {
                    Throwable throwable;
                    __$$primaryExc7 = throwable = __$$t7;
                    throw __$$t7;
                }
                if (!(__$$primaryExc7 != null)) break block23;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc7 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = officialStream;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc7) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc7;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc7);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = officialStream;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = officialStream;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc7) {
                Object v4;
                Throwable throwable = __$$primaryExc7;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc7);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = officialStream;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private void checkAndUpdateOfficialFile() throws IOException {
        InputStream officialStream;
        block24: {
            Path versionJson = this.cacheDir.resolve(VERSION_JSON);
            Reference versionMeta = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, GSON.fromJson((Reader)Files.newBufferedReader(versionJson), VersionMetaFile.class)));
            public final class _checkAndUpdateOfficialFile_closure5
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference versionMeta;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _checkAndUpdateOfficialFile_closure5(Object _outerInstance, Object _thisObject, Reference versionMeta) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.versionMeta = reference = versionMeta;
                }

                public String doCall() {
                    Dist __$$sev0 = FMLLoader.getDist();
                    Dist dist = __$$sev0;
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.CLIENT)) {
                        return ((VersionMetaFile)this.versionMeta.get()).getDownloads().getClient_mappings().getSha1();
                    }
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.DEDICATED_SERVER)) {
                        return ((VersionMetaFile)this.versionMeta.get()).getDownloads().getServer_mappings().getSha1();
                    }
                    return null;
                }

                @Generated
                public VersionMetaFile getVersionMeta() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkAndUpdateOfficialFile_closure5.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite sha1 = IndyInterface.bootstrap("cast", "()", 0, new _checkAndUpdateOfficialFile_closure5(this, this, versionMeta).call());
            public final class _checkAndUpdateOfficialFile_closure6
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference versionMeta;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _checkAndUpdateOfficialFile_closure6(Object _outerInstance, Object _thisObject, Reference versionMeta) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.versionMeta = reference = versionMeta;
                }

                public String doCall() {
                    Dist __$$sev1 = FMLLoader.getDist();
                    Dist dist = __$$sev1;
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.CLIENT)) {
                        return ((VersionMetaFile)this.versionMeta.get()).getDownloads().getClient_mappings().getUrl();
                    }
                    if (ScriptBytecodeAdapter.isCase((Object)dist, (Object)Dist.DEDICATED_SERVER)) {
                        return ((VersionMetaFile)this.versionMeta.get()).getDownloads().getServer_mappings().getUrl();
                    }
                    return null;
                }

                @Generated
                public VersionMetaFile getVersionMeta() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.versionMeta.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkAndUpdateOfficialFile_closure6.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                public /* synthetic */ MethodHandles.Lookup $getLookup() {
                    return MethodHandles.lookup();
                }
            }
            CallSite url = IndyInterface.bootstrap("cast", "()", 0, new _checkAndUpdateOfficialFile_closure6(this, this, versionMeta).call());
            Path official = this.cacheDir.resolve(OFFICIAL);
            if (Files.exists(official, new LinkOption[0])) {
                byte[] existingSha1 = MappingsProvider.calcSha1(official);
                byte[] knownSha1 = Hex.decodeHex((String)((Object)sha1));
                if (Arrays.equals(knownSha1, existingSha1)) {
                    return;
                }
            }
            officialStream = new URL((String)((Object)url)).openStream();
            Throwable __$$primaryExc8 = null;
            try {
                try {
                    Files.copy(officialStream, official, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable __$$t8) {
                    Throwable throwable;
                    __$$primaryExc8 = throwable = __$$t8;
                    throw __$$t8;
                }
                if (!(__$$primaryExc8 != null)) break block24;
            }
            catch (Throwable throwable) {
                if (__$$primaryExc8 != null) {
                    try {
                        Object v0;
                        InputStream inputStream = officialStream;
                        if (inputStream != null) {
                            inputStream.close();
                            v0 = null;
                        }
                        v0 = null;
                    }
                    catch (Throwable __$$suppressedExc8) {
                        Object v1;
                        Throwable throwable2 = __$$primaryExc8;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc8);
                            v1 = null;
                        }
                        v1 = null;
                    }
                } else {
                    InputStream inputStream = officialStream;
                    if (inputStream != null) {
                        inputStream.close();
                        v2 = null;
                    } else {
                        v2 = null;
                    }
                }
                throw throwable;
            }
            try {
                Object v3;
                InputStream inputStream = officialStream;
                if (inputStream != null) {
                    inputStream.close();
                    v3 = null;
                }
                v3 = null;
            }
            catch (Throwable __$$suppressedExc8) {
                Object v4;
                Throwable throwable = __$$primaryExc8;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc8);
                    v4 = null;
                }
                v4 = null;
            }
        }
        InputStream inputStream = officialStream;
        if (inputStream != null) {
            inputStream.close();
            v5 = null;
        } else {
            v5 = null;
        }
    }

    private static byte[] calcSha1(Path file) throws FileNotFoundException, IOException, NoSuchAlgorithmException {
        byte[] byArray;
        Throwable __$$primaryExc9;
        InputStream input;
        block24: {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            input = Files.newInputStream(file, new OpenOption[0]);
            __$$primaryExc9 = null;
            byte[] buffer = new byte[8192];
            int len = input.read(buffer);
            while (len != -1) {
                int n;
                sha1.update(buffer, 0, len);
                len = n = input.read(buffer);
            }
            byArray = sha1.digest();
            if (!(__$$primaryExc9 != null)) break block24;
            try {
                Object v0;
                InputStream inputStream = input;
                if (inputStream != null) {
                    inputStream.close();
                    v0 = null;
                }
                v0 = null;
            }
            catch (Throwable __$$suppressedExc9) {
                Object v1;
                Throwable throwable = __$$primaryExc9;
                if (throwable != null) {
                    throwable.addSuppressed(__$$suppressedExc9);
                    v1 = null;
                }
                v1 = null;
            }
        }
        InputStream inputStream = input;
        if (inputStream != null) {
            inputStream.close();
            v2 = null;
        } else {
            v2 = null;
        }
        try {
            try {
                return byArray;
            }
            catch (Throwable __$$t9) {
                Throwable throwable;
                __$$primaryExc9 = throwable = __$$t9;
                throw __$$t9;
            }
        }
        catch (Throwable throwable) {
            if (__$$primaryExc9 != null) {
                try {
                    Object v3;
                    InputStream inputStream2 = input;
                    if (inputStream2 != null) {
                        inputStream2.close();
                        v3 = null;
                    }
                    v3 = null;
                }
                catch (Throwable __$$suppressedExc9) {
                    Object v4;
                    Throwable throwable2 = __$$primaryExc9;
                    if (throwable2 != null) {
                        throwable2.addSuppressed(__$$suppressedExc9);
                        v4 = null;
                    }
                    v4 = null;
                }
            } else {
                InputStream inputStream3 = input;
                if (inputStream3 != null) {
                    inputStream3.close();
                    v5 = null;
                } else {
                    v5 = null;
                }
            }
            throw throwable;
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != MappingsProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public static /* synthetic */ MethodHandles.Lookup $getLookup() {
        return MethodHandles.lookup();
    }

    public static /* synthetic */ Logger pfaccess$0(MappingsProvider $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(MappingsProvider.class, MappingsProvider.class, (String)"LOGGER"));
    }

    public static /* synthetic */ Gson pfaccess$1(MappingsProvider $that) {
        return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.getField(MappingsProvider.class, MappingsProvider.class, (String)"GSON"));
    }

    public static /* synthetic */ String pfaccess$2(MappingsProvider $that) {
        return $that.version;
    }

    public static /* synthetic */ Path pfaccess$3(MappingsProvider $that) {
        return $that.cacheDir;
    }

    public static /* synthetic */ CompletableFuture<LoadedMappings> pfaccess$4(MappingsProvider $that) {
        return $that.mappingsProvider;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Gson gson;
        MappingsProvider mappingsProvider;
        Logger logger;
        LOGGER = logger = LogUtils.getLogger();
        INSTANCE = mappingsProvider = new MappingsProvider();
        GSON = gson = new GsonBuilder().setLenient().excludeFieldsWithoutExposeAnnotation().create();
    }

    @Generated
    public final String getVersion() {
        return this.version;
    }

    @Generated
    public final Path getGameDir() {
        return this.gameDir;
    }

    @Generated
    public final Path getCacheDir() {
        return this.cacheDir;
    }

    @Generated
    public final String getMcpVersion() {
        return this.mcpVersion;
    }

    @Generated
    public final String getMcpConfigURL() {
        return this.mcpConfigURL;
    }

    @Generated
    public final CompletableFuture<LoadedMappings> getMappingsProvider() {
        return this.mappingsProvider;
    }
}

