/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api;

import com.mojang.datafixers.util.Pair;
import io.github.lukebemish.dynamic_asset_generator.api.ResourceCache;
import io.github.lukebemish.dynamic_asset_generator.api.ServerPrePackRepository;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.impl.ModConfig;
import io.github.lukebemish.dynamic_asset_generator.impl.client.JsonResourceGeneratorReader;
import io.github.lukebemish.dynamic_asset_generator.impl.tags.TagBakery;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;

public class DataResourceCache
extends ResourceCache {
    public static final DataResourceCache INSTANCE = new DataResourceCache();
    private final List<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>> tagQueue = new ArrayList<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>>();

    private DataResourceCache() {
        TagBakery bakery = new TagBakery(this.tagQueue);
        this.planSource(bakery);
        this.planResetListener(bakery::reset);
        this.planSource(() -> new JsonResourceGeneratorReader(DataResourceCache.getSourceJsons()));
    }

    static Map<ResourceLocation, String> getSourceJsons() {
        HashMap<ResourceLocation, String> rls = new HashMap<ResourceLocation, String>();
        HashSet<ResourceLocation> available = new HashSet<ResourceLocation>();
        for (PackResources r : ServerPrePackRepository.getResources()) {
            if (r.m_8017_().equals(DynamicAssetGenerator.CLIENT_PACK) || r.m_8017_().equals(DynamicAssetGenerator.SERVER_PACK)) continue;
            for (String namespace : r.m_5698_(PackType.SERVER_DATA)) {
                for (ResourceLocation rl : r.m_214146_(PackType.SERVER_DATA, namespace, "dynamic_asset_generator", x -> x.toString().endsWith(".json"))) {
                    if (!r.m_7211_(PackType.SERVER_DATA, rl)) continue;
                    available.add(rl);
                }
            }
        }
        for (ResourceLocation rl : available) {
            try {
                InputStream resource = ServerPrePackRepository.getResource(rl);
                try {
                    String text = new String(resource.readAllBytes(), StandardCharsets.UTF_8);
                    rls.put(rl, text);
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Issues loading resource source jsons...");
            }
        }
        return rls;
    }

    @Override
    public boolean shouldCache() {
        return DynamicAssetGenerator.getConfig().cacheData();
    }

    @Override
    public Path cachePath() {
        return ModConfig.DATA_CACHE_FOLDER;
    }

    public void planTag(ResourceLocation tag, Pair<ResourceLocation, Supplier<Boolean>> p) {
        ResourceLocation rl = new ResourceLocation(tag.m_135827_(), "tags/" + tag.m_135815_() + ".json");
        this.tagQueue.add(() -> {
            HashMap<ResourceLocation, Set<ResourceLocation>> map = new HashMap<ResourceLocation, Set<ResourceLocation>>();
            if (((Boolean)((Supplier)p.getSecond()).get()).booleanValue()) {
                map.put(tag, Collections.singleton((ResourceLocation)p.getFirst()));
            }
            return map;
        });
    }

    public void planTag(ResourceLocation tag, Supplier<Set<ResourceLocation>> p) {
        ResourceLocation rl = new ResourceLocation(tag.m_135827_(), "tags/" + tag.m_135815_() + ".json");
        this.tagQueue.add(() -> {
            HashMap<ResourceLocation, Set> map = new HashMap<ResourceLocation, Set>();
            map.put(tag, (Set)p.get());
            return map;
        });
    }

    public void queueTags(Supplier<Map<ResourceLocation, Set<ResourceLocation>>> toQueue) {
        this.tagQueue.add(toQueue);
    }
}

