/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.datagen;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lukebemish.dynamic_asset_generator.api.client.datagen.TextureConfigProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.MustBeInvokedByOverriders;

@Deprecated(forRemoval=true, since="1.1.0")
public abstract class ImageSource {
    private final TextureConfigProvider provider;
    private final String type;

    protected ImageSource(TextureConfigProvider provider, String type) {
        this.provider = provider;
        this.type = type;
    }

    protected final void checkExists(ResourceLocation texture) {
        Preconditions.checkArgument((boolean)this.provider.checkTextureExists(texture), (String)"Texture at %s does not exist", (Object)texture);
    }

    @MustBeInvokedByOverriders
    JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type);
        return object;
    }

    public static final class ForegroundTransfer
    extends ImageSource {
        private ImageSource background = null;
        private ImageSource full = null;
        private ImageSource newBackground = null;
        private boolean trimTrailing = false;
        private boolean forceNeighbors = false;
        private boolean fillHoles = false;
        private int extendPaletteSize = 0;
        private float closeCutoff = 0.0f;

        ForegroundTransfer(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:foreground_transfer");
        }

        public ForegroundTransfer background(ImageSource background) {
            Preconditions.checkNotNull((Object)background, (Object)"Background source most not be null");
            this.background = background;
            return this;
        }

        public ForegroundTransfer full(ImageSource full) {
            Preconditions.checkNotNull((Object)full, (Object)"Full source most not be null");
            this.full = full;
            return this;
        }

        public ForegroundTransfer newBackground(ImageSource newBackground) {
            Preconditions.checkNotNull((Object)newBackground, (Object)"New Background source most not be null");
            this.newBackground = newBackground;
            return this;
        }

        public ForegroundTransfer trimTrailing(boolean trimTrailing) {
            this.trimTrailing = trimTrailing;
            return this;
        }

        public ForegroundTransfer forceNeighbors(boolean forceNeighbors) {
            this.forceNeighbors = forceNeighbors;
            return this;
        }

        public ForegroundTransfer fillHoles(boolean fillHoles) {
            this.fillHoles = fillHoles;
            return this;
        }

        public ForegroundTransfer extendPaletteSize(int extendPaletteSize) {
            Preconditions.checkArgument((extendPaletteSize >= 0 ? 1 : 0) != 0, (Object)"Extend Palette Size must be >= 0");
            this.extendPaletteSize = extendPaletteSize;
            return this;
        }

        public ForegroundTransfer extendPaletteSize(float closeCutoff) {
            Preconditions.checkArgument((closeCutoff >= 0.0f && closeCutoff <= 1.0f ? 1 : 0) != 0, (Object)"Close Cutoff must be between 0 and 1");
            this.closeCutoff = closeCutoff;
            return this;
        }

        @Override
        JsonObject toJson() {
            Preconditions.checkNotNull((Object)this.background, (Object)"No background source set");
            Preconditions.checkNotNull((Object)this.full, (Object)"No full source set");
            Preconditions.checkNotNull((Object)this.newBackground, (Object)"No new background source set");
            JsonObject object = super.toJson();
            object.add("background", (JsonElement)this.background.toJson());
            object.add("full", (JsonElement)this.full.toJson());
            object.add("new_background", (JsonElement)this.newBackground.toJson());
            object.addProperty("trim_trailing", Boolean.valueOf(this.trimTrailing));
            object.addProperty("force_neighbors", Boolean.valueOf(this.forceNeighbors));
            object.addProperty("fill_holes", Boolean.valueOf(this.fillHoles));
            object.addProperty("extend_palette_size", (Number)this.extendPaletteSize);
            object.addProperty("close_cutoff", (Number)Float.valueOf(this.closeCutoff));
            return object;
        }
    }

    public static final class CombinedPalettedImage
    extends ImageSource {
        private ImageSource overlay = null;
        private ImageSource background = null;
        private ImageSource paletted = null;
        private boolean includeBackground = false;
        private boolean stretchPaletted = false;
        private int extendPaletteSize = 0;

        CombinedPalettedImage(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:combined_paletted_image");
        }

        public CombinedPalettedImage overlay(ImageSource overlay) {
            Preconditions.checkNotNull((Object)overlay, (Object)"Overlay source most not be null");
            this.overlay = overlay;
            return this;
        }

        public CombinedPalettedImage background(ImageSource background) {
            Preconditions.checkNotNull((Object)background, (Object)"Background source most not be null");
            this.background = background;
            return this;
        }

        public CombinedPalettedImage paletted(ImageSource paletted) {
            Preconditions.checkNotNull((Object)paletted, (Object)"Paletted source most not be null");
            this.paletted = paletted;
            return this;
        }

        public CombinedPalettedImage includeBackground(boolean includeBackground) {
            this.includeBackground = includeBackground;
            return this;
        }

        public CombinedPalettedImage stretchPaletted(boolean stretchPaletted) {
            this.stretchPaletted = stretchPaletted;
            return this;
        }

        public CombinedPalettedImage extendPaletteSize(int extendPaletteSize) {
            this.extendPaletteSize = extendPaletteSize;
            return this;
        }

        @Override
        JsonObject toJson() {
            Preconditions.checkNotNull((Object)this.overlay, (Object)"No overlay source set");
            Preconditions.checkNotNull((Object)this.background, (Object)"No background source set");
            Preconditions.checkNotNull((Object)this.paletted, (Object)"No paletted source set");
            JsonObject object = super.toJson();
            object.add("overlay", (JsonElement)this.overlay.toJson());
            object.add("background", (JsonElement)this.background.toJson());
            object.add("paletted", (JsonElement)this.paletted.toJson());
            object.addProperty("include_background", Boolean.valueOf(this.includeBackground));
            object.addProperty("stretch_paletted", Boolean.valueOf(this.stretchPaletted));
            object.addProperty("extend_palette_size", (Number)this.extendPaletteSize);
            return object;
        }
    }

    public static final class Transform
    extends ImageSource {
        private ImageSource input = null;
        private int rotate = 0;
        private boolean flip = false;

        Transform(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:transform");
        }

        public Transform input(ImageSource input) {
            Preconditions.checkNotNull((Object)input, (Object)"Input source most not be null");
            this.input = input;
            return this;
        }

        public Transform rotate(int rotate) {
            this.rotate = rotate;
            return this;
        }

        public Transform flip(boolean flip) {
            this.flip = flip;
            return this;
        }

        @Override
        JsonObject toJson() {
            Preconditions.checkNotNull((Object)this.input, (Object)"No input source set");
            JsonObject object = super.toJson();
            object.add("input", (JsonElement)this.input.toJson());
            object.addProperty("rotate", (Number)this.rotate);
            object.addProperty("flip", Boolean.valueOf(this.flip));
            return object;
        }
    }

    public static final class Crop
    extends ImageSource {
        private ImageSource input = null;
        private int totalWidth = -1;
        private int startX = 0;
        private int startY = 0;
        private int sizeX = -1;
        private int sizeY = -1;

        Crop(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:crop");
        }

        public Crop input(ImageSource input) {
            Preconditions.checkNotNull((Object)input, (Object)"Input source most not be null");
            this.input = input;
            return this;
        }

        public Crop totalWidth(int totalWidth) {
            Preconditions.checkArgument((totalWidth > 0 ? 1 : 0) != 0, (Object)"Total width must be > 0");
            this.totalWidth = totalWidth;
            return this;
        }

        public Crop startX(int startX) {
            this.startX = startX;
            return this;
        }

        public Crop startY(int startY) {
            this.startY = startY;
            return this;
        }

        public Crop sizeX(int sizeX) {
            Preconditions.checkArgument((sizeX > 0 ? 1 : 0) != 0, (Object)"Size X must be > 0");
            this.sizeX = sizeX;
            return this;
        }

        public Crop sizeY(int sizeY) {
            Preconditions.checkArgument((sizeY > 0 ? 1 : 0) != 0, (Object)"Size Y must be > 0");
            this.sizeY = sizeY;
            return this;
        }

        @Override
        JsonObject toJson() {
            Preconditions.checkNotNull((Object)this.input, (Object)"No input source set");
            Preconditions.checkState((this.totalWidth != -1 ? 1 : 0) != 0, (Object)"No total width set");
            Preconditions.checkState((this.sizeX != -1 ? 1 : 0) != 0, (Object)"No size X set");
            Preconditions.checkState((this.sizeY != -1 ? 1 : 0) != 0, (Object)"No size Y set");
            JsonObject object = super.toJson();
            object.add("input", (JsonElement)this.input.toJson());
            object.addProperty("total_width", (Number)this.totalWidth);
            object.addProperty("start_x", (Number)this.startX);
            object.addProperty("start_y", (Number)this.startY);
            object.addProperty("size_x", (Number)this.sizeX);
            object.addProperty("size_y", (Number)this.sizeY);
            return object;
        }
    }

    public static final class Mask
    extends ImageSource {
        private ImageSource mask = null;
        private ImageSource input = null;

        Mask(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:mask");
        }

        public Mask mask(ImageSource mask) {
            Preconditions.checkNotNull((Object)mask, (Object)"Mask source most not be null");
            this.mask = mask;
            return this;
        }

        public Mask input(ImageSource input) {
            Preconditions.checkNotNull((Object)input, (Object)"Input source most not be null");
            this.input = input;
            return this;
        }

        @Override
        JsonObject toJson() {
            Preconditions.checkNotNull((Object)this.mask, (Object)"No mask source set");
            Preconditions.checkNotNull((Object)this.input, (Object)"No input source set");
            JsonObject object = super.toJson();
            object.add("mask", (JsonElement)this.mask.toJson());
            object.add("input", (JsonElement)this.input.toJson());
            return object;
        }
    }

    public static final class Overlay
    extends ImageSource {
        private final List<ImageSource> inputs = new ArrayList<ImageSource>();

        Overlay(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:overlay");
        }

        public Overlay input(ImageSource input) {
            Preconditions.checkNotNull((Object)input, (Object)"Input source most not be null");
            this.inputs.add(input);
            return this;
        }

        @Override
        JsonObject toJson() {
            JsonArray inputArray = new JsonArray(this.inputs.size());
            this.inputs.forEach(input -> inputArray.add((JsonElement)input.toJson()));
            JsonObject object = super.toJson();
            object.add("inputs", (JsonElement)inputArray);
            return object;
        }
    }

    public static final class Color
    extends ImageSource {
        private final List<Integer> colors = new ArrayList<Integer>();

        Color(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:color");
        }

        public Color color(int color) {
            this.colors.add(color);
            return this;
        }

        @Override
        JsonObject toJson() {
            JsonArray colorArray = new JsonArray(this.colors.size());
            this.colors.forEach(arg_0 -> ((JsonArray)colorArray).add(arg_0));
            JsonObject object = super.toJson();
            object.add("color", (JsonElement)colorArray);
            return object;
        }
    }

    public static final class Fallback
    extends ImageSource {
        private ImageSource original = null;
        private ImageSource fallback = null;

        Fallback(TextureConfigProvider provider) {
            super(provider, "dynamic_asset_generator:fallback");
        }

        public Fallback fallback(ImageSource fallback) {
            Preconditions.checkNotNull((Object)fallback, (Object)"Fallback source most not be null");
            this.fallback = fallback;
            return this;
        }

        public Fallback original(ImageSource original) {
            Preconditions.checkNotNull((Object)original, (Object)"Original source most not be null");
            this.original = original;
            return this;
        }

        @Override
        JsonObject toJson() {
            Preconditions.checkNotNull((Object)this.original, (Object)"No original source set");
            Preconditions.checkNotNull((Object)this.fallback, (Object)"No fallback source set");
            JsonObject object = super.toJson();
            object.add("original", (JsonElement)this.original.toJson());
            object.add("fallback", (JsonElement)this.fallback.toJson());
            return object;
        }
    }

    public static final class File
    extends ImageSource {
        private final ResourceLocation path;

        File(TextureConfigProvider provider, ResourceLocation path) {
            super(provider, "dynamic_asset_generator:texture");
            Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
            this.checkExists(path);
            this.path = path;
        }

        @Override
        JsonObject toJson() {
            Preconditions.checkNotNull((Object)this.path, (Object)"No texture path set");
            JsonObject object = super.toJson();
            object.addProperty("path", this.path.toString());
            return object;
        }
    }
}

