/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.IResourceGenerator;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class DynamicTextureSource
implements IResourceGenerator {
    public static final Codec<DynamicTextureSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("output_location").forGetter(dyn -> dyn.outputLocation), (App)ITexSource.CODEC.fieldOf("input").forGetter(dyn -> dyn.input)).apply((Applicative)instance, DynamicTextureSource::new));
    private final ResourceLocation outputLocation;
    private final ITexSource input;
    private Supplier<NativeImage> source;

    public DynamicTextureSource(ResourceLocation outputLocation, ITexSource source) {
        this.input = source;
        this.outputLocation = outputLocation;
        if (this.input != null && outputLocation != null) {
            this.source = () -> this.input.getSupplier(new TexSourceDataHolder()).get();
        } else {
            DynamicAssetGenerator.LOGGER.error("Could not set up DynamicTextureSource: {}", (Object)this);
        }
    }

    @Override
    @NotNull
    public Supplier<InputStream> get(ResourceLocation outRl) {
        if (this.source == null) {
            return () -> null;
        }
        return () -> {
            try (NativeImage image = this.source.get();){
                if (image == null) return null;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(image.m_85121_());
                return byteArrayInputStream;
            }
            catch (IOException e) {
                DynamicAssetGenerator.LOGGER.error("Could not write image to stream: {}", (Object)outRl, (Object)e);
                return null;
            }
            catch (JsonSyntaxException e) {
                DynamicAssetGenerator.LOGGER.error("Issue loading texture source JSON for output: {}", (Object)outRl, (Object)e);
                return null;
            }
            catch (Exception remainder) {
                DynamicAssetGenerator.LOGGER.error("Issue creating texture from source JSON for output: {}", (Object)outRl, (Object)remainder);
            }
            return null;
        };
    }

    @Override
    public Set<ResourceLocation> getLocations() {
        return Set.of(this.getOutputLocation());
    }

    public ResourceLocation getOutputLocation() {
        return new ResourceLocation(this.outputLocation.m_135827_(), "textures/" + this.outputLocation.m_135815_() + ".png");
    }

    @Override
    public Codec<? extends IResourceGenerator> codec() {
        return CODEC;
    }
}

