/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.ClientRegisters;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.NotNull;

public interface ITexSource {
    public static final Codec<ITexSource> CODEC = ExtraCodecs.m_184415_(() -> new Codec<Codec<? extends ITexSource>>(){

        public <T> DataResult<Pair<Codec<? extends ITexSource>, T>> decode(DynamicOps<T> ops, T input) {
            return ResourceLocation.f_135803_.decode(ops, input).flatMap(keyValuePair -> !ClientRegisters.ITEXSOURCES.containsKey(keyValuePair.getFirst()) ? DataResult.error((String)("Unknown dynamic texture source type: " + keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> ClientRegisters.ITEXSOURCES.get(arg_0))));
        }

        public <T> DataResult<T> encode(Codec<? extends ITexSource> input, DynamicOps<T> ops, T prefix) {
            ResourceLocation key = (ResourceLocation)ClientRegisters.ITEXSOURCES.inverse().get(input);
            if (key == null) {
                return DataResult.error((String)("Unregistered dynamic texture source type: " + input));
            }
            Object toMerge = ops.createString(key.toString());
            return ops.mergeToPrimitive(prefix, toMerge);
        }
    }).dispatch(ITexSource::codec, Function.identity());

    public static void register(ResourceLocation rl, Codec<? extends ITexSource> reader) {
        ClientRegisters.ITEXSOURCES.put((Object)rl, reader);
    }

    public Codec<? extends ITexSource> codec();

    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder var1) throws JsonSyntaxException;
}

