/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.AnimationSplittingSource;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record AnimationFrameCapture(String capture) implements ITexSource
{
    public static final Codec<AnimationFrameCapture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("capture").forGetter(AnimationFrameCapture::capture)).apply((Applicative)instance, AnimationFrameCapture::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        return () -> {
            AnimationSplittingSource.ImageCollection collection = data.get(AnimationSplittingSource.ImageCollection.class);
            if (collection == null) {
                data.getLogger().debug("No parent animation source to capture...");
                return null;
            }
            NativeImage image = collection.get(this.capture());
            if (image == null) {
                data.getLogger().debug("Key '{}' was not supplied to capture...", (Object)this.capture());
            }
            return image;
        };
    }
}

