/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ColorSource
implements ITexSource {
    public static final Codec<ColorSource> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.listOf().fieldOf("color").forGetter(s -> s.color)).apply((Applicative)instance, ColorSource::new));
    private final List<Integer> color;

    public ColorSource(List<Integer> color) {
        this.color = color;
    }

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        return () -> {
            int len = Math.min(16384, this.color.size());
            int sideLength = 0;
            for (int i = 0; i < 8; ++i) {
                sideLength = (int)Math.pow(2.0, i);
                if (Math.pow(2.0, i) * Math.pow(2.0, i) >= (double)len) break;
            }
            NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, sideLength, sideLength, false);
            block1: for (int y = 0; y < sideLength; ++y) {
                for (int x = 0; x < sideLength; ++x) {
                    if (x + sideLength * y >= len) break block1;
                    int hexColor = this.color.get(x + sideLength * y);
                    ColorHolder newColor = new ColorHolder((float)(hexColor >> 16 & 0xFF) / 255.0f, (float)(hexColor >> 8 & 0xFF) / 255.0f, (float)(hexColor & 0xFF) / 255.0f, (float)(hexColor >> 24 & 0xFF) / 255.0f);
                    out.m_84988_(x, y, ColorHolder.toColorInt(newColor));
                }
            }
            return out;
        };
    }
}

