/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.IPalettePlan;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class CombinedPaletteImage
implements ITexSource {
    public static final Codec<CombinedPaletteImage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITexSource.CODEC.fieldOf("overlay").forGetter(s -> s.overlay), (App)ITexSource.CODEC.fieldOf("background").forGetter(s -> s.background), (App)ITexSource.CODEC.fieldOf("paletted").forGetter(s -> s.paletted), (App)Codec.BOOL.fieldOf("include_background").forGetter(s -> s.includeBackground), (App)Codec.BOOL.fieldOf("stretch_paletted").forGetter(s -> s.stretchPaletted), (App)Codec.INT.fieldOf("extend_palette_size").forGetter(s -> s.extendPaletteSize)).apply((Applicative)instance, CombinedPaletteImage::new));
    private final ITexSource overlay;
    private final ITexSource background;
    private final ITexSource paletted;
    private final boolean includeBackground;
    private final boolean stretchPaletted;
    private final int extendPaletteSize;

    public Codec<CombinedPaletteImage> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        PalettePlanner planner = PalettePlanner.of(this, data);
        if (planner == null) {
            return () -> null;
        }
        return () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
    }

    public CombinedPaletteImage(ITexSource overlay, ITexSource background, ITexSource paletted, boolean includeBackground, boolean stretchPaletted, int extendPaletteSize) {
        this.overlay = overlay;
        this.background = background;
        this.paletted = paletted;
        this.includeBackground = includeBackground;
        this.stretchPaletted = stretchPaletted;
        this.extendPaletteSize = extendPaletteSize;
    }

    public static class PalettePlanner
    implements IPalettePlan {
        private final CombinedPaletteImage info;
        private Supplier<NativeImage> overlay;
        private Supplier<NativeImage> background;
        private Supplier<NativeImage> paletted;

        private PalettePlanner(CombinedPaletteImage info) {
            this.info = info;
        }

        public static PalettePlanner of(CombinedPaletteImage info, TexSourceDataHolder data) {
            PalettePlanner out = new PalettePlanner(info);
            out.background = info.background.getSupplier(data);
            out.paletted = info.paletted.getSupplier(data);
            out.overlay = info.overlay.getSupplier(data);
            if (out.overlay == null || out.background == null || out.paletted == null) {
                return null;
            }
            return out;
        }

        @Override
        public boolean includeBackground() {
            return this.info.includeBackground;
        }

        @Override
        public boolean stretchPaletted() {
            return this.info.stretchPaletted;
        }

        @Override
        public int extend() {
            return this.info.extendPaletteSize;
        }
    }
}

