/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.Palette;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record PaletteSpreadSource(ITexSource source, float paletteCutoff, float lowerBound, float upperBound) implements ITexSource
{
    public static final Codec<PaletteSpreadSource> CODEC = RecordCodecBuilder.create(i -> i.group((App)ITexSource.CODEC.fieldOf("source").forGetter(PaletteSpreadSource::source), (App)Codec.FLOAT.optionalFieldOf("palette_cutoff", (Object)Float.valueOf(0.007843138f)).forGetter(PaletteSpreadSource::paletteCutoff), (App)Codec.FLOAT.optionalFieldOf("lower_bound", (Object)Float.valueOf(0.0f)).forGetter(PaletteSpreadSource::lowerBound), (App)Codec.FLOAT.optionalFieldOf("upper_bound", (Object)Float.valueOf(1.0f)).forGetter(PaletteSpreadSource::upperBound)).apply((Applicative)i, PaletteSpreadSource::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        return () -> {
            Supplier<NativeImage> source = this.source().getSupplier(data);
            try (NativeImage sourceImg = source.get();){
                if (sourceImg == null) {
                    data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source());
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                Palette palette = Palette.extractPalette(sourceImg, 0, this.paletteCutoff());
                NativeImage outImg = NativeImageHelper.of(NativeImage.Format.RGBA, sourceImg.m_84982_(), sourceImg.m_85084_(), false);
                int maxIndex = palette.getSize() - 1;
                float diff = this.upperBound() - this.lowerBound();
                for (int x = 0; x < sourceImg.m_84982_(); ++x) {
                    for (int y = 0; y < sourceImg.m_85084_(); ++y) {
                        ColorHolder original = ColorHolder.fromColorInt(sourceImg.m_84985_(x, y));
                        if (original.getA() == 0.0f) {
                            outImg.m_84988_(x, y, 0);
                            continue;
                        }
                        float ramp = (float)palette.closestTo(original) / (float)maxIndex;
                        float value = this.lowerBound() + diff * ramp;
                        outImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(value, value, value, original.getA())));
                    }
                }
                NativeImage nativeImage = outImg;
                return nativeImage;
            }
        };
    }
}

