/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.SafeImageExtraction;
import io.github.lukebemish.dynamic_asset_generator.impl.util.MultiCloser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public record AddMask(List<ITexSource> sources) implements ITexSource
{
    public static final Codec<AddMask> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ITexSource.CODEC.listOf().fieldOf("sources").forGetter(AddMask::sources)).apply((Applicative)instance, AddMask::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) {
        ArrayList<Supplier<NativeImage>> inputs = new ArrayList<Supplier<NativeImage>>();
        for (ITexSource o : this.sources()) {
            inputs.add(o.getSupplier(data));
        }
        return () -> {
            int maxX = 0;
            int maxY = 0;
            List<NativeImage> images = inputs.stream().map(Supplier::get).toList();
            for (int i = 0; i < images.size(); ++i) {
                if (images.get(i) != null) continue;
                data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.sources().get(i).toString());
                return null;
            }
            for (NativeImage image : images) {
                if (image.m_84982_() <= maxX) continue;
                maxX = image.m_84982_();
                maxY = image.m_85084_();
            }
            try (MultiCloser ignored = new MultiCloser(images);){
                int y;
                int x;
                NativeImage output = NativeImageHelper.of(NativeImage.Format.RGBA, maxX, maxY, false);
                NativeImage base = images.get(0);
                int xs = 1;
                int ys = 1;
                if ((double)base.m_84982_() / ((double)base.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                    xs = maxX / base.m_84982_();
                    ys = maxY / base.m_84982_();
                } else {
                    xs = maxX / base.m_85084_();
                    ys = maxY / base.m_85084_();
                }
                for (x = 0; x < maxX; ++x) {
                    for (y = 0; y < maxY; ++y) {
                        output.m_84988_(x, y, SafeImageExtraction.get(base, x / xs, y / ys));
                    }
                }
                for (x = 0; x < maxX; ++x) {
                    for (y = 0; y < maxY; ++y) {
                        ColorHolder colorHolder = SafeImageExtraction.getColor(base, x / xs, y / ys);
                        if (images.size() >= 2) {
                            for (int i = 1; i < images.size(); ++i) {
                                NativeImage image = images.get(i);
                                if ((double)image.m_84982_() / ((double)image.m_85084_() * 1.0) <= (double)maxX / ((double)maxY * 1.0)) {
                                    xs = maxX / image.m_84982_();
                                    ys = maxY / image.m_84982_();
                                } else {
                                    xs = maxX / image.m_85084_();
                                    ys = maxY / image.m_85084_();
                                }
                                ColorHolder top = ColorHolder.fromColorInt(SafeImageExtraction.get(image, x / xs, y / ys));
                                colorHolder = new ColorHolder(colorHolder.getR() + top.getR(), colorHolder.getG() + top.getG(), colorHolder.getB() + top.getB(), colorHolder.getA() + top.getA()).clamp();
                            }
                        }
                        output.m_84988_(x, y, colorHolder.toInt());
                    }
                }
                NativeImage nativeImage = output;
                return nativeImage;
            }
        };
    }
}

