/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public record CutoffMask(Channel channel, ITexSource source, float cutoff) implements ITexSource
{
    public static final Codec<CutoffMask> CODEC = RecordCodecBuilder.create(i -> i.group((App)StringRepresentable.m_216439_(Channel::values).optionalFieldOf("channel", (Object)Channel.ALPHA).forGetter(CutoffMask::channel), (App)ITexSource.CODEC.fieldOf("source").forGetter(CutoffMask::source), (App)Codec.FLOAT.optionalFieldOf("cutoff", (Object)Float.valueOf(0.5f)).forGetter(CutoffMask::cutoff)).apply((Applicative)i, CutoffMask::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        Supplier<NativeImage> input = this.source.getSupplier(data);
        return () -> {
            try (NativeImage inImg = (NativeImage)input.get();){
                if (inImg == null) {
                    data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source);
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                int width = inImg.m_84982_();
                int height = inImg.m_85084_();
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < width; ++y) {
                        ColorHolder source = ColorHolder.fromColorInt(inImg.m_84985_(x, y));
                        float value = this.channel.getter.apply(source).floatValue();
                        out.m_84988_(x, y, value > this.cutoff ? -1 : 0);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }

    static enum Channel implements StringRepresentable
    {
        ALPHA("alpha", c -> Float.valueOf(c.getA())),
        RED("red", c -> Float.valueOf(c.getR())),
        GREEN("green", c -> Float.valueOf(c.getG())),
        BLUE("blue", c -> Float.valueOf(c.getG())),
        HUE("hue", c -> Float.valueOf(c.toHLS().getH())),
        SATURATION("saturation", c -> Float.valueOf(c.toHLS().getS())),
        LIGHTNESS("lightness", c -> Float.valueOf(c.toHLS().getL()));

        public final String name;
        public final Function<ColorHolder, Float> getter;

        private Channel(String name, Function<ColorHolder, Float> getter) {
            this.name = name;
            this.getter = getter;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

