/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TexSourceDataHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public record EdgeMask(ITexSource source, boolean countOutsideFrame, List<Direction> edges, float cutoff) implements ITexSource
{
    public static final Codec<EdgeMask> CODEC = RecordCodecBuilder.create(i -> i.group((App)ITexSource.CODEC.fieldOf("source").forGetter(EdgeMask::source), (App)Codec.BOOL.optionalFieldOf("count_outside_frame", (Object)false).forGetter(EdgeMask::countOutsideFrame), (App)StringRepresentable.m_216439_(Direction::values).listOf().optionalFieldOf("edges", Arrays.stream(Direction.values()).toList()).forGetter(EdgeMask::edges), (App)Codec.FLOAT.optionalFieldOf("cutoff", (Object)Float.valueOf(0.5f)).forGetter(EdgeMask::cutoff)).apply((Applicative)i, EdgeMask::new));

    @Override
    public Codec<? extends ITexSource> codec() {
        return CODEC;
    }

    @Override
    @NotNull
    public Supplier<NativeImage> getSupplier(TexSourceDataHolder data) throws JsonSyntaxException {
        Supplier<NativeImage> input = this.source.getSupplier(data);
        int[] xs = this.edges.stream().mapToInt(e -> e.x).toArray();
        int[] ys = this.edges.stream().mapToInt(e -> e.y).toArray();
        return () -> {
            try (NativeImage inImg = (NativeImage)input.get();){
                if (inImg == null) {
                    data.getLogger().error("Texture given was nonexistent...\n{}", (Object)this.source);
                    NativeImage nativeImage = null;
                    return nativeImage;
                }
                int width = inImg.m_84982_();
                int height = inImg.m_85084_();
                NativeImage out = NativeImageHelper.of(NativeImage.Format.RGBA, width, height, false);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < width; ++y) {
                        boolean isEdge = false;
                        if (ColorHolder.fromColorInt(inImg.m_84985_(x, y)).getA() > this.cutoff) {
                            for (int i = 0; i < xs.length; ++i) {
                                int x1 = xs[i] + x;
                                int y1 = ys[i] + y;
                                if ((!this.countOutsideFrame || x1 >= 0 && y1 >= 0 && x1 <= width - 1 && y1 <= width - 1) && !(ColorHolder.fromColorInt(inImg.m_84985_(x1, y1)).getA() <= this.cutoff)) continue;
                                isEdge = true;
                            }
                        }
                        if (isEdge) {
                            out.m_84988_(x, y, -1);
                            continue;
                        }
                        out.m_84988_(x, y, 0);
                    }
                }
                NativeImage nativeImage = out;
                return nativeImage;
            }
        };
    }

    private static enum Direction implements StringRepresentable
    {
        NORTH(0, -1),
        NORTHEAST(1, -1),
        EAST(1, 0),
        SOUTHEAST(1, 1),
        SOUTH(0, 1),
        SOUTHWEST(-1, 1),
        WEST(-1, 0),
        NORTHWEST(-1, -1);

        public final int x;
        public final int y;

        private Direction(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

