/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.client;

import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;

public class ColorConversionUtils {
    private static final double refX = 0.9504699999999999;
    private static final double refY = 1.0;
    private static final double refZ = 1.08883;
    private static final float _L_scale = 100.0f;
    private static final float _a_scale = 255.0f;
    private static final float _b_scale = 255.0f;

    public static ColorHolder rgb2xyz(ColorHolder rgb) {
        double r = rgb.getR() > 0.04045f ? Math.pow((rgb.getR() + 0.055f) / 1.055f, 2.4f) : (double)(rgb.getR() / 12.92f);
        double g = rgb.getG() > 0.04045f ? Math.pow((rgb.getG() + 0.055f) / 1.055f, 2.4f) : (double)(rgb.getG() / 12.92f);
        double b = rgb.getB() > 0.04045f ? Math.pow((rgb.getB() + 0.055f) / 1.055f, 2.4f) : (double)(rgb.getB() / 12.92f);
        float x = (float)((double)0.4124f * r + (double)0.3576f * g + (double)0.1805f * b);
        float y = (float)((double)0.2126f * r + (double)0.7152f * g + (double)0.0722f * b);
        float z = (float)((double)0.0193f * r + (double)0.1192f * g + (double)0.9505f * b);
        return new ColorHolder(x, y, z);
    }

    public static ColorHolder xyz2rgb(ColorHolder xyz) {
        float r0 = 3.2406f * xyz.getX() - 1.5372f * xyz.getY() - 0.4986f * xyz.getZ();
        float g0 = -0.9689f * xyz.getX() + 1.8758f * xyz.getY() + 0.0415f * xyz.getZ();
        float b0 = 0.0557f * xyz.getX() - 0.204f * xyz.getY() + 1.057f * xyz.getZ();
        float r = r0 > 0.0031308f ? (float)((double)1.055f * Math.pow(r0, 0.4166666567325592) - (double)0.055f) : 12.92f * r0;
        float g = g0 > 0.0031308f ? (float)((double)1.055f * Math.pow(g0, 0.4166666567325592) - (double)0.055f) : 12.92f * g0;
        float b = b0 > 0.0031308f ? (float)((double)1.055f * Math.pow(b0, 0.4166666567325592) - (double)0.055f) : 12.92f * b0;
        return new ColorHolder(r, g, b);
    }

    public static ColorHolder xyz2lab(ColorHolder xyz) {
        double _x = (double)xyz.getX() / 0.9504699999999999;
        double _y = (double)xyz.getY() / 1.0;
        double _z = (double)xyz.getZ() / 1.08883;
        _x = _x > (double)0.008856f ? Math.cbrt(_x) : (double)7.787f * _x + 0.13793103396892548;
        _y = _y > (double)0.008856f ? Math.cbrt(_y) : (double)7.787f * _y + 0.13793103396892548;
        _z = _z > (double)0.008856f ? Math.cbrt(_z) : (double)7.787f * _z + 0.13793103396892548;
        double _L = 116.0 * _y - 16.0;
        double _a = 500.0 * (_x - _y);
        double _b = 200.0 * (_y - _z);
        return new ColorHolder((float)_L / 100.0f, (float)_a / 255.0f, (float)_b / 255.0f);
    }

    public static ColorHolder lab2xyz(ColorHolder lab) {
        double _y = (lab.get_L() * 100.0f + 16.0f) / 116.0f;
        double _x = (double)(lab.get_a() * 255.0f / 500.0f) + _y;
        double _z = _y - (double)(lab.get_b() * 255.0f / 200.0f);
        double x3 = _x * _x * _x;
        float x = (float)((x3 > (double)0.008856f ? x3 : (_x - 0.13793103396892548) / 7.787) * 0.9504699999999999);
        double y3 = _y * _y * _y;
        float y = (float)((y3 > (double)0.008856f ? y3 : (_y - 0.13793103396892548) / 7.787) * 1.0);
        double z3 = _z * _z * _z;
        float z = (float)((z3 > (double)0.008856f ? z3 : (_z - 0.13793103396892548) / 7.787) * 1.08883);
        return new ColorHolder(x, y, z);
    }

    public static ColorHolder rgb2lab(ColorHolder rgb) {
        return ColorConversionUtils.xyz2lab(ColorConversionUtils.rgb2xyz(rgb));
    }

    public static ColorHolder lab2rgb(ColorHolder lab) {
        return ColorConversionUtils.xyz2rgb(ColorConversionUtils.lab2xyz(lab));
    }
}

