/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.client;

import io.github.lukebemish.dynamic_asset_generator.api.IResourceGenerator;
import io.github.lukebemish.dynamic_asset_generator.api.client.AssetResourceCache;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.DynamicTextureSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.ITexSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.TextureMetaGenerator;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.AnimationFrameCapture;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.AnimationSplittingSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.ColorSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.CombinedPaletteImage;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.Crop;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.ErrorSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.FallbackSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.ForegroundTransfer;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.Mask;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.Overlay;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.PaletteSpreadSource;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.TextureReader;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.Transform;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask.AddMask;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask.CutoffMask;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask.EdgeMask;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask.GrowMask;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask.InvertMask;
import io.github.lukebemish.dynamic_asset_generator.api.client.generators.texsources.mask.MultiplyMask;
import io.github.lukebemish.dynamic_asset_generator.impl.platform.Services;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public class DynamicAssetGeneratorClient {
    private DynamicAssetGeneratorClient() {
    }

    public static void init() {
        IResourceGenerator.register(new ResourceLocation("dynamic_asset_generator", "texture"), DynamicTextureSource.CODEC);
        IResourceGenerator.register(new ResourceLocation("dynamic_asset_generator", "texture_meta"), TextureMetaGenerator.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "texture"), TextureReader.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "fallback"), FallbackSource.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "combined_paletted_image"), CombinedPaletteImage.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "overlay"), Overlay.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "mask"), Mask.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "crop"), Crop.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "transform"), Transform.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "foreground_transfer"), ForegroundTransfer.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "color"), ColorSource.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "animation_splitter"), AnimationSplittingSource.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "frame_capture"), AnimationFrameCapture.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "palette_spread"), PaletteSpreadSource.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "error"), ErrorSource.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "mask/cutoff"), CutoffMask.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "mask/edge"), EdgeMask.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "mask/grow"), GrowMask.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "mask/invert"), InvertMask.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "mask/add"), AddMask.CODEC);
        ITexSource.register(new ResourceLocation("dynamic_asset_generator", "mask/multiply"), MultiplyMask.CODEC);
        DynamicAssetGeneratorClient.testing();
    }

    private static void testing() {
        if (Services.PLATFORM.isDev()) {
            AssetResourceCache.INSTANCE.planSource(new DynamicTextureSource(new ResourceLocation("block/end_stone"), new ForegroundTransfer(new TextureReader(new ResourceLocation("block/stone")), new TextureReader(new ResourceLocation("block/redstone_ore")), new TextureReader(new ResourceLocation("block/end_stone")), 6, true, true, true, 0.2)));
            AssetResourceCache.INSTANCE.planSource(new DynamicTextureSource(new ResourceLocation("block/tuff"), new ForegroundTransfer(new TextureReader(new ResourceLocation("block/stone")), new TextureReader(new ResourceLocation("block/coal_ore")), new TextureReader(new ResourceLocation("block/end_stone")), 6, true, true, true, 0.2)));
            AssetResourceCache.INSTANCE.planSource(new DynamicTextureSource(new ResourceLocation("block/calcite"), new ForegroundTransfer(new TextureReader(new ResourceLocation("block/stone")), new TextureReader(new ResourceLocation("block/iron_ore")), new TextureReader(new ResourceLocation("block/end_stone")), 6, true, true, true, 0.2)));
            AssetResourceCache.INSTANCE.planSource(new DynamicTextureSource(new ResourceLocation("block/magma"), new AnimationSplittingSource(Map.of("magma", new AnimationSplittingSource.TimeAwareSource(new TextureReader(new ResourceLocation("block/magma")), 1), "prismarine", new AnimationSplittingSource.TimeAwareSource(new TextureReader(new ResourceLocation("block/prismarine")), 4)), new CombinedPaletteImage(new TextureReader(new ResourceLocation("dynamic_asset_generator", "empty")), new AnimationFrameCapture("prismarine"), new AnimationFrameCapture("magma"), false, true, 6))));
            AssetResourceCache.INSTANCE.planSource(new TextureMetaGenerator(List.of(new ResourceLocation("block/magma"), new ResourceLocation("block/prismarine")), Optional.of(new TextureMetaGenerator.AnimationData(Optional.empty(), Optional.empty(), Optional.of(new ResourceLocation("block/prismarine")), Optional.of(List.of(Integer.valueOf(1), Integer.valueOf(4))))), Optional.empty(), Optional.empty(), new ResourceLocation("block/magma")));
        }
    }
}

