/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.lukebemish.dynamic_asset_generator.api.IPathAwareInputStreamSource;
import io.github.lukebemish.dynamic_asset_generator.api.IResourceGenerator;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonResourceGeneratorReader
implements IPathAwareInputStreamSource {
    private final Map<ResourceLocation, IResourceGenerator> map = new HashMap<ResourceLocation, IResourceGenerator>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public JsonResourceGeneratorReader(Map<ResourceLocation, String> map) {
        map.forEach((rl, str) -> {
            try {
                IResourceGenerator json = JsonResourceGeneratorReader.fromJson(str);
                if (json != null && json.getLocations().size() > 0) {
                    json.getLocations().forEach(localRl -> this.map.put((ResourceLocation)localRl, json));
                }
            }
            catch (RuntimeException e) {
                DynamicAssetGenerator.LOGGER.error("Could not read json source at {}\n", rl, (Object)e);
            }
        });
    }

    @Nullable
    static IResourceGenerator fromJson(String json) throws JsonSyntaxException {
        JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
        return (IResourceGenerator)IResourceGenerator.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(false, s -> {});
    }

    @Override
    @NotNull
    public Supplier<InputStream> get(ResourceLocation outRl) {
        IResourceGenerator json = this.map.get(outRl);
        if (json != null) {
            return json.get(outRl);
        }
        return () -> null;
    }

    @Override
    public Set<ResourceLocation> getLocations() {
        return this.map.keySet();
    }
}

