/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import io.github.lukebemish.dynamic_asset_generator.impl.DynamicAssetGenerator;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.Palette;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.Clusterer;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PaletteExtractor
implements Closeable {
    private static final int[] X_SAMPLING_ORDER = new int[]{-1, -1, -1, 0, 0, 0, 1, 1, 1};
    private static final int[] Y_SAMPLING_ORDER = new int[]{-1, 0, 1, -1, 0, 1, -1, 0, 1};
    private boolean fillHoles = false;
    private final boolean[] hasLogged = new boolean[2];
    private final double closeCutoff;
    private final NativeImage background;
    private final NativeImage withOverlay;
    public final int extend;
    public final boolean trimTrailingPaletteLookup;
    private final boolean forceOverlayNeighbors;
    private NativeImage overlayImg;
    private NativeImage palettedImg;
    private static final float N_CUTOFF_SCALE = 1.5f;

    public PaletteExtractor(NativeImage background, NativeImage withOverlay, int extend, boolean trimTrailingPaletteLookup, boolean forceOverlayNeighbors, double closeCutoff) {
        this.background = background;
        this.withOverlay = withOverlay;
        this.extend = extend;
        this.trimTrailingPaletteLookup = trimTrailingPaletteLookup;
        this.forceOverlayNeighbors = forceOverlayNeighbors;
        this.closeCutoff = closeCutoff;
    }

    public NativeImage getOverlayImg() {
        return this.overlayImg;
    }

    public NativeImage getPalettedImg() {
        return this.palettedImg;
    }

    private void tryCloseOutputs() {
        if (this.palettedImg != null) {
            this.palettedImg.close();
            this.palettedImg = null;
        }
        if (this.overlayImg != null) {
            this.overlayImg.close();
            this.overlayImg = null;
        }
    }

    private Holder recalcImagesAlternate() {
        int bDim = Math.min(this.background.m_85084_(), this.background.m_84982_());
        int wDim = Math.min(this.withOverlay.m_85084_(), this.withOverlay.m_84982_());
        int dim = Math.max(bDim, wDim);
        int bs = dim / bDim;
        int ws = dim / wDim;
        NativeImage oImg = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
        NativeImage pImg = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
        Palette backgroundPalette = Palette.extractPalette(this.background, this.extend);
        Palette withOverlayPalette = Palette.extractPalette(this.withOverlay, 0);
        int backgroundPaletteSize = backgroundPalette.getSize();
        Palette nbColors = new Palette();
        withOverlayPalette.getStream().forEach(c -> {
            if (!backgroundPalette.isInPalette((ColorHolder)c)) {
                nbColors.tryAdd((ColorHolder)c);
            }
        });
        Clusterer clusterer = Clusterer.createFromPalettes(0.0, Clusterer.Cluster::minDist, backgroundPalette, nbColors);
        Palette fColors = new Palette();
        int bgCat = clusterer.getCategory(backgroundPalette.getColor(0));
        if (nbColors.getSize() != 0) {
            nbColors.getStream().forEach(c -> {
                if (clusterer.getCategory((ColorHolder)c) != bgCat) {
                    fColors.tryAdd((ColorHolder)c);
                }
            });
        }
        if (fColors.getSize() == 0 || nbColors.getSize() == 0) {
            for (int x = 0; x < dim; ++x) {
                for (int y = 0; y < dim; ++y) {
                    oImg.m_84988_(x, y, 0);
                    ColorHolder bC = ColorHolder.fromColorInt(this.background.m_84985_(x / bs, y / bs));
                    ColorHolder wC = ColorHolder.fromColorInt(this.withOverlay.m_84985_(x / ws, y / ws));
                    int wI = backgroundPalette.closestTo(wC);
                    int bI = backgroundPalette.closestTo(bC);
                    if (wI != bI) {
                        pImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)wI)));
                        continue;
                    }
                    pImg.m_84988_(x, y, 0);
                }
            }
            if (!this.hasLogged[0]) {
                DynamicAssetGenerator.LOGGER.warn("Supplied images for extraction contained no differing colors; only extracting palette shifts");
            }
            this.hasLogged[0] = true;
            return new Holder(oImg, pImg, false);
        }
        for (int x = 0; x < dim; ++x) {
            for (int y = 0; y < dim; ++y) {
                ColorHolder bC = ColorHolder.fromColorInt(this.background.m_84985_(x / bs, y / bs));
                ColorHolder wC = ColorHolder.fromColorInt(this.withOverlay.m_84985_(x / ws, y / ws));
                if (fColors.isInPalette(wC)) {
                    oImg.m_84988_(x, y, ColorHolder.toColorInt(wC.withA(1.0f)));
                    continue;
                }
                if (backgroundPalette.isInPalette(wC)) {
                    int bI;
                    int wI = backgroundPalette.closestTo(wC);
                    if (wI == (bI = backgroundPalette.closestTo(bC))) continue;
                    pImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)wI)));
                    continue;
                }
                int fIndex = 0;
                int bIndex = 0;
                double lowest = 200.0;
                float alpha = 0.0f;
                boolean skipO = false;
                float a = 0.1f;
                while (a <= 0.25f) {
                    for (int b = 0; b < backgroundPaletteSize; ++b) {
                        ColorHolder fColor;
                        ColorHolder bColor;
                        for (int f = 0; f < fColors.getSize(); ++f) {
                            bColor = backgroundPalette.getColor(b);
                            fColor = fColors.getColor(f);
                            double dist = wC.distanceToLab(ColorHolder.alphaBlend(fColor.withA(a), bColor));
                            if (!(dist < lowest)) continue;
                            lowest = dist;
                            alpha = a;
                            fIndex = f;
                            bIndex = b;
                            skipO = false;
                        }
                        for (int b1 = 0; b1 < backgroundPalette.getSize(); ++b1) {
                            bColor = backgroundPalette.getColor(b);
                            fColor = backgroundPalette.getColor(b1);
                            ColorHolder blend = ColorHolder.alphaBlend(fColor.withA(a), bColor);
                            double dist = wC.distanceToLab(blend);
                            if (!(dist < lowest)) continue;
                            lowest = dist;
                            alpha = a;
                            bIndex = backgroundPalette.closestTo(blend);
                            skipO = true;
                        }
                    }
                    a = (float)((double)a + 0.05);
                }
                for (int f = 0; f < fColors.getSize(); ++f) {
                    ColorHolder fColor = fColors.getColor(f);
                    double dist = wC.distanceToLab(fColor);
                    if (!(dist < lowest)) continue;
                    lowest = dist;
                    alpha = 1.0f;
                    fIndex = f;
                    skipO = false;
                }
                pImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)bIndex)));
                if (!skipO) {
                    oImg.m_84988_(x, y, fColors.getColor(fIndex).withA(alpha).toInt());
                }
                if (!(alpha >= 1.0f)) continue;
                pImg.m_84988_(x, y, new ColorHolder(0.0f).withA(0.0f).toInt());
            }
        }
        this.trimAndOverlay(dim, ws, oImg, pImg, this.withOverlay, backgroundPaletteSize, backgroundPalette);
        return new Holder(oImg, pImg, nbColors.dist(nbColors) < nbColors.dist(backgroundPalette));
    }

    private void trimAndOverlay(int dim, int ws, NativeImage oImg, NativeImage pImg, NativeImage wImg, int backgroundPaletteSize, Palette backgroundPalette) {
        if (this.trimTrailingPaletteLookup || this.forceOverlayNeighbors) {
            for (int x = 0; x < dim; ++x) {
                for (int y = 0; y < dim; ++y) {
                    boolean hasNeighbor = false;
                    boolean hasFullNeighbor = false;
                    for (int j = 0; j < X_SAMPLING_ORDER.length; ++j) {
                        int xt = x + X_SAMPLING_ORDER[j];
                        int yt = y + Y_SAMPLING_ORDER[j];
                        if (0 > xt || xt >= dim || 0 > yt || yt >= dim) continue;
                        if (ColorHolder.fromColorInt(oImg.m_84985_(xt, yt)).getA() != 0.0f) {
                            hasNeighbor = true;
                        }
                        if (ColorHolder.fromColorInt(oImg.m_84985_(xt, yt)).getA() != 1.0f) continue;
                        hasFullNeighbor = true;
                    }
                    if (this.trimTrailingPaletteLookup && !hasNeighbor) {
                        pImg.m_84988_(x, y, 0);
                    }
                    if (!this.forceOverlayNeighbors || !hasFullNeighbor || ColorHolder.fromColorInt(oImg.m_84985_(x, y)).getA() != 0.0f) continue;
                    ColorHolder wC = ColorHolder.fromColorInt(wImg.m_84985_(x / ws, y / ws));
                    pImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)backgroundPalette.closestTo(wC))));
                }
            }
        }
    }

    public void recalcImages() {
        int bDim = Math.min(this.background.m_85084_(), this.background.m_84982_());
        int wDim = Math.min(this.withOverlay.m_85084_(), this.withOverlay.m_84982_());
        int dim = Math.max(bDim, wDim);
        int bs = dim / bDim;
        int ws = dim / wDim;
        NativeImage oImg = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
        NativeImage pImg = NativeImageHelper.of(NativeImage.Format.RGBA, dim, dim, false);
        Palette backgroundPalette = Palette.extractPalette(this.background, this.extend);
        Palette withOverlayPalette = Palette.extractPalette(this.withOverlay, this.extend);
        int backgroundPaletteSize = backgroundPalette.getSize();
        double maxDiff = 0.0;
        for (ColorHolder c1 : withOverlayPalette.getStream().toList()) {
            for (ColorHolder c2 : withOverlayPalette.getStream().toList()) {
                double diff = c1.distanceToHybrid(c2);
                if (!(diff > maxDiff)) continue;
                maxDiff = diff;
            }
        }
        Palette frontColors = new Palette(0.007843138f);
        ArrayList<PostCalcEvent> postQueue = new ArrayList<PostCalcEvent>();
        for (int x = 0; x < dim; ++x) {
            for (int y = 0; y < dim; ++y) {
                ColorHolder bC = ColorHolder.fromColorInt(this.background.m_84985_(x / bs, y / bs));
                ColorHolder wC = ColorHolder.fromColorInt(this.withOverlay.m_84985_(x / ws, y / ws));
                if (backgroundPalette.isInPalette(wC)) {
                    int bI;
                    int wI = backgroundPalette.closestTo(wC);
                    if (wI == (bI = backgroundPalette.closestTo(bC))) continue;
                    pImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)wI)));
                    continue;
                }
                int distIndex = backgroundPalette.closestTo(wC);
                ColorHolder closestP = backgroundPalette.getColor(distIndex);
                if (closestP.distanceToHybrid(wC) <= this.closeCutoff * maxDiff * 1.5) {
                    pImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)distIndex)));
                    postQueue.add(new PostCalcEvent(x, y, wC, closestP.distanceToHybrid(wC)));
                    continue;
                }
                oImg.m_84988_(x, y, ColorHolder.toColorInt(wC));
                frontColors.tryAdd(wC);
            }
        }
        Holder alt = this.recalcImagesAlternate();
        if (frontColors.getSize() == 0) {
            if (!this.hasLogged[1]) {
                DynamicAssetGenerator.LOGGER.warn("Supplied images for extraction contained few differing colors; attempting clustering color extraction.");
            }
            this.hasLogged[1] = true;
            this.overlayImg = alt.o();
            this.palettedImg = alt.p();
            oImg.close();
            pImg.close();
            return;
        }
        if (frontColors.getSize() * backgroundPaletteSize * postQueue.size() > DynamicAssetGenerator.getConfig().paletteForceClusteringCutoff()) {
            if (!this.hasLogged[1]) {
                DynamicAssetGenerator.LOGGER.warn("Supplied images for extraction contained too many colors and were too high resolution to resolve post-calculation queue; attempting clustering color extraction.");
            }
            this.hasLogged[1] = true;
            this.overlayImg = alt.o();
            this.palettedImg = alt.p();
            oImg.close();
            pImg.close();
            return;
        }
        alt.close();
        this.runPostCalcQueue(oImg, pImg, backgroundPalette, backgroundPaletteSize, frontColors, postQueue);
        this.trimAndOverlay(dim, ws, oImg, pImg, this.withOverlay, backgroundPaletteSize, backgroundPalette);
        if ((this.trimTrailingPaletteLookup || this.forceOverlayNeighbors) && this.fillHoles) {
            ColorHolder overlay;
            int y;
            int x;
            int s = pImg.m_84982_();
            List<Pair> toSearch = List.of(new Pair((Object)0, (Object)1), new Pair((Object)0, (Object)-1), new Pair((Object)1, (Object)0), new Pair((Object)-1, (Object)0));
            HashMap<Pair, Float> alphaMap = new HashMap<Pair, Float>();
            for (x = 0; x < s; ++x) {
                for (y = 0; y < s; ++y) {
                    overlay = ColorHolder.fromColorInt(oImg.m_84985_(x, y));
                    alphaMap.put(new Pair((Object)x, (Object)y), Float.valueOf(overlay.getA()));
                    if (overlay.getA() != 1.0f || oImg.m_84985_(x, y) == this.withOverlay.m_84985_(x, y)) continue;
                    oImg.m_84988_(x, y, ColorHolder.fromColorInt(this.withOverlay.m_84985_(x, y)).withA(1.0f).toInt());
                }
            }
            while (true) {
                block7: for (x = 1; x < s - 1; ++x) {
                    for (y = 1; y < s - 1; ++y) {
                        overlay = ColorHolder.fromColorInt(oImg.m_84985_(x, y));
                        int count = 0;
                        int partialCount = 0;
                        for (Pair is : toSearch) {
                            ColorHolder c = ColorHolder.fromColorInt(oImg.m_84985_(x + (Integer)is.getFirst(), y + (Integer)is.getSecond()));
                            if (c.getA() == 1.0f) {
                                ++count;
                            }
                            if (!(c.getA() > 0.0f)) continue;
                            Pair pair = new Pair((Object)(x + (Integer)is.getFirst()), (Object)(y + (Integer)is.getSecond()));
                            if (!(((Float)alphaMap.get(pair)).floatValue() < 1.0f)) continue;
                            ++partialCount;
                        }
                        ColorHolder origC = ColorHolder.fromColorInt(this.withOverlay.m_84985_(x, y));
                        if (overlay.getA() == 1.0f || count < 3 && partialCount < 4 || backgroundPalette.isInPalette(origC, backgroundPalette.getCutoff())) continue;
                        int orig = this.withOverlay.m_84985_(x, y);
                        int i = 0;
                        while (true) {
                            if (i >= s) continue block7;
                            for (int j = 0; j < s; ++j) {
                                int c = this.withOverlay.m_84985_(i, j);
                                if (orig != c) continue;
                                oImg.m_84988_(i, j, origC.withA(1.0f).toInt());
                            }
                            ++i;
                        }
                    }
                }
                break;
            }
        }
        this.overlayImg = oImg;
        this.palettedImg = pImg;
    }

    private void runPostCalcQueue(NativeImage oImg, NativeImage pImg, Palette backgroundPalette, int backgroundPaletteSize, Palette frontColors, List<PostCalcEvent> postQueue) {
        for (PostCalcEvent e : postQueue) {
            int x = e.x();
            int y = e.y();
            ColorHolder wColor = e.wColor();
            int fIndex = 0;
            int bIndex = 0;
            double lowest = 200.0;
            float alpha = 0.0f;
            boolean skipO = false;
            float a = 0.1f;
            while (a <= 0.25f) {
                for (int b = 0; b < backgroundPaletteSize; ++b) {
                    ColorHolder fColor;
                    ColorHolder bColor;
                    for (int f = 0; f < frontColors.getSize(); ++f) {
                        bColor = backgroundPalette.getColor(b);
                        fColor = frontColors.getColor(f);
                        double dist = wColor.distanceToLab(ColorHolder.alphaBlend(fColor.withA(a), bColor));
                        if (!(dist < lowest)) continue;
                        lowest = dist;
                        alpha = a;
                        fIndex = f;
                        bIndex = b;
                        skipO = false;
                    }
                    for (int b1 = 0; b1 < backgroundPalette.getSize(); ++b1) {
                        bColor = backgroundPalette.getColor(b);
                        fColor = backgroundPalette.getColor(b1);
                        ColorHolder blend = ColorHolder.alphaBlend(fColor.withA(a), bColor);
                        double dist = wColor.distanceToLab(blend);
                        if (!(dist < lowest)) continue;
                        lowest = dist;
                        alpha = a;
                        bIndex = backgroundPalette.closestTo(blend);
                        skipO = true;
                    }
                }
                a = (float)((double)a + 0.05);
            }
            for (int f = 0; f < frontColors.getSize(); ++f) {
                ColorHolder fColor = frontColors.getColor(f);
                double dist = wColor.distanceToLab(fColor);
                if (!(dist < lowest)) continue;
                lowest = dist;
                alpha = 1.0f;
                fIndex = f;
                skipO = false;
            }
            pImg.m_84988_(x, y, ColorHolder.toColorInt(new ColorHolder(1.0f / (float)(backgroundPaletteSize - 1) * (float)bIndex)));
            if (!skipO) {
                oImg.m_84988_(x, y, ColorHolder.toColorInt(frontColors.getColor(fIndex).withA(alpha)));
            }
            int frontIndex = frontColors.closestTo(wColor);
            int closeIndex = backgroundPalette.closestTo(wColor);
            if (wColor.distanceToHybrid(backgroundPalette.getColor(closeIndex)) > wColor.distanceToHybrid(frontColors.getColor(frontIndex))) {
                oImg.m_84988_(x, y, ColorHolder.toColorInt(wColor.withA(1.0f)));
                alpha = 1.0f;
            }
            if (!(alpha >= 1.0f)) continue;
            pImg.m_84988_(x, y, new ColorHolder(0.0f).withA(0.0f).toInt());
        }
    }

    public PaletteExtractor fillHoles(boolean fillHoles) {
        this.fillHoles = fillHoles;
        return this;
    }

    @Override
    public void close() {
        this.tryCloseOutputs();
        if (this.background != null) {
            this.background.close();
        }
        if (this.withOverlay != null) {
            this.withOverlay.close();
        }
    }

    private record Holder(NativeImage o, NativeImage p, boolean shouldUse) implements Closeable
    {
        @Override
        public void close() {
            this.o.close();
            this.p.close();
        }
    }

    private record PostCalcEvent(int x, int y, ColorHolder wColor, double dist) {
    }
}

