/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.client.palette;

import io.github.lukebemish.dynamic_asset_generator.impl.client.ColorConversionUtils;
import java.util.Objects;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class ColorHolder
implements Comparable<ColorHolder> {
    private final float r;
    private final float g;
    private final float b;
    private final float a;
    private static final double HYBRID_W_LS = 2.0;
    private static final double HYBRID_W_LAB = 1.0;

    public static int toColorInt(ColorHolder color) {
        int ret = 0;
        ret |= (Math.round(Mth.m_14036_((float)(color.a * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 24;
        ret |= (Math.round(Mth.m_14036_((float)(color.b * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 16;
        ret |= (Math.round(Mth.m_14036_((float)(color.g * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF) << 8;
        return ret |= Math.round(Mth.m_14036_((float)(color.r * 255.0f), (float)0.0f, (float)255.0f)) & 0xFF;
    }

    public static ColorHolder fromColorInt(int color) {
        return new ColorHolder((float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f);
    }

    public ColorHolder(float v) {
        this.r = v;
        this.g = v;
        this.b = v;
        this.a = 1.0f;
    }

    public ColorHolder(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public ColorHolder clamp() {
        float a = this.getA();
        float r = this.getR();
        float g = this.getG();
        float b = this.getB();
        if (r > 1.0f) {
            r = 1.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        if (b > 1.0f) {
            b = 1.0f;
        }
        if (a > 1.0f) {
            a = 1.0f;
        }
        if (r < 0.0f) {
            r = 0.0f;
        }
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (b < 0.0f) {
            b = 0.0f;
        }
        if (a < 0.0f) {
            a = 0.0f;
        }
        return new ColorHolder(r, g, b, a);
    }

    public ColorHolder(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public float getR() {
        return this.r;
    }

    public float getG() {
        return this.g;
    }

    public float getB() {
        return this.b;
    }

    public float getA() {
        return this.a;
    }

    @Override
    public int compareTo(@NotNull ColorHolder o) {
        ColorHolder c1 = this.toCIELAB();
        ColorHolder c2 = o.toCIELAB();
        float mySum = c1.r;
        float otherSum = c2.r;
        if (mySum > otherSum) {
            return 1;
        }
        if (mySum < otherSum) {
            return -1;
        }
        return 0;
    }

    public static ColorHolder alphaBlend(ColorHolder over, ColorHolder under) {
        float a0 = over.a + under.a * (1.0f - over.a);
        float r0 = (over.r * over.a + under.r * under.a * (1.0f - over.a)) / a0;
        float g0 = (over.g * over.a + under.g * under.a * (1.0f - over.a)) / a0;
        float b0 = (over.b * over.a + under.b * under.a * (1.0f - over.a)) / a0;
        return new ColorHolder(r0, g0, b0, a0);
    }

    public ColorHolder withA(float a) {
        return new ColorHolder(this.r, this.g, this.b, a);
    }

    public double distanceToLS(ColorHolder c) {
        ColorHolder c1 = c.toHLS();
        ColorHolder c2 = this.toHLS();
        return Math.sqrt((c2.g - c1.g) * (c2.g - c1.g) + (c2.b - c1.b) * (c2.b - c1.b));
    }

    public double distanceToHybrid(ColorHolder c) {
        return (this.distanceToLS(c) * 2.0 + this.distanceToLab(c) * 1.0) / 3.0;
    }

    public double distanceToHLS(ColorHolder c) {
        ColorHolder c1 = c.toHLS();
        ColorHolder c2 = this.toHLS();
        return Math.sqrt((c2.r - c1.r) * (c2.r - c1.r) + (c2.g - c1.g) * (c2.g - c1.g) + (c2.b - c1.b) * (c2.b - c1.b));
    }

    public double distanceToRGB(ColorHolder c) {
        ColorHolder c2 = this;
        return Math.sqrt((c2.r - c.r) * (c2.r - c.r) + (c2.g - c.g) * (c2.g - c.g) + (c2.b - c.b) * (c2.b - c.b));
    }

    public double distanceToLab(ColorHolder c) {
        return this.distanceToLab(c, 1.0f);
    }

    public double euDistanceToLab(ColorHolder c) {
        ColorHolder c1 = c.toCIELAB();
        ColorHolder c2 = this.toCIELAB();
        return Math.sqrt((c2.g - c1.g) * (c2.g - c1.g) + (c2.b - c1.b) * (c2.b - c1.b) + (c2.r - c1.r) * (c2.r - c1.r));
    }

    public double distanceToLab(ColorHolder c, float weightL) {
        ColorHolder c1 = c.toCIELAB();
        ColorHolder c2 = this.toCIELAB();
        return Math.sqrt((c2.g - c1.g) * (c2.g - c1.g) + (c2.b - c1.b) * (c2.b - c1.b)) + (double)(Math.abs(c2.r - c1.r) / 2.0f * weightL);
    }

    public ColorHolder toHLS() {
        float l;
        float max = ColorHolder.max(this.r, this.g, this.b);
        float min = ColorHolder.min(this.r, this.g, this.b);
        float s = l = (max + min) / 2.0f;
        float h = l;
        if (max == min) {
            s = 0.0f;
            h = 0.0f;
        } else {
            float d = max - min;
            float f = s = (double)l > 0.5 ? d / (2.0f - max - min) : d / (max + min);
            int m = max == this.r ? 0 : (max == this.g ? 1 : 2);
            h = switch (m) {
                case 0 -> (this.g - this.b) / d + (float)(this.g < this.b ? 6 : 0);
                case 1 -> (this.b - this.r) / d + 2.0f;
                default -> (this.r - this.g) / d + 4.0f;
            };
            h /= 6.0f;
        }
        return new ColorHolder(h, l, s);
    }

    public ColorHolder fromHLS() {
        float _c;
        float _d;
        float _e;
        float h = this.r;
        float l = this.g;
        float s = this.b;
        if (s == 0.0f) {
            _d = _e = l;
            _c = _e;
        } else {
            float _a = (double)l < 0.5 ? l * (1.0f + s) : l + s - l * s;
            float _b = 2.0f * l - _a;
            _c = ColorHolder.hlsRgbHelper(_b, _a, h + 0.33333334f);
            _d = ColorHolder.hlsRgbHelper(_b, _a, h);
            _e = ColorHolder.hlsRgbHelper(_b, _a, h - 0.33333334f);
        }
        return new ColorHolder(_c, _d, _e);
    }

    private static float hlsRgbHelper(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }

    public ColorHolder toCIELAB() {
        return ColorConversionUtils.rgb2lab(this);
    }

    public ColorHolder fromCIELAB() {
        return ColorConversionUtils.lab2rgb(this);
    }

    private static float max(float a, float b, float c) {
        return Math.max(Math.max(a, b), c);
    }

    private static float min(float a, float b, float c) {
        return Math.min(Math.min(a, b), c);
    }

    public float get_L() {
        return this.r;
    }

    public float get_a() {
        return this.g;
    }

    public float get_b() {
        return this.b;
    }

    public float getH() {
        return this.r;
    }

    public float getL() {
        return this.g;
    }

    public float getS() {
        return this.b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColorHolder that = (ColorHolder)o;
        return that.r == this.r && that.g == this.g && that.b == this.b && that.a == this.a;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public float getX() {
        return this.r;
    }

    public float getY() {
        return this.g;
    }

    public float getZ() {
        return this.b;
    }

    public int toInt() {
        return ColorHolder.toColorInt(this);
    }
}

