/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.client.palette;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.lukebemish.dynamic_asset_generator.impl.client.NativeImageHelper;
import io.github.lukebemish.dynamic_asset_generator.impl.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.impl.client.util.IPalettePlan;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;

public class Palette {
    private final ArrayList<ColorHolder> colors;
    private final float inPaletteCutoff;
    public static final float DEFAULT_CUTOFF = 0.007843138f;

    public Palette(float inPaletteCutoff) {
        this.colors = new ArrayList();
        this.inPaletteCutoff = inPaletteCutoff;
    }

    public Palette(List<ColorHolder> colors) {
        this.colors = new ArrayList<ColorHolder>(colors);
        this.colors.sort(ColorHolder::compareTo);
        this.inPaletteCutoff = 0.007843138f;
    }

    public Palette() {
        this(0.007843138f);
    }

    public ColorHolder getCentroid() {
        AtomicReference<Float> x = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> y = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Float> z = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicInteger count = new AtomicInteger();
        this.getStream().forEach(c -> {
            x.updateAndGet(v -> Float.valueOf(v.floatValue() + c.getR()));
            y.updateAndGet(v -> Float.valueOf(v.floatValue() + c.getG()));
            z.updateAndGet(v -> Float.valueOf(v.floatValue() + c.getB()));
            count.getAndIncrement();
        });
        int c2 = count.get();
        return new ColorHolder(x.get().floatValue() / (float)c2, y.get().floatValue() / (float)c2, z.get().floatValue() / (float)c2);
    }

    public double getStdDev() {
        AtomicReference<Double> sum = new AtomicReference<Double>(0.0);
        ColorHolder c = this.getCentroid();
        this.getStream().forEach(x -> {
            double d = c.distanceToLab((ColorHolder)x);
            sum.updateAndGet(v -> v + d * d);
        });
        return Math.sqrt(sum.get());
    }

    public boolean isInPalette(ColorHolder color) {
        return this.isInPalette(color, this.inPaletteCutoff);
    }

    public boolean isInPalette(ColorHolder color, float cutoff) {
        if (color.getA() == 0.0f) {
            return false;
        }
        for (ColorHolder c : this.colors) {
            if (!(Math.abs(c.getR() - color.getR()) < cutoff) || !(Math.abs(c.getG() - color.getG()) < cutoff) || !(Math.abs(c.getB() - color.getB()) < cutoff)) continue;
            return true;
        }
        return false;
    }

    public ColorHolder getColor(int i) {
        return this.colors.get(i);
    }

    public Stream<ColorHolder> getStream() {
        return this.colors.stream();
    }

    public void tryAdd(ColorHolder c) {
        if (!this.isInPalette(c)) {
            this.colors.add(c);
            Collections.sort(this.colors);
        }
    }

    public ColorHolder averageColor() {
        int t = 0;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (ColorHolder c : this.colors) {
            ++t;
            r += c.getR();
            g += c.getG();
            b += c.getB();
        }
        return new ColorHolder(r / (float)t, g / (float)t, b / (float)t);
    }

    public int closestTo(ColorHolder holder) {
        int index = 0;
        int outIndex = 0;
        double minDist = 2.0;
        for (ColorHolder c : this.colors) {
            if (c.distanceToLab(holder) < minDist) {
                outIndex = index;
                minDist = c.distanceToLab(holder);
            }
            ++index;
        }
        return outIndex;
    }

    public static Palette extractPalette(NativeImage image, int extend, float inPaletteCutoff) {
        int w = image.m_84982_();
        int h = image.m_85084_();
        Palette palette = new Palette(inPaletteCutoff);
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int c_int = image.m_84985_(x, y);
                ColorHolder c = ColorHolder.fromColorInt(c_int);
                if (c.getA() == 0.0f || palette.isInPalette(c)) continue;
                palette.colors.add(new ColorHolder(c.getR(), c.getG(), c.getB()));
            }
        }
        palette.extendPalette(extend);
        return palette;
    }

    public static Palette extractPalette(NativeImage image, int extend) {
        return Palette.extractPalette(image, extend, 0.007843138f);
    }

    public Palette extendPalette(int extend) {
        Collections.sort(this.colors);
        while (this.colors.size() < extend) {
            ColorHolder high = this.colors.get(this.colors.size() - 1);
            ColorHolder low = this.colors.get(0);
            ColorHolder highNew = new ColorHolder(high.getR() * 0.9f + 0.1f, high.getG() * 0.9f + 0.1f, high.getB() * 0.9f + 0.1f);
            ColorHolder lowNew = new ColorHolder(low.getR() * 0.9f, low.getG() * 0.9f, low.getB() * 0.9f);
            this.colors.add(highNew);
            this.colors.add(0, lowNew);
        }
        return this;
    }

    public ColorHolder getColorAtRamp(float pos) {
        int index = Math.round(pos * (float)(this.colors.size() - 1));
        return this.colors.get(index);
    }

    public int getSize() {
        return this.colors.size();
    }

    public static NativeImage paletteCombinedImage(NativeImage bImg, NativeImage oImg, NativeImage pImg, IPalettePlan plan) {
        boolean includeBackground = plan.includeBackground();
        int extend = plan.extend();
        int oDim = Math.min(oImg.m_85084_(), oImg.m_84982_());
        int bDim = Math.min(bImg.m_85084_(), bImg.m_84982_());
        int pDim = Math.min(pImg.m_85084_(), pImg.m_84982_());
        int w = Math.max(oDim, Math.max(bDim, pDim));
        int os = w / oImg.m_84982_();
        int bs = w / bImg.m_84982_();
        int ps = w / pImg.m_84982_();
        NativeImage outImg = NativeImageHelper.of(NativeImage.Format.RGBA, w, w, false);
        Palette backgroundPalette = Palette.extractPalette(bImg, extend, 0.003921569f);
        ColorHolder maxPaletteKey = new ColorHolder(0.0f, 0.0f, 0.0f);
        ColorHolder minPaletteKey = new ColorHolder(1.0f, 1.0f, 1.0f);
        if (plan.stretchPaletted()) {
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < w; ++y) {
                    ColorHolder colorThis = ColorHolder.fromColorInt(pImg.m_84985_(x / ps, y / ps)).withA(1.0f);
                    if (colorThis.compareTo(maxPaletteKey) > 0) {
                        maxPaletteKey = colorThis;
                        continue;
                    }
                    if (colorThis.compareTo(minPaletteKey) >= 0) continue;
                    minPaletteKey = colorThis;
                }
            }
        }
        float maxAvg = (maxPaletteKey.getR() + maxPaletteKey.getG() + maxPaletteKey.getB()) / 3.0f;
        float minAvg = (minPaletteKey.getR() + minPaletteKey.getG() + minPaletteKey.getB()) / 3.0f;
        float range = maxAvg - minAvg;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < w; ++y) {
                ColorHolder outVal = includeBackground ? ColorHolder.fromColorInt(bImg.m_84985_(x / bs, y / bs)) : new ColorHolder(0.0f, 0.0f, 0.0f, 0.0f);
                ColorHolder pVal = ColorHolder.fromColorInt(pImg.m_84985_(x / ps, y / ps));
                if (pVal.getA() > 0.0f) {
                    float ramp = (pVal.getR() + pVal.getG() + pVal.getB()) / 3.0f;
                    if (maxAvg > 0.0f && minAvg < 1.0f && range > 0.0f) {
                        ramp = (ramp - minAvg) / range;
                    }
                    ColorHolder palettedColor = backgroundPalette.getColorAtRamp(ramp);
                    palettedColor = palettedColor.withA(pVal.getA());
                    outVal = ColorHolder.alphaBlend(palettedColor, outVal);
                }
                ColorHolder overlayC = ColorHolder.fromColorInt(oImg.m_84985_(x / os, y / os));
                outVal = ColorHolder.alphaBlend(overlayC, outVal);
                outImg.m_84988_(x, y, ColorHolder.toColorInt(outVal));
            }
        }
        return outImg;
    }

    public double dist(Palette other) {
        double d = 0.0;
        int c = 0;
        ColorHolder cent = other.getCentroid();
        for (ColorHolder c1 : this.colors) {
            ++c;
            d += c1.distanceToLS(cent);
        }
        return d / (double)c;
    }

    public float getCutoff() {
        return this.inPaletteCutoff;
    }
}

