/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.impl.tags;

import io.github.lukebemish.dynamic_asset_generator.api.IPathAwareInputStreamSource;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class TagBakery
implements IPathAwareInputStreamSource {
    private Map<ResourceLocation, List<Supplier<Set<ResourceLocation>>>> bakedTags;
    private final List<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>> tagQueue;

    public TagBakery(List<Supplier<Map<ResourceLocation, Set<ResourceLocation>>>> tagQueue) {
        this.tagQueue = tagQueue;
    }

    @Override
    @NotNull
    public Supplier<InputStream> get(ResourceLocation outRl) {
        return () -> {
            this.checkTags();
            return this.build(this.bakedTags.get(outRl));
        };
    }

    private InputStream build(List<Supplier<Set<ResourceLocation>>> paths) {
        StringBuilder internal = new StringBuilder();
        ArrayList toAdd = new ArrayList();
        for (Supplier<Set<ResourceLocation>> p : paths) {
            toAdd.addAll(p.get());
        }
        toAdd.forEach(rl -> {
            if (internal.length() >= 1) {
                internal.append(",\n");
            }
            internal.append("    \"").append(rl.m_135827_()).append(":").append(rl.m_135815_()).append("\"");
        });
        String json = "{\n  \"replace\":false,\n  \"values\":[" + internal + "\n]}";
        return new ByteArrayInputStream(json.getBytes());
    }

    @Override
    @NotNull
    public Set<ResourceLocation> getLocations() {
        this.checkTags();
        return this.bakedTags.keySet();
    }

    public void reset() {
        this.bakedTags = null;
    }

    public void checkTags() {
        if (this.bakedTags == null) {
            this.bakedTags = new HashMap<ResourceLocation, List<Supplier<Set<ResourceLocation>>>>();
            this.tagQueue.forEach(supplier -> {
                Map map = (Map)supplier.get();
                map.forEach((tag, set) -> {
                    ResourceLocation tagFile = new ResourceLocation(tag.m_135827_(), "tags/" + tag.m_135815_() + ".json");
                    List list = this.bakedTags.computeIfAbsent(tagFile, k -> new ArrayList());
                    list.add(() -> set);
                });
            });
        }
    }
}

